/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.gtfs.mapping;

import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import org.onebusaway.gtfs.model.Stop;
import org.onebusaway.gtfs.services.GtfsDao;
import org.onebusaway.gtfs.services.GtfsRelationalDao;
import org.opentripplanner.ext.fares.model.FareRulesData;
import org.opentripplanner.framework.application.OTPFeature;
import org.opentripplanner.graph_builder.issue.api.DataImportIssueStore;
import org.opentripplanner.gtfs.mapping.AgencyMapper;
import org.opentripplanner.gtfs.mapping.BoardingAreaMapper;
import org.opentripplanner.gtfs.mapping.BookingRuleMapper;
import org.opentripplanner.gtfs.mapping.CompactShape;
import org.opentripplanner.gtfs.mapping.DirectionMapper;
import org.opentripplanner.gtfs.mapping.EntranceMapper;
import org.opentripplanner.gtfs.mapping.FareAttributeMapper;
import org.opentripplanner.gtfs.mapping.FareLegRuleMapper;
import org.opentripplanner.gtfs.mapping.FareProductMapper;
import org.opentripplanner.gtfs.mapping.FareRuleMapper;
import org.opentripplanner.gtfs.mapping.FareTransferRuleMapper;
import org.opentripplanner.gtfs.mapping.FeedInfoMapper;
import org.opentripplanner.gtfs.mapping.FrequencyMapper;
import org.opentripplanner.gtfs.mapping.IdFactory;
import org.opentripplanner.gtfs.mapping.LocationGroupMapper;
import org.opentripplanner.gtfs.mapping.LocationMapper;
import org.opentripplanner.gtfs.mapping.PathwayMapper;
import org.opentripplanner.gtfs.mapping.PathwayNodeMapper;
import org.opentripplanner.gtfs.mapping.RouteMapper;
import org.opentripplanner.gtfs.mapping.ServiceCalendarDateMapper;
import org.opentripplanner.gtfs.mapping.ServiceCalendarMapper;
import org.opentripplanner.gtfs.mapping.ShapePointMapper;
import org.opentripplanner.gtfs.mapping.StationMapper;
import org.opentripplanner.gtfs.mapping.StopAreaMapper;
import org.opentripplanner.gtfs.mapping.StopMapper;
import org.opentripplanner.gtfs.mapping.StopTimeMapper;
import org.opentripplanner.gtfs.mapping.TransferMapper;
import org.opentripplanner.gtfs.mapping.TransferMappingResult;
import org.opentripplanner.gtfs.mapping.TranslationHelper;
import org.opentripplanner.gtfs.mapping.TripMapper;
import org.opentripplanner.model.impl.OtpTransitServiceBuilder;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.site.RegularStop;
import org.opentripplanner.transit.model.site.Station;
import org.opentripplanner.transit.model.site.StopTransferPriority;

public class GTFSToOtpTransitServiceMapper {
    private final AgencyMapper agencyMapper;
    private final StationMapper stationMapper;
    private final StopMapper stopMapper;
    private final EntranceMapper entranceMapper;
    private final PathwayNodeMapper pathwayNodeMapper;
    private final BoardingAreaMapper boardingAreaMapper;
    private final LocationMapper locationMapper;
    private final LocationGroupMapper locationGroupMapper;
    private final FareAttributeMapper fareAttributeMapper;
    private final ServiceCalendarDateMapper serviceCalendarDateMapper;
    private final FeedInfoMapper feedInfoMapper;
    private final ShapePointMapper shapePointMapper;
    private final ServiceCalendarMapper serviceCalendarMapper;
    private final PathwayMapper pathwayMapper;
    private final RouteMapper routeMapper;
    private final TripMapper tripMapper;
    private final BookingRuleMapper bookingRuleMapper;
    private final StopTimeMapper stopTimeMapper;
    private final FrequencyMapper frequencyMapper;
    private final FareRuleMapper fareRuleMapper;
    private final FareProductMapper fareProductMapper;
    private final FareLegRuleMapper fareLegRuleMapper;
    private final FareTransferRuleMapper fareTransferRuleMapper;
    private final DirectionMapper directionMapper;
    private final DataImportIssueStore issueStore;
    private final OtpTransitServiceBuilder builder;
    private final FareRulesData fareRulesBuilder = new FareRulesData();
    private final StopAreaMapper stopAreaMapper;
    private final TranslationHelper translationHelper;
    private final boolean discardMinTransferTimes;

    public GTFSToOtpTransitServiceMapper(OtpTransitServiceBuilder builder, String feedId, DataImportIssueStore issueStore, boolean discardMinTransferTimes, StopTransferPriority stationTransferPreference) {
        IdFactory idFactory = new IdFactory(feedId);
        this.issueStore = issueStore;
        this.builder = builder;
        Function<FeedScopedId, Station> stationLookup = id -> builder.getStations().get((FeedScopedId)id);
        Function<FeedScopedId, RegularStop> stopLookup = id -> builder.getStops().get((FeedScopedId)id);
        this.discardMinTransferTimes = discardMinTransferTimes;
        this.serviceCalendarMapper = new ServiceCalendarMapper(idFactory);
        this.serviceCalendarDateMapper = new ServiceCalendarDateMapper(idFactory);
        this.shapePointMapper = new ShapePointMapper(idFactory);
        this.translationHelper = new TranslationHelper();
        this.feedInfoMapper = new FeedInfoMapper(feedId);
        this.agencyMapper = new AgencyMapper(idFactory);
        this.stationMapper = new StationMapper(idFactory, this.translationHelper, stationTransferPreference);
        this.stopMapper = new StopMapper(idFactory, this.translationHelper, stationLookup, builder.siteRepository());
        this.entranceMapper = new EntranceMapper(idFactory, this.translationHelper, stationLookup);
        this.pathwayNodeMapper = new PathwayNodeMapper(idFactory, this.translationHelper, stationLookup);
        this.boardingAreaMapper = new BoardingAreaMapper(idFactory, this.translationHelper, stopLookup);
        this.locationMapper = new LocationMapper(idFactory, builder.siteRepository(), issueStore);
        this.locationGroupMapper = new LocationGroupMapper(idFactory, this.stopMapper, this.locationMapper, builder.siteRepository());
        this.pathwayMapper = new PathwayMapper(idFactory, this.stopMapper, this.entranceMapper, this.pathwayNodeMapper, this.boardingAreaMapper);
        this.routeMapper = new RouteMapper(idFactory, this.agencyMapper, issueStore, this.translationHelper);
        this.directionMapper = new DirectionMapper(issueStore);
        this.tripMapper = new TripMapper(idFactory, this.routeMapper, this.directionMapper, this.translationHelper);
        this.bookingRuleMapper = new BookingRuleMapper();
        this.stopTimeMapper = new StopTimeMapper(this.stopMapper, this.locationMapper, this.locationGroupMapper, this.tripMapper, this.bookingRuleMapper, this.translationHelper);
        this.frequencyMapper = new FrequencyMapper(this.tripMapper);
        this.fareAttributeMapper = new FareAttributeMapper(idFactory);
        this.fareRuleMapper = new FareRuleMapper(this.routeMapper, this.fareAttributeMapper);
        this.fareProductMapper = new FareProductMapper(idFactory);
        this.fareLegRuleMapper = new FareLegRuleMapper(idFactory, this.fareProductMapper, issueStore);
        this.fareTransferRuleMapper = new FareTransferRuleMapper(idFactory, this.fareProductMapper);
        this.stopAreaMapper = new StopAreaMapper(idFactory);
    }

    public OtpTransitServiceBuilder getBuilder() {
        return this.builder;
    }

    public FareRulesData fareRulesData() {
        return this.fareRulesBuilder;
    }

    public void mapStopTripAndRouteDataIntoBuilder(GtfsRelationalDao data) {
        this.translationHelper.importTranslations(data.getAllTranslations(), data.getAllFeedInfos());
        this.builder.getAgenciesById().addAll(this.agencyMapper.map(data.getAllAgencies()));
        this.builder.getCalendarDates().addAll(this.serviceCalendarDateMapper.map(data.getAllCalendarDates()));
        this.builder.getCalendars().addAll(this.serviceCalendarMapper.map(data.getAllCalendars()));
        this.builder.getFeedInfos().addAll(this.feedInfoMapper.map(data.getAllFeedInfos()));
        this.builder.getFrequencies().addAll(this.frequencyMapper.map(data.getAllFrequencies()));
        this.builder.getRoutes().addAll(this.routeMapper.map(data.getAllRoutes()));
        Map<FeedScopedId, CompactShape> shapes = this.shapePointMapper.map(data.getAllShapePoints());
        this.builder.getShapePoints().putAll(shapes);
        data.getAllShapePoints().clear();
        this.mapGtfsStopsToOtpTypes(data.getAllStops());
        if (OTPFeature.FlexRouting.isOn()) {
            this.builder.siteRepository().withAreaStops(this.locationMapper.map(data.getAllLocations()));
            this.builder.siteRepository().withGroupStops(this.locationGroupMapper.map(data.getAllLocationGroups()));
        }
        this.builder.getPathways().addAll(this.pathwayMapper.map(data.getAllPathways()));
        this.builder.getStopTimesSortedByTrip().addAll(this.stopTimeMapper.map(data.getAllStopTimes()));
        this.builder.getFlexTimePenalty().putAll(this.tripMapper.flexSafeTimePenalties());
        this.builder.getTripsById().addAll(this.tripMapper.map(data.getAllTrips()));
        this.fareRulesBuilder.fareAttributes().addAll(this.fareAttributeMapper.map(data.getAllFareAttributes()));
        this.fareRulesBuilder.fareRules().addAll(this.fareRuleMapper.map(data.getAllFareRules()));
        this.fareProductMapper.map(data.getAllFareProducts());
        this.fareRulesBuilder.fareLegRules().addAll(this.fareLegRuleMapper.map(data.getAllFareLegRules()));
        this.fareRulesBuilder.fareTransferRules().addAll(this.fareTransferRuleMapper.map(data.getAllFareTransferRules()));
        this.fareRulesBuilder.stopAreas().putAll(this.stopAreaMapper.map(data.getAllStopAreaElements()));
    }

    private void mapGtfsStopsToOtpTypes(Collection<Stop> stops) {
        for (Stop it : stops) {
            if (it.getLocationType() != 1) continue;
            this.builder.siteRepository().withStation(this.stationMapper.map(it));
        }
        for (Stop it : stops) {
            if (it.getLocationType() == 0) {
                this.builder.siteRepository().withRegularStop(this.stopMapper.map(it));
                continue;
            }
            if (it.getLocationType() == 2) {
                this.builder.getEntrances().add(this.entranceMapper.map(it));
                continue;
            }
            if (it.getLocationType() != 3) continue;
            this.builder.getPathwayNodes().add(this.pathwayNodeMapper.map(it));
        }
        for (Stop it : stops) {
            if (it.getLocationType() != 4) continue;
            this.builder.getBoardingAreas().add(this.boardingAreaMapper.map(it));
        }
    }

    public void mapAndAddTransfersToBuilder(GtfsDao data) {
        TransferMapper transferMapper = new TransferMapper(this.routeMapper, this.stationMapper, this.stopMapper, this.tripMapper, this.builder.getStopTimesSortedByTrip(), this.discardMinTransferTimes, this.issueStore);
        TransferMappingResult result = transferMapper.map(data.getAllTransfers());
        this.builder.getTransfers().addAll(result.constrainedTransfers());
        this.builder.getStaySeatedNotAllowed().addAll(result.staySeatedNotAllowed());
    }
}

