/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.gtfs.mapping;

import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.onebusaway.gtfs.model.FareTransferRule;
import org.opentripplanner.gtfs.mapping.FareProductMapper;
import org.opentripplanner.gtfs.mapping.IdFactory;
import org.opentripplanner.model.fare.FareProduct;
import org.opentripplanner.transit.model.framework.FeedScopedId;

class FareTransferRuleMapper {
    public final int MISSING_VALUE = -999;
    private final IdFactory idFactory;
    private final FareProductMapper fareProductMapper;

    FareTransferRuleMapper(IdFactory idFactory, FareProductMapper fareProductMapper) {
        this.idFactory = idFactory;
        this.fareProductMapper = fareProductMapper;
    }

    public Collection<org.opentripplanner.ext.fares.model.FareTransferRule> map(Collection<FareTransferRule> allRules) {
        return allRules.stream().map(this::doMap).filter(Objects::nonNull).toList();
    }

    private org.opentripplanner.ext.fares.model.FareTransferRule doMap(FareTransferRule rhs) {
        FeedScopedId fareProductId = this.idFactory.createNullableId(rhs.getFareProductId());
        Collection<FareProduct> products = this.findFareProducts(fareProductId, rhs.getId());
        Duration duration = null;
        if (rhs.getDurationLimit() != -999) {
            duration = Duration.ofSeconds(rhs.getDurationLimit());
        }
        return org.opentripplanner.ext.fares.model.FareTransferRule.of().withId(this.idFactory.createId(rhs.getId(), "fare transfer rule")).withFromLegGroup(this.idFactory.createNullableId(rhs.getFromLegGroupId())).withToLegGroup(this.idFactory.createNullableId(rhs.getToLegGroupId())).withTransferCount(rhs.getTransferCount()).withTimeLimit(duration).withFareProducts(products).build();
    }

    private Collection<FareProduct> findFareProducts(@Nullable FeedScopedId fareProductId, String ruleId) {
        if (fareProductId == null) {
            return List.of();
        }
        Collection<FareProduct> products = this.fareProductMapper.findFareProducts(fareProductId);
        if (products.isEmpty()) {
            throw new IllegalArgumentException("Cannot find fare product '%s' for transfer rule '%s'".formatted(fareProductId, ruleId));
        }
        return products;
    }
}

