/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.gtfs.mapping;

import java.time.Duration;
import java.util.Collection;
import java.util.Currency;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import org.onebusaway.gtfs.model.FareProduct;
import org.onebusaway.gtfs.model.RiderCategory;
import org.opentripplanner.gtfs.mapping.IdFactory;
import org.opentripplanner.model.fare.FareMedium;
import org.opentripplanner.transit.model.basic.Money;
import org.opentripplanner.transit.model.framework.FeedScopedId;

class FareProductMapper {
    public static int NOT_SET = -999;
    private final IdFactory idFactory;
    private final Set<org.opentripplanner.model.fare.FareProduct> mappedFareProducts = new HashSet<org.opentripplanner.model.fare.FareProduct>();

    public FareProductMapper(IdFactory idFactory) {
        this.idFactory = idFactory;
    }

    public org.opentripplanner.model.fare.FareProduct map(FareProduct rhs) {
        Currency currency = Currency.getInstance(rhs.getCurrency());
        Money price = Money.ofFractionalAmount(currency, rhs.getAmount());
        Duration duration = null;
        if (rhs.getDurationUnit() != NOT_SET) {
            duration = FareProductMapper.toDuration(rhs.getDurationUnit(), rhs.getDurationAmount());
        }
        org.opentripplanner.model.fare.FareProduct fp = org.opentripplanner.model.fare.FareProduct.of(this.idFactory.createId(rhs.getFareProductId(), "fare product"), rhs.getName(), price).withValidity(duration).withCategory(this.toInternalModel(rhs.getRiderCategory())).withMedium(this.toInternalModel(rhs.getFareMedium())).build();
        this.mappedFareProducts.add(fp);
        return fp;
    }

    public Collection<org.opentripplanner.model.fare.FareProduct> map(Collection<FareProduct> allFareProducts) {
        return allFareProducts.stream().map(this::map).toList();
    }

    public Collection<org.opentripplanner.model.fare.FareProduct> findFareProducts(FeedScopedId fareProductId) {
        return this.mappedFareProducts.stream().filter(p -> p.id().equals(fareProductId)).toList();
    }

    @Nullable
    private org.opentripplanner.model.fare.RiderCategory toInternalModel(@Nullable RiderCategory riderCategory) {
        if (riderCategory == null) {
            return null;
        }
        return new org.opentripplanner.model.fare.RiderCategory(this.idFactory.createId(riderCategory.getId(), "rider category"), riderCategory.getName(), riderCategory.getEligibilityUrl());
    }

    private static Duration toDuration(int unit, int amount) {
        return switch (unit) {
            case 0 -> Duration.ofSeconds(amount);
            case 1 -> Duration.ofMinutes(amount);
            case 2 -> Duration.ofHours(amount);
            case 3 -> Duration.ofDays(amount);
            case 4 -> Duration.ofDays((long)amount * 7L);
            case 5 -> Duration.ofDays((long)amount * 31L);
            case 6 -> Duration.ofDays((long)amount * 365L);
            default -> throw new IllegalStateException("Unexpected value: " + unit);
        };
    }

    @Nullable
    private FareMedium toInternalModel(@Nullable org.onebusaway.gtfs.model.FareMedium c) {
        if (c == null) {
            return null;
        }
        return new FareMedium(this.idFactory.createId(c.getId(), "fare medium"), c.getName());
    }
}

