/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.gtfs.mapping;

import java.util.Collection;
import java.util.Objects;
import javax.annotation.Nullable;
import org.onebusaway.gtfs.model.Area;
import org.onebusaway.gtfs.model.FareLegRule;
import org.opentripplanner.ext.fares.model.FareDistance;
import org.opentripplanner.graph_builder.issue.api.DataImportIssueStore;
import org.opentripplanner.gtfs.mapping.FareProductMapper;
import org.opentripplanner.gtfs.mapping.IdFactory;
import org.opentripplanner.model.fare.FareProduct;
import org.opentripplanner.transit.model.basic.Distance;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class FareLegRuleMapper {
    private static final Logger LOG = LoggerFactory.getLogger(FareLegRuleMapper.class);
    private final IdFactory idFactory;
    private final FareProductMapper fareProductMapper;
    private final DataImportIssueStore issueStore;

    public FareLegRuleMapper(IdFactory idFactory, FareProductMapper fareProductMapper, DataImportIssueStore issueStore) {
        this.idFactory = idFactory;
        this.fareProductMapper = fareProductMapper;
        this.issueStore = issueStore;
    }

    public Collection<org.opentripplanner.ext.fares.model.FareLegRule> map(Collection<FareLegRule> allFareLegRules) {
        return allFareLegRules.stream().map((? super T r) -> {
            FeedScopedId fareProductId = this.idFactory.createId(r.getFareProductId(), "fare leg rule's fare product id");
            Collection<FareProduct> productsForRule = this.fareProductMapper.findFareProducts(fareProductId);
            if (!productsForRule.isEmpty()) {
                FareDistance fareDistance = FareLegRuleMapper.createFareDistance(r);
                FeedScopedId ruleId = new FeedScopedId(fareProductId.getFeedId(), r.getId());
                return org.opentripplanner.ext.fares.model.FareLegRule.of(ruleId, productsForRule).withLegGroupId(this.idFactory.createNullableId(r.getLegGroupId())).withNetworkId(this.idFactory.createNullableId(r.getNetworkId())).withFromAreaId(this.areaId(r.getFromArea())).withToAreaId(this.areaId(r.getToArea())).withFareDistance(fareDistance).build();
            }
            this.issueStore.add("UnknownFareProductId", "Fare leg rule %s refers to unknown fare product %s", r.getId(), fareProductId);
            return null;
        }).filter(Objects::nonNull).toList();
    }

    private FeedScopedId areaId(@Nullable Area area) {
        if (area == null) {
            return null;
        }
        return this.idFactory.createId(area.getAreaId(), "area");
    }

    private static FareDistance createFareDistance(FareLegRule fareLegRule) {
        Integer distanceType = fareLegRule.getDistanceType();
        if (distanceType == null) {
            return null;
        }
        return switch (distanceType) {
            case 0 -> new FareDistance.Stops(fareLegRule.getMinDistance().intValue(), fareLegRule.getMaxDistance().intValue());
            case 1 -> new FareDistance.LinearDistance(Distance.ofMetersBoxed(fareLegRule.getMinDistance(), error -> LOG.warn("Fare leg rule min distance not valid: {} - {}", (Object)fareLegRule.getMinDistance(), error)).orElse(null), Distance.ofMetersBoxed(fareLegRule.getMaxDistance(), error -> LOG.warn("Fare leg rule max distance not valid: {} - {}", (Object)fareLegRule.getMaxDistance(), error)).orElse(null));
            default -> null;
        };
    }
}

