/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.gtfs.mapping;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.onebusaway.gtfs.model.Stop;
import org.opentripplanner.gtfs.mapping.IdFactory;
import org.opentripplanner.gtfs.mapping.StopMappingWrapper;
import org.opentripplanner.gtfs.mapping.TranslationHelper;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.site.Entrance;
import org.opentripplanner.transit.model.site.EntranceBuilder;
import org.opentripplanner.transit.model.site.Station;
import org.opentripplanner.utils.collection.MapUtils;

class EntranceMapper {
    private final IdFactory idFactory;
    private final Map<Stop, Entrance> mappedEntrances = new HashMap<Stop, Entrance>();
    private final TranslationHelper translationHelper;
    private final Function<FeedScopedId, Station> stationLookUp;

    EntranceMapper(IdFactory idFactory, TranslationHelper translationHelper, Function<FeedScopedId, Station> stationLookUp) {
        this.idFactory = idFactory;
        this.translationHelper = translationHelper;
        this.stationLookUp = stationLookUp;
    }

    Collection<Entrance> map(Collection<Stop> allEntrances) {
        return MapUtils.mapToList(allEntrances, this::map);
    }

    Entrance map(Stop orginal) {
        return orginal == null ? null : this.mappedEntrances.computeIfAbsent(orginal, this::doMap);
    }

    private Entrance doMap(Stop gtfsStop) {
        if (gtfsStop.getLocationType() != 2) {
            throw new IllegalArgumentException("Expected type 2, but got " + gtfsStop.getLocationType());
        }
        StopMappingWrapper base = new StopMappingWrapper(this.idFactory, gtfsStop);
        EntranceBuilder builder = (EntranceBuilder)((EntranceBuilder)((EntranceBuilder)((EntranceBuilder)Entrance.of(base.getId()).withCode(base.getCode())).withCoordinate(base.getCoordinate())).withWheelchairAccessibility(base.getWheelchairAccessibility())).withLevel(base.getLevel());
        builder.withName(this.translationHelper.getTranslation(Stop.class, "name", base.getId().getId(), base.getName()));
        builder = (EntranceBuilder)builder.withDescription(this.translationHelper.getTranslation(Stop.class, "desc", base.getId().getId(), base.getDescription()));
        if (gtfsStop.getParentStation() != null) {
            builder.withParentStation(this.stationLookUp.apply(base.getParentStationId()));
        }
        return (Entrance)builder.build();
    }
}

