/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.gtfs.mapping;

import gnu.trove.list.TDoubleList;
import gnu.trove.list.TIntList;
import gnu.trove.list.array.TDoubleArrayList;
import gnu.trove.list.array.TIntArrayList;
import java.util.Iterator;
import java.util.stream.IntStream;
import org.opentripplanner.model.ShapePoint;

class CompactShape
implements Iterable<ShapePoint> {
    private static final int INITIAL_CAPACITY = 50;
    private static final double NO_DISTANCE = -9999.0;
    private final TIntList seqs = new TIntArrayList(50);
    private final TDoubleList lats = new TDoubleArrayList(50);
    private final TDoubleList lons = new TDoubleArrayList(50);
    private final TDoubleList dists = new TDoubleArrayList(50);

    CompactShape() {
    }

    public void addPoint(org.onebusaway.gtfs.model.ShapePoint shapePoint) {
        this.seqs.add(shapePoint.getSequence());
        this.lats.add(shapePoint.getLat());
        this.lons.add(shapePoint.getLon());
        this.dists.add(shapePoint.isDistTraveledSet() ? shapePoint.getDistTraveled() : -9999.0);
    }

    @Override
    public Iterator<ShapePoint> iterator() {
        return IntStream.range(0, this.lats.size()).mapToObj(i -> {
            double dist = this.dists.get(i);
            return new ShapePoint(this.seqs.get(i), this.lats.get(i), this.lons.get(i), dist < 0.0 ? null : Double.valueOf(dist));
        }).sorted().iterator();
    }
}

