/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.gtfs.mapping;

import java.time.Duration;
import java.time.LocalTime;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.onebusaway.gtfs.model.AgencyAndId;
import org.onebusaway.gtfs.model.BookingRule;
import org.opentripplanner.transit.model.organization.ContactInfo;
import org.opentripplanner.transit.model.timetable.booking.BookingInfo;
import org.opentripplanner.transit.model.timetable.booking.BookingMethod;
import org.opentripplanner.transit.model.timetable.booking.BookingTime;

class BookingRuleMapper {
    private final Map<AgencyAndId, BookingInfo> cachedBookingInfos = new HashMap<AgencyAndId, BookingInfo>();

    BookingRuleMapper() {
    }

    BookingInfo map(BookingRule rule) {
        if (rule == null) {
            return null;
        }
        return this.cachedBookingInfos.computeIfAbsent(rule.getId(), k -> BookingInfo.of().withContactInfo(this.contactInfo(rule)).withBookingMethods(this.bookingMethods()).withEarliestBookingTime(this.earliestBookingTime(rule)).withLatestBookingTime(this.latestBookingTime(rule)).withMinimumBookingNotice(this.minimumBookingNotice(rule)).withMaximumBookingNotice(this.maximumBookingNotice(rule)).withMessage(this.message(rule)).withPickupMessage(this.pickupMessage(rule)).withDropOffMessage(this.dropOffMessage(rule)).build());
    }

    private ContactInfo contactInfo(BookingRule rule) {
        return (ContactInfo)ContactInfo.of().withPhoneNumber(rule.getPhoneNumber()).withInfoUrl(rule.getInfoUrl()).withBookingUrl(rule.getUrl()).build();
    }

    private EnumSet<BookingMethod> bookingMethods() {
        return null;
    }

    private BookingTime earliestBookingTime(BookingRule rule) {
        return new BookingTime(LocalTime.ofSecondOfDay(rule.getPriorNoticeStartTime()), rule.getPriorNoticeStartDay());
    }

    private BookingTime latestBookingTime(BookingRule rule) {
        return new BookingTime(LocalTime.ofSecondOfDay(rule.getPriorNoticeLastTime()), rule.getPriorNoticeLastDay());
    }

    private Duration minimumBookingNotice(BookingRule rule) {
        return Duration.ofSeconds(rule.getPriorNoticeDurationMin());
    }

    private Duration maximumBookingNotice(BookingRule rule) {
        return Duration.ofSeconds(rule.getPriorNoticeDurationMax());
    }

    private String message(BookingRule rule) {
        return rule.getMessage();
    }

    private String pickupMessage(BookingRule rule) {
        return rule.getPickupMessage();
    }

    private String dropOffMessage(BookingRule rule) {
        return rule.getDropOffMessage();
    }
}

