/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.gtfs.interlining;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opentripplanner.framework.geometry.SphericalDistanceLibrary;
import org.opentripplanner.graph_builder.issue.api.DataImportIssueStore;
import org.opentripplanner.graph_builder.issues.InterliningTeleport;
import org.opentripplanner.gtfs.mapping.StaySeatedNotAllowed;
import org.opentripplanner.model.Timetable;
import org.opentripplanner.model.calendar.CalendarServiceData;
import org.opentripplanner.model.transfer.ConstrainedTransfer;
import org.opentripplanner.model.transfer.DefaultTransferService;
import org.opentripplanner.model.transfer.TransferConstraint;
import org.opentripplanner.model.transfer.TransferPriority;
import org.opentripplanner.model.transfer.TripTransferPoint;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.network.TripPattern;
import org.opentripplanner.transit.model.site.StopLocation;
import org.opentripplanner.transit.model.timetable.Trip;
import org.opentripplanner.transit.model.timetable.TripTimes;
import org.opentripplanner.utils.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InterlineProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(InterlineProcessor.class);
    private final DefaultTransferService transferService;
    private final int maxInterlineDistance;
    private final DataImportIssueStore issueStore;
    private final List<StaySeatedNotAllowed> staySeatedNotAllowed;
    private final LocalDate transitServiceStart;
    private final int daysInTransitService;
    private final CalendarServiceData calendarServiceData;
    private final Map<FeedScopedId, BitSet> daysOfServices = new HashMap<FeedScopedId, BitSet>();

    public InterlineProcessor(DefaultTransferService transferService, List<StaySeatedNotAllowed> staySeatedNotAllowed, int maxInterlineDistance, DataImportIssueStore issueStore, CalendarServiceData calendarServiceData) {
        this.transferService = transferService;
        this.staySeatedNotAllowed = staySeatedNotAllowed;
        this.maxInterlineDistance = maxInterlineDistance > 0 ? maxInterlineDistance : 200;
        this.issueStore = issueStore;
        this.transitServiceStart = calendarServiceData.getFirstDate().orElse(null);
        this.daysInTransitService = calendarServiceData.getLastDate().map(lastDate -> (int)ChronoUnit.DAYS.between(this.transitServiceStart, (Temporal)lastDate) + 1).orElse(0);
        this.calendarServiceData = calendarServiceData;
    }

    public List<ConstrainedTransfer> run(Collection<TripPattern> tripPatterns) {
        if (this.daysInTransitService == 0) {
            return List.of();
        }
        Multimap<TripPatternPair, TripPair> interlinedTrips = this.getInterlinedTrips(tripPatterns);
        List<ConstrainedTransfer> transfers = interlinedTrips.entries().stream().filter(this::staySeatedAllowed).map(p -> {
            TransferConstraint.Builder constraint = TransferConstraint.of();
            constraint.staySeated();
            constraint.priority(TransferPriority.ALLOWED);
            Trip fromTrip = ((TripPair)p.getValue()).from();
            Trip toTrip = ((TripPair)p.getValue()).to();
            TripTransferPoint from = new TripTransferPoint(fromTrip, ((TripPatternPair)p.getKey()).from().numberOfStops() - 1);
            TripTransferPoint to = new TripTransferPoint(toTrip, 0);
            LOG.debug("Creating stay-seated transfer from trip {} (route {}) to trip {} (route {})", new Object[]{fromTrip.getId(), fromTrip.getRoute().getId(), toTrip.getId(), toTrip.getRoute().getId()});
            return new ConstrainedTransfer(null, from, to, constraint.build());
        }).toList();
        if (!transfers.isEmpty()) {
            LOG.info("Found {} pairs of trips for which stay-seated (interlined) transfers were created", (Object)transfers.size());
            this.transferService.addAll(transfers);
        }
        return transfers;
    }

    private boolean staySeatedAllowed(Map.Entry<TripPatternPair, TripPair> p) {
        Trip fromTrip = p.getValue().from();
        Trip toTrip = p.getValue().to();
        return this.staySeatedNotAllowed.stream().noneMatch(t -> t.fromTrip().getId().equals(fromTrip.getId()) && t.toTrip().getId().equals(toTrip.getId()));
    }

    private Multimap<TripPatternPair, TripPair> getInterlinedTrips(Collection<TripPattern> tripPatterns) {
        HashMap<TripTimes, TripPattern> patternForTripTimes = new HashMap<TripTimes, TripPattern>();
        ArrayListMultimap tripTimesForBlockId = ArrayListMultimap.create();
        LOG.info("Finding interlining trips based on block IDs.");
        for (TripPattern pattern : tripPatterns) {
            Timetable timetable = pattern.getScheduledTimetable();
            for (TripTimes tripTimes : timetable.getTripTimes()) {
                Trip trip = tripTimes.getTrip();
                if (!StringUtils.hasValue((String)trip.getGtfsBlockId())) continue;
                tripTimesForBlockId.put((Object)trip.getGtfsBlockId(), (Object)tripTimes);
                patternForTripTimes.put(tripTimes, pattern);
            }
        }
        ArrayListMultimap interlines = ArrayListMultimap.create();
        for (String blockId : tripTimesForBlockId.keySet()) {
            List blockTripTimes = tripTimesForBlockId.get((Object)blockId);
            Collections.sort(blockTripTimes);
            block3: for (int i = 0; i < blockTripTimes.size(); ++i) {
                TripTimes toTripTimes;
                FeedScopedId toServiceId;
                TripTimes fromTripTimes = (TripTimes)blockTripTimes.get(i);
                FeedScopedId fromServiceId = fromTripTimes.getTrip().getServiceId();
                BitSet uncoveredDays = this.getAndCopyDaysForService(fromServiceId);
                for (int j = i + 1; !(j >= blockTripTimes.size() || (toServiceId = (toTripTimes = (TripTimes)blockTripTimes.get(j)).getTrip().getServiceId()).equals(fromServiceId) && this.createInterline(fromTripTimes, toTripTimes, blockId, patternForTripTimes, (Multimap<TripPatternPair, TripPair>)interlines)); ++j) {
                    BitSet daysForToTripTimes = this.getDaysForService(toTripTimes.getTrip().getServiceId());
                    if (!uncoveredDays.intersects(daysForToTripTimes) || !this.createInterline(fromTripTimes, toTripTimes, blockId, patternForTripTimes, (Multimap<TripPatternPair, TripPair>)interlines)) continue;
                    uncoveredDays.andNot(daysForToTripTimes);
                    if (uncoveredDays.isEmpty()) continue block3;
                }
            }
        }
        return interlines;
    }

    private boolean createInterline(TripTimes fromTripTimes, TripTimes toTripTimes, String blockId, Map<TripTimes, TripPattern> patternForTripTimes, Multimap<TripPatternPair, TripPair> interlines) {
        if (fromTripTimes.getDepartureTime(fromTripTimes.getNumStops() - 1) > toTripTimes.getArrivalTime(0)) {
            LOG.error("Trip times within block {} are not increasing on after trip {}.", (Object)blockId, (Object)fromTripTimes.getTrip().getId());
            return true;
        }
        TripPattern fromPattern = patternForTripTimes.get(fromTripTimes);
        TripPattern toPattern = patternForTripTimes.get(toTripTimes);
        StopLocation fromStop = fromPattern.lastStop();
        StopLocation toStop = toPattern.firstStop();
        double teleportationDistance = SphericalDistanceLibrary.fastDistance(fromStop.getLat(), fromStop.getLon(), toStop.getLat(), toStop.getLon());
        if (teleportationDistance > (double)this.maxInterlineDistance) {
            this.issueStore.add(new InterliningTeleport(fromTripTimes.getTrip(), blockId, (int)teleportationDistance, fromStop, toStop));
            return false;
        }
        interlines.put((Object)new TripPatternPair(fromPattern, toPattern), (Object)new TripPair(fromTripTimes.getTrip(), toTripTimes.getTrip()));
        return true;
    }

    private BitSet getDaysForService(FeedScopedId serviceId) {
        BitSet daysForService = this.daysOfServices.get(serviceId);
        if (daysForService == null) {
            daysForService = new BitSet(this.daysInTransitService);
            List<LocalDate> serviceDates = this.calendarServiceData.getServiceDatesForServiceId(serviceId);
            if (serviceDates != null) {
                for (LocalDate serviceDate : serviceDates) {
                    int daysBetween = (int)ChronoUnit.DAYS.between(this.transitServiceStart, serviceDate);
                    daysForService.set(daysBetween);
                }
            }
            this.daysOfServices.put(serviceId, daysForService);
        }
        return daysForService;
    }

    private BitSet getAndCopyDaysForService(FeedScopedId serviceId) {
        return (BitSet)this.getDaysForService(serviceId).clone();
    }

    private record TripPair(Trip from, Trip to) {
    }

    private record TripPatternPair(TripPattern from, TripPattern to) {
    }
}

