/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.gtfs.graphbuilder;

import java.awt.Color;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.onebusaway.csv_entities.EntityHandler;
import org.onebusaway.gtfs.impl.GtfsRelationalDaoImpl;
import org.onebusaway.gtfs.model.Agency;
import org.onebusaway.gtfs.model.Area;
import org.onebusaway.gtfs.model.FareLegRule;
import org.onebusaway.gtfs.model.FareMedium;
import org.onebusaway.gtfs.model.FareProduct;
import org.onebusaway.gtfs.model.FareTransferRule;
import org.onebusaway.gtfs.model.IdentityBean;
import org.onebusaway.gtfs.model.RiderCategory;
import org.onebusaway.gtfs.model.Route;
import org.onebusaway.gtfs.model.StopAreaElement;
import org.onebusaway.gtfs.serialization.GtfsReader;
import org.onebusaway.gtfs.services.GenericMutableDao;
import org.onebusaway.gtfs.services.GtfsDao;
import org.onebusaway.gtfs.services.GtfsMutableRelationalDao;
import org.onebusaway.gtfs.services.GtfsRelationalDao;
import org.opentripplanner.ext.fares.impl.gtfs.DefaultFareServiceFactory;
import org.opentripplanner.ext.fares.model.FareRulesData;
import org.opentripplanner.ext.flex.FlexTripsMapper;
import org.opentripplanner.framework.application.OTPFeature;
import org.opentripplanner.graph_builder.issue.api.DataImportIssueStore;
import org.opentripplanner.graph_builder.model.GraphBuilderModule;
import org.opentripplanner.graph_builder.module.AddTransitEntitiesToGraph;
import org.opentripplanner.graph_builder.module.ValidateAndInterpolateStopTimesForEachTrip;
import org.opentripplanner.graph_builder.module.geometry.GeometryProcessor;
import org.opentripplanner.gtfs.GenerateTripPatternsOperation;
import org.opentripplanner.gtfs.graphbuilder.GtfsBundle;
import org.opentripplanner.gtfs.interlining.InterlineProcessor;
import org.opentripplanner.gtfs.mapping.GTFSToOtpTransitServiceMapper;
import org.opentripplanner.model.OtpTransitService;
import org.opentripplanner.model.TripStopTimes;
import org.opentripplanner.model.calendar.CalendarServiceData;
import org.opentripplanner.model.calendar.ServiceDateInterval;
import org.opentripplanner.model.impl.OtpTransitServiceBuilder;
import org.opentripplanner.routing.fares.FareServiceFactory;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.service.TimetableRepository;
import org.opentripplanner.utils.color.Brightness;
import org.opentripplanner.utils.color.ColorUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GtfsModule
implements GraphBuilderModule {
    public static final Set<Class<?>> FARES_V2_CLASSES = Set.of(FareProduct.class, FareLegRule.class, FareTransferRule.class, RiderCategory.class, FareMedium.class, StopAreaElement.class, Area.class);
    private static final Logger LOG = LoggerFactory.getLogger(GtfsModule.class);
    private final EntityHandler counter = new EntityCounter();
    private final Set<String> agencyIdsSeen = new HashSet<String>();
    private final ServiceDateInterval transitPeriodLimit;
    private final List<GtfsBundle> gtfsBundles;
    private final FareServiceFactory fareServiceFactory;
    private final TimetableRepository timetableRepository;
    private final Graph graph;
    private final DataImportIssueStore issueStore;
    private int nextAgencyId = 1;
    private final double maxStopToShapeSnapDistance;
    private final int subwayAccessTime_s;

    public GtfsModule(List<GtfsBundle> bundles, TimetableRepository timetableRepository, Graph graph, DataImportIssueStore issueStore, ServiceDateInterval transitPeriodLimit, FareServiceFactory fareServiceFactory, double maxStopToShapeSnapDistance, int subwayAccessTime_s) {
        this.gtfsBundles = bundles;
        this.timetableRepository = timetableRepository;
        this.graph = graph;
        this.issueStore = issueStore;
        this.transitPeriodLimit = transitPeriodLimit;
        this.fareServiceFactory = fareServiceFactory;
        this.maxStopToShapeSnapDistance = maxStopToShapeSnapDistance;
        this.subwayAccessTime_s = subwayAccessTime_s;
    }

    public static GtfsModule forTest(List<GtfsBundle> bundles, TimetableRepository timetableRepository, Graph graph, ServiceDateInterval transitPeriodLimit) {
        return new GtfsModule(bundles, timetableRepository, graph, DataImportIssueStore.NOOP, transitPeriodLimit, new DefaultFareServiceFactory(), 150.0, 120);
    }

    @Override
    public void buildGraph() {
        CalendarServiceData calendarServiceData = new CalendarServiceData();
        boolean hasTransit = false;
        HashMap<String, GtfsBundle> feedIdsEncountered = new HashMap<String, GtfsBundle>();
        try {
            for (GtfsBundle gtfsBundle : this.gtfsBundles) {
                GtfsMutableRelationalDao gtfsDao = this.loadBundle(gtfsBundle);
                String feedId = gtfsBundle.getFeedId();
                GtfsModule.verifyUniqueFeedId(gtfsBundle, feedIdsEncountered, feedId);
                feedIdsEncountered.put(feedId, gtfsBundle);
                GTFSToOtpTransitServiceMapper mapper = new GTFSToOtpTransitServiceMapper(new OtpTransitServiceBuilder(this.timetableRepository.getSiteRepository(), this.issueStore), feedId, this.issueStore, gtfsBundle.parameters().discardMinTransferTimes(), gtfsBundle.parameters().stationTransferPreference());
                mapper.mapStopTripAndRouteDataIntoBuilder((GtfsRelationalDao)gtfsDao);
                OtpTransitServiceBuilder builder = mapper.getBuilder();
                FareRulesData fareRulesData = mapper.fareRulesData();
                builder.limitServiceDays(this.transitPeriodLimit);
                calendarServiceData.add(builder.buildCalendarServiceData());
                if (OTPFeature.FlexRouting.isOn()) {
                    builder.getFlexTripsById().addAll(FlexTripsMapper.createFlexTrips(builder, this.issueStore));
                }
                this.validateAndInterpolateStopTimesForEachTrip(builder.getStopTimesSortedByTrip(), this.issueStore);
                mapper.mapAndAddTransfersToBuilder((GtfsDao)gtfsDao);
                GeometryProcessor geometryProcessor = new GeometryProcessor(builder, this.maxStopToShapeSnapDistance, this.issueStore);
                this.createTripPatterns(this.graph, this.timetableRepository, builder, calendarServiceData.getServiceIds(), geometryProcessor, this.issueStore);
                OtpTransitService otpTransitService = builder.build();
                hasTransit = hasTransit || otpTransitService.hasActiveTransit();
                this.addTimetableRepositoryToGraph(this.graph, this.timetableRepository, otpTransitService);
                if (gtfsBundle.parameters().blockBasedInterlining()) {
                    new InterlineProcessor(this.timetableRepository.getTransferService(), builder.getStaySeatedNotAllowed(), gtfsBundle.parameters().maxInterlineDistance(), this.issueStore, calendarServiceData).run(otpTransitService.getTripPatterns());
                }
                this.fareServiceFactory.processGtfs(fareRulesData, otpTransitService);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.timetableRepository.validateTimeZones();
        this.timetableRepository.updateCalendarServiceData(hasTransit, calendarServiceData, this.issueStore);
    }

    private static void verifyUniqueFeedId(GtfsBundle gtfsBundle, Map<String, GtfsBundle> feedIdsEncountered, String feedId) {
        if (feedIdsEncountered.containsKey(feedId)) {
            LOG.error("Feed id '{}' has been used for {} but it was already assigned to {}.", new Object[]{feedId, gtfsBundle, feedIdsEncountered.get(feedId)});
            throw new IllegalArgumentException("Duplicate feed id: '%s'".formatted(feedId));
        }
    }

    @Override
    public void checkInputs() {
        for (GtfsBundle bundle : this.gtfsBundles) {
            bundle.checkInputs();
        }
    }

    private void validateAndInterpolateStopTimesForEachTrip(TripStopTimes stopTimesByTrip, DataImportIssueStore issueStore) {
        new ValidateAndInterpolateStopTimesForEachTrip(stopTimesByTrip, true, issueStore).run();
    }

    private void createTripPatterns(Graph graph, TimetableRepository timetableRepository, OtpTransitServiceBuilder builder, Set<FeedScopedId> calServiceIds, GeometryProcessor geometryProcessor, DataImportIssueStore issueStore) {
        GenerateTripPatternsOperation buildTPOp = new GenerateTripPatternsOperation(builder, issueStore, graph.deduplicator, calServiceIds, geometryProcessor);
        buildTPOp.run();
        timetableRepository.setHasFrequencyService(timetableRepository.hasFrequencyService() || buildTPOp.hasFrequencyBasedTrips());
        timetableRepository.setHasScheduledService(timetableRepository.hasScheduledService() || buildTPOp.hasScheduledTrips());
    }

    private void addTimetableRepositoryToGraph(Graph graph, TimetableRepository timetableRepository, OtpTransitService otpTransitService) {
        AddTransitEntitiesToGraph.addToGraph(otpTransitService, this.subwayAccessTime_s, graph, timetableRepository);
    }

    private GtfsMutableRelationalDao loadBundle(GtfsBundle gtfsBundle) throws IOException {
        GtfsRelationalDaoImpl dao = new GtfsRelationalDaoImpl();
        dao.setPackShapePoints(true);
        StoreImpl store = new StoreImpl((GtfsMutableRelationalDao)dao);
        store.open();
        LOG.info("reading {}", (Object)gtfsBundle.feedInfo());
        String gtfsFeedId = gtfsBundle.getFeedId();
        GtfsReader reader = new GtfsReader();
        reader.setInputSource(gtfsBundle.getCsvInputSource());
        reader.setEntityStore((GenericMutableDao)store);
        reader.setInternStrings(true);
        reader.setDefaultAgencyId(gtfsFeedId);
        if (LOG.isDebugEnabled()) {
            reader.addEntityHandler(this.counter);
        }
        for (Class entityClass : reader.getEntityClasses()) {
            if (this.skipEntityClass(entityClass)) {
                LOG.info("Skipping entity: {}", (Object)entityClass.getName());
                continue;
            }
            LOG.info("Reading entity: {}", (Object)entityClass.getName());
            reader.readEntities(entityClass);
            store.flush();
            if (entityClass != Agency.class) continue;
            for (Agency agency : reader.getAgencies()) {
                Object agencyId = agency.getId();
                if (agencyId == null || this.agencyIdsSeen.contains(gtfsFeedId + (String)agencyId)) {
                    String generatedAgencyId = null;
                    while (generatedAgencyId == null || this.agencyIdsSeen.contains(generatedAgencyId)) {
                        generatedAgencyId = "F" + this.nextAgencyId;
                        ++this.nextAgencyId;
                    }
                    LOG.warn("The agency ID '{}' was already seen, or I think it's bad. Replacing with '{}'.", agencyId, (Object)generatedAgencyId);
                    reader.addAgencyIdMapping((String)agencyId, generatedAgencyId);
                    agency.setId(generatedAgencyId);
                    agencyId = generatedAgencyId;
                }
                if (agencyId == null) continue;
                this.agencyIdsSeen.add(gtfsFeedId + (String)agencyId);
            }
        }
        store.close();
        return store.dao;
    }

    private boolean skipEntityClass(Class<?> entityClass) {
        return OTPFeature.FaresV2.isOff() && FARES_V2_CLASSES.contains(entityClass);
    }

    private void generateRouteColor(Route route) {
        String routeColor = route.getColor();
        if (routeColor == null) {
            return;
        }
        String textColor = route.getTextColor();
        if (textColor != null) {
            return;
        }
        Color routeColorColor = Color.decode("#" + routeColor);
        textColor = ColorUtils.computeBrightness((Color)routeColorColor) == Brightness.LIGHT ? "000000" : "FFFFFF";
        route.setTextColor(textColor);
    }

    private static class EntityCounter
    implements EntityHandler {
        private final Map<Class<?>, Integer> count = new HashMap();

        private EntityCounter() {
        }

        public void handleEntity(Object bean) {
            int count = this.incrementCount(bean.getClass());
            if (count % 1000000 == 0 && LOG.isDebugEnabled()) {
                String name = bean.getClass().getName();
                int index = name.lastIndexOf(46);
                if (index != -1) {
                    name = name.substring(index + 1);
                }
                LOG.debug("loading {}: {}", (Object)name, (Object)count);
            }
        }

        private int incrementCount(Class<?> entityType) {
            Integer value = this.count.get(entityType);
            if (value == null) {
                value = 0;
            }
            Integer n = value;
            value = value + 1;
            this.count.put(entityType, value);
            return value;
        }
    }

    private static class StoreImpl
    implements GenericMutableDao {
        private final GtfsMutableRelationalDao dao;

        StoreImpl(GtfsMutableRelationalDao dao) {
            this.dao = dao;
        }

        public void open() {
            this.dao.open();
        }

        public void saveEntity(Object entity) {
            this.dao.saveEntity(entity);
        }

        public void updateEntity(Object entity) {
            throw new UnsupportedOperationException();
        }

        public void saveOrUpdateEntity(Object entity) {
            throw new UnsupportedOperationException();
        }

        public <K extends Serializable, T extends IdentityBean<K>> void removeEntity(T entity) {
            throw new UnsupportedOperationException();
        }

        public <T> void clearAllEntitiesForType(Class<T> type) {
            throw new UnsupportedOperationException();
        }

        public void flush() {
            this.dao.flush();
        }

        public void close() {
            this.dao.close();
        }

        public <T> Collection<T> getAllEntitiesForType(Class<T> type) {
            return this.dao.getAllEntitiesForType(type);
        }

        public <T> T getEntityForId(Class<T> type, Serializable id) {
            return (T)this.dao.getEntityForId(type, id);
        }
    }
}

