/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.gtfs.graphbuilder;

import com.csvreader.CsvReader;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import org.onebusaway.csv_entities.CsvInputSource;
import org.opentripplanner.utils.lang.StringUtils;

public class GtfsFeedIdResolver {
    private static AtomicInteger FEED_ID_COUNTER = new AtomicInteger(0);
    private static Map<Object, String> FEED_ID_MAP = Collections.synchronizedMap(new HashMap());

    public static String fromGtfsFeed(CsvInputSource source, Object dataSourceId) {
        return FEED_ID_MAP.computeIfAbsent(dataSourceId, ignore -> GtfsFeedIdResolver.readFeedIdFromDataSource(source));
    }

    static String normalizeId(String id) {
        String cleanId = GtfsFeedIdResolver.cleanId(id);
        return cleanId == null ? GtfsFeedIdResolver.generateId() : cleanId;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String readFeedIdFromDataSource(CsvInputSource source) {
        String string;
        if (!source.hasResource("feed_info.txt")) return GtfsFeedIdResolver.generateId();
        InputStream feedInfoInputStream = source.getResource("feed_info.txt");
        try {
            CsvReader result = new CsvReader(feedInfoInputStream, StandardCharsets.UTF_8);
            result.readHeaders();
            result.readRecord();
            string = GtfsFeedIdResolver.normalizeId(result.get("feed_id"));
            if (feedInfoInputStream == null) return string;
        }
        catch (Throwable throwable) {
            try {
                if (feedInfoInputStream == null) throw throwable;
                try {
                    feedInfoInputStream.close();
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        feedInfoInputStream.close();
        return string;
    }

    private static String generateId() {
        return String.valueOf(FEED_ID_COUNTER.incrementAndGet());
    }

    @Nullable
    private static String cleanId(String id) {
        if (StringUtils.hasNoValue((String)id)) {
            return null;
        }
        return id.replace(":", "");
    }
}

