/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.gtfs.graphbuilder;

import java.io.File;
import java.io.InputStream;
import javax.annotation.Nullable;
import org.onebusaway.csv_entities.CsvInputSource;
import org.opentripplanner.datastore.api.CompositeDataSource;
import org.opentripplanner.datastore.api.FileType;
import org.opentripplanner.datastore.configure.DataStoreModule;
import org.opentripplanner.gtfs.config.GtfsDefaultParameters;
import org.opentripplanner.gtfs.config.GtfsFeedParameters;
import org.opentripplanner.gtfs.graphbuilder.GtfsFeedIdResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GtfsBundle {
    private static final Logger LOG = LoggerFactory.getLogger(GtfsBundle.class);
    private final CompositeDataSource dataSource;
    @Nullable
    private String feedId;
    private CsvInputSource csvInputSource;
    private final GtfsFeedParameters parameters;

    public GtfsBundle(CompositeDataSource dataSource, GtfsFeedParameters parameters) {
        this.dataSource = dataSource;
        this.parameters = parameters;
        this.feedId = parameters.feedId();
    }

    public static GtfsBundle forTest(File gtfsFile, @Nullable String feedId) {
        CompositeDataSource dataSource = DataStoreModule.compositeSource(gtfsFile, FileType.GTFS);
        GtfsFeedParameters parameters = GtfsDefaultParameters.DEFAULT.withFeedInfo().withSource(dataSource.uri()).withFeedId(feedId).build();
        return new GtfsBundle(dataSource, parameters);
    }

    public static GtfsBundle forTest(File gtfsFile) {
        return GtfsBundle.forTest(gtfsFile, null);
    }

    public String getFeedId() {
        if (this.feedId == null) {
            this.feedId = GtfsFeedIdResolver.fromGtfsFeed(this.getCsvInputSource(), this.dataSource.uri());
        }
        return this.feedId;
    }

    public GtfsFeedParameters parameters() {
        return this.parameters;
    }

    public void checkInputs() {
        if (this.csvInputSource != null) {
            LOG.warn("unknown CSV source type; cannot check inputs");
            return;
        }
        if (!this.dataSource.exists()) {
            throw new RuntimeException("GTFS Path " + this.dataSource.path() + " does not exist or cannot be read.");
        }
    }

    public CsvInputSource getCsvInputSource() {
        if (this.csvInputSource == null) {
            this.csvInputSource = new CsvInputSource(){

                public boolean hasResource(String s) {
                    return GtfsBundle.this.dataSource.content().stream().anyMatch(it -> it.name().equals(s));
                }

                public InputStream getResource(String s) {
                    return GtfsBundle.this.dataSource.entry(s).asInputStream();
                }

                public void close() {
                }
            };
        }
        return this.csvInputSource;
    }

    public String feedInfo() {
        return "GTFS bundle at " + this.dataSource.path() + " (" + this.getFeedId() + ")";
    }
}

