/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.gtfs.config;

import java.util.Objects;
import org.opentripplanner.gtfs.config.GtfsDefaultParametersBuilder;
import org.opentripplanner.gtfs.config.GtfsFeedParameters;
import org.opentripplanner.gtfs.config.GtfsFeedParametersBuilder;
import org.opentripplanner.transit.model.site.StopTransferPriority;
import org.opentripplanner.utils.tostring.ToStringBuilder;

public sealed class GtfsDefaultParameters
permits GtfsFeedParameters {
    private static final boolean DEFAULT_DISCARD_MIN_TRANSFER_TIMES = false;
    private static final boolean DEFAULT_BLOCK_BASED_INTERLINING = true;
    private static final int DEFAULT_MAX_INTERLINE_DISTANCE = 200;
    public static final GtfsDefaultParameters DEFAULT = new GtfsDefaultParameters(StopTransferPriority.defaultValue(), false, true, 200);
    private final StopTransferPriority stationTransferPreference;
    private final boolean discardMinTransferTimes;
    private final boolean blockBasedInterlining;
    private final int maxInterlineDistance;

    protected GtfsDefaultParameters(StopTransferPriority stationTransferPreference, boolean discardMinTransferTimes, boolean blockBasedInterlining, int maxInterlineDistance) {
        this.stationTransferPreference = Objects.requireNonNull(stationTransferPreference);
        this.discardMinTransferTimes = discardMinTransferTimes;
        this.blockBasedInterlining = blockBasedInterlining;
        this.maxInterlineDistance = maxInterlineDistance;
    }

    GtfsDefaultParameters(GtfsDefaultParametersBuilder builder) {
        this(builder.stationTransferPreference(), builder.discardMinTransferTimes(), builder.blockBasedInterlining(), builder.maxInterlineDistance());
    }

    public GtfsDefaultParametersBuilder copyOf() {
        return new GtfsDefaultParametersBuilder(this);
    }

    public GtfsFeedParametersBuilder withFeedInfo() {
        return new GtfsFeedParametersBuilder(this);
    }

    public StopTransferPriority stationTransferPreference() {
        return this.stationTransferPreference;
    }

    public boolean discardMinTransferTimes() {
        return this.discardMinTransferTimes;
    }

    public boolean blockBasedInterlining() {
        return this.blockBasedInterlining;
    }

    public int maxInterlineDistance() {
        return this.maxInterlineDistance;
    }

    public boolean equals(Object o) {
        throw new UnsupportedOperationException("Equals and hashCode is not implemented for this class.");
    }

    public int hashCode() {
        throw new UnsupportedOperationException("Equals and hashCode is not implemented for this class.");
    }

    public String toString() {
        return this.toStringAppend(ToStringBuilder.of(GtfsDefaultParameters.class)).toString();
    }

    protected ToStringBuilder toStringAppend(ToStringBuilder builder) {
        return builder.addEnum("stationTransferPreference", (Enum)this.stationTransferPreference, (Enum)StopTransferPriority.defaultValue()).addBool("discardMinTransferTimes", this.discardMinTransferTimes, false).addBool("blockBasedInterlining", this.blockBasedInterlining, true).addNum("maxInterlineDistance", (Number)this.maxInterlineDistance, (Number)200);
    }
}

