/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.gtfs;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opentripplanner.ext.flex.trip.FlexTrip;
import org.opentripplanner.graph_builder.issue.api.DataImportIssueStore;
import org.opentripplanner.graph_builder.issues.TripDegenerate;
import org.opentripplanner.graph_builder.issues.TripUndefinedService;
import org.opentripplanner.graph_builder.module.geometry.GeometryProcessor;
import org.opentripplanner.model.Frequency;
import org.opentripplanner.model.StopTime;
import org.opentripplanner.model.impl.OtpTransitServiceBuilder;
import org.opentripplanner.transit.model.framework.AbstractBuilder;
import org.opentripplanner.transit.model.framework.DataValidationException;
import org.opentripplanner.transit.model.framework.Deduplicator;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.network.Route;
import org.opentripplanner.transit.model.network.StopPattern;
import org.opentripplanner.transit.model.network.TripPattern;
import org.opentripplanner.transit.model.network.TripPatternBuilder;
import org.opentripplanner.transit.model.timetable.Direction;
import org.opentripplanner.transit.model.timetable.FrequencyEntry;
import org.opentripplanner.transit.model.timetable.ScheduledTripTimes;
import org.opentripplanner.transit.model.timetable.Trip;
import org.opentripplanner.transit.model.timetable.TripTimesFactory;
import org.opentripplanner.utils.logging.ProgressTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenerateTripPatternsOperation {
    private static final Logger LOG = LoggerFactory.getLogger(GenerateTripPatternsOperation.class);
    private final Map<String, Integer> tripPatternIdCounters = new HashMap<String, Integer>();
    private final OtpTransitServiceBuilder transitServiceBuilder;
    private final DataImportIssueStore issueStore;
    private final Deduplicator deduplicator;
    private final Set<FeedScopedId> calendarServiceIds;
    private final GeometryProcessor geometryProcessor;
    private final Multimap<StopPattern, TripPatternBuilder> tripPatternBuilders = MultimapBuilder.linkedHashKeys().linkedHashSetValues().build();
    private final ListMultimap<Trip, Frequency> frequenciesForTrip = ArrayListMultimap.create();
    private int freqCount = 0;
    private int scheduledCount = 0;

    public GenerateTripPatternsOperation(OtpTransitServiceBuilder builder, DataImportIssueStore issueStore, Deduplicator deduplicator, Set<FeedScopedId> calendarServiceIds, GeometryProcessor geometryProcessor) {
        this.transitServiceBuilder = builder;
        this.issueStore = issueStore;
        this.deduplicator = deduplicator;
        this.calendarServiceIds = calendarServiceIds;
        this.geometryProcessor = geometryProcessor;
    }

    public void run() {
        this.collectFrequencyByTrip();
        Collection trips = this.transitServiceBuilder.getTripsById().values();
        ProgressTracker progressLogger = ProgressTracker.track((String)"build trip patterns", (int)50000, (long)trips.size());
        LOG.info(progressLogger.startMessage());
        for (Trip trip : trips) {
            try {
                this.buildTripPatternForTrip(trip);
                progressLogger.step(m -> LOG.info(m));
            }
            catch (DataValidationException e) {
                this.issueStore.add(e.error());
            }
        }
        this.tripPatternBuilders.values().stream().map(AbstractBuilder::build).forEach(tripPattern -> this.transitServiceBuilder.getTripPatterns().put((Object)tripPattern.getStopPattern(), tripPattern));
        LOG.info(progressLogger.completeMessage());
        LOG.info("Added {} frequency-based and {} single-trip timetable entries.", (Object)this.freqCount, (Object)this.scheduledCount);
    }

    public boolean hasFrequencyBasedTrips() {
        return this.freqCount > 0;
    }

    public boolean hasScheduledTrips() {
        return this.scheduledCount > 0;
    }

    private void collectFrequencyByTrip() {
        for (Frequency freq : this.transitServiceBuilder.getFrequencies()) {
            this.frequenciesForTrip.put((Object)freq.getTrip(), (Object)freq);
        }
    }

    private void buildTripPatternForTrip(Trip trip) {
        boolean flexTripWithZeroStops;
        if (!this.calendarServiceIds.contains(trip.getServiceId())) {
            this.issueStore.add(new TripUndefinedService(trip));
            return;
        }
        List<StopTime> stopTimes = this.transitServiceBuilder.getStopTimesSortedByTrip().get(trip);
        boolean staticTripWithFewerThan2Stops = !FlexTrip.containsFlexStops(stopTimes) && stopTimes.size() < 2;
        boolean bl = flexTripWithZeroStops = FlexTrip.containsFlexStops(stopTimes) && stopTimes.size() < 1;
        if (staticTripWithFewerThan2Stops || flexTripWithZeroStops) {
            this.issueStore.add(new TripDegenerate(trip));
            return;
        }
        StopPattern stopPattern = new StopPattern(stopTimes);
        TripPatternBuilder tripPatternBuilder = this.findOrCreateTripPattern(stopPattern, trip);
        ScheduledTripTimes tripTimes = TripTimesFactory.tripTimes(trip, stopTimes, this.deduplicator);
        List frequencies = this.frequenciesForTrip.get((Object)trip);
        if (!frequencies.isEmpty()) {
            for (Frequency freq : frequencies) {
                tripPatternBuilder.withScheduledTimeTableBuilder(builder -> builder.addFrequencyEntry(new FrequencyEntry(freq, tripTimes)));
                ++this.freqCount;
            }
        } else {
            tripPatternBuilder.withScheduledTimeTableBuilder(builder -> builder.addTripTimes(tripTimes));
            ++this.scheduledCount;
        }
    }

    private TripPatternBuilder findOrCreateTripPattern(StopPattern stopPattern, Trip trip) {
        TripPatternBuilder tripPatternBuilder2;
        Route route = trip.getRoute();
        Direction direction = trip.getDirection();
        for (TripPatternBuilder tripPatternBuilder2 : this.tripPatternBuilders.get((Object)stopPattern)) {
            if (!tripPatternBuilder2.getRoute().equals(route) || !tripPatternBuilder2.getDirection().equals((Object)direction) || !tripPatternBuilder2.getMode().equals(trip.getMode()) || !tripPatternBuilder2.getNetexSubmode().equals(trip.getNetexSubMode())) continue;
            return tripPatternBuilder2;
        }
        FeedScopedId patternId = this.generateUniqueIdForTripPattern(route, direction);
        tripPatternBuilder2 = TripPattern.of(patternId).withRoute(route).withStopPattern(stopPattern).withMode(trip.getMode()).withNetexSubmode(trip.getNetexSubMode()).withHopGeometries(this.geometryProcessor.createHopGeometries(trip));
        this.tripPatternBuilders.put((Object)stopPattern, (Object)tripPatternBuilder2);
        return tripPatternBuilder2;
    }

    private FeedScopedId generateUniqueIdForTripPattern(Route route, Direction direction) {
        FeedScopedId routeId = route.getId();
        String directionId = direction == Direction.UNKNOWN ? "" : Integer.toString(direction.gtfsCode);
        String key = routeId.getId() + ":" + String.valueOf((Object)direction);
        int counter = this.tripPatternIdCounters.getOrDefault(key, 0) + 1;
        this.tripPatternIdCounters.put(key, counter);
        String id = String.format("%s:%s:%02d", routeId.getId(), directionId, counter);
        return new FeedScopedId(routeId.getFeedId(), id);
    }
}

