/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.graph_builder.services.osm;

import org.opentripplanner.framework.i18n.I18NString;
import org.opentripplanner.framework.i18n.NonLocalizedString;
import org.opentripplanner.graph_builder.module.osm.StreetEdgePair;
import org.opentripplanner.graph_builder.module.osm.naming.DefaultNamer;
import org.opentripplanner.graph_builder.module.osm.naming.PortlandCustomNamer;
import org.opentripplanner.graph_builder.module.osm.naming.SidewalkNamer;
import org.opentripplanner.osm.model.OsmEntity;
import org.opentripplanner.standalone.config.framework.json.NodeAdapter;
import org.opentripplanner.standalone.config.framework.json.OtpVersion;

public interface EdgeNamer {
    public I18NString name(OsmEntity var1);

    public void recordEdges(OsmEntity var1, StreetEdgePair var2);

    public void postprocess();

    default public I18NString getNameForWay(OsmEntity way, String id) {
        I18NString name = this.name(way);
        if (name == null) {
            name = new NonLocalizedString(id);
        }
        return name;
    }

    public static enum EdgeNamerType {
        DEFAULT,
        PORTLAND,
        SIDEWALKS;

    }

    public static class EdgeNamerFactory {
        public static EdgeNamer fromConfig(NodeAdapter root, String parameterName) {
            EdgeNamerType osmNaming = root.of(parameterName).summary("A custom OSM namer to use.").since(OtpVersion.V1_5).asEnum(EdgeNamerType.DEFAULT);
            return EdgeNamerFactory.fromConfig(osmNaming);
        }

        public static EdgeNamer fromConfig(EdgeNamerType type) {
            if (type == null) {
                return new DefaultNamer();
            }
            return switch (type.ordinal()) {
                default -> throw new MatchException(null, null);
                case 1 -> new PortlandCustomNamer();
                case 2 -> new SidewalkNamer();
                case 0 -> new DefaultNamer();
            };
        }
    }
}

