/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.graph_builder.module.osm.parameters;

import java.net.URI;
import java.time.ZoneId;
import org.opentripplanner.graph_builder.module.osm.parameters.OsmExtractParameters;
import org.opentripplanner.osm.tagmapping.OsmTagMapperSource;

public class OsmExtractParametersBuilder {
    private URI source;
    private OsmTagMapperSource osmTagMapper;
    private ZoneId timeZone;
    private boolean includeOsmSubwayEntrances;

    public OsmExtractParametersBuilder() {
        this.osmTagMapper = OsmExtractParameters.DEFAULT_OSM_TAG_MAPPER;
        this.timeZone = OsmExtractParameters.DEFAULT_TIME_ZONE;
        this.includeOsmSubwayEntrances = false;
    }

    public OsmExtractParametersBuilder(OsmExtractParameters original) {
        this.osmTagMapper = original.osmTagMapper();
        this.timeZone = original.timeZone();
        this.includeOsmSubwayEntrances = original.includeOsmSubwayEntrances();
    }

    public OsmExtractParametersBuilder withSource(URI source) {
        this.source = source;
        return this;
    }

    public OsmExtractParametersBuilder withOsmTagMapper(OsmTagMapperSource mapper) {
        this.osmTagMapper = mapper;
        return this;
    }

    public OsmExtractParametersBuilder withTimeZone(ZoneId timeZone) {
        this.timeZone = timeZone;
        return this;
    }

    public OsmExtractParametersBuilder withIncludeOsmSubwayEntrances(boolean includeOsmSubwayEntrances) {
        this.includeOsmSubwayEntrances = includeOsmSubwayEntrances;
        return this;
    }

    public URI getSource() {
        return this.source;
    }

    public OsmTagMapperSource getOsmTagMapper() {
        return this.osmTagMapper;
    }

    public ZoneId getTimeZone() {
        return this.timeZone;
    }

    public boolean includeOsmSubwayEntrances() {
        return this.includeOsmSubwayEntrances;
    }

    public OsmExtractParameters build() {
        return new OsmExtractParameters(this);
    }
}

