/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.graph_builder.module.osm.naming;

import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.api.referencing.operation.TransformException;
import org.geotools.geometry.jts.JTS;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.Point;
import org.opentripplanner.framework.geometry.GeometryUtils;
import org.opentripplanner.framework.geometry.HashGridSpatialIndex;
import org.opentripplanner.framework.geometry.SphericalDistanceLibrary;
import org.opentripplanner.framework.i18n.I18NString;
import org.opentripplanner.graph_builder.module.osm.StreetEdgePair;
import org.opentripplanner.graph_builder.services.osm.EdgeNamer;
import org.opentripplanner.osm.model.OsmEntity;
import org.opentripplanner.street.model.edge.StreetEdge;
import org.opentripplanner.utils.lang.DoubleUtils;
import org.opentripplanner.utils.logging.ProgressTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SidewalkNamer
implements EdgeNamer {
    private static final Logger LOG = LoggerFactory.getLogger(SidewalkNamer.class);
    private static final double MIN_PERCENT_IN_BUFFER = 0.85;
    private static final int BUFFER_METERS = 25;
    private HashGridSpatialIndex<EdgeOnLevel> streetEdges = new HashGridSpatialIndex();
    private Collection<EdgeOnLevel> unnamedSidewalks = new ArrayList<EdgeOnLevel>();
    private PreciseBuffer preciseBuffer;

    @Override
    public I18NString name(OsmEntity way) {
        return way.getAssumedName();
    }

    @Override
    public void recordEdges(OsmEntity way, StreetEdgePair pair) {
        if (way.isSidewalk() && way.hasNoName() && !way.isExplicitlyUnnamed()) {
            pair.asIterable().forEach(edge -> this.unnamedSidewalks.add(new EdgeOnLevel((StreetEdge)edge, way.getLevels())));
        } else if (way.isNamed() && !way.isLink()) {
            StreetEdge edge2 = pair.pickAny();
            this.streetEdges.insert(edge2.getGeometry().getEnvelopeInternal(), (Object)new EdgeOnLevel(edge2, way.getLevels()));
        }
    }

    @Override
    public void postprocess() {
        ProgressTracker progress = ProgressTracker.track((String)"Assigning names to sidewalks", (int)500, (long)this.unnamedSidewalks.size());
        this.preciseBuffer = new PreciseBuffer(this.computeEnvelopeCenter(), 25.0);
        AtomicInteger namesApplied = new AtomicInteger(0);
        this.unnamedSidewalks.parallelStream().forEach(sidewalkOnLevel -> {
            this.assignNameToSidewalk((EdgeOnLevel)sidewalkOnLevel, namesApplied);
            progress.step(m -> LOG.info(m));
        });
        LOG.info("Assigned names to {} of {} of sidewalks ({}%)", new Object[]{namesApplied.get(), this.unnamedSidewalks.size(), DoubleUtils.roundTo2Decimals((double)((double)namesApplied.get() / (double)this.unnamedSidewalks.size() * 100.0))});
        LOG.info(progress.completeMessage());
        this.streetEdges = null;
        this.unnamedSidewalks = null;
    }

    private Coordinate computeEnvelopeCenter() {
        Envelope envelope = new Envelope();
        this.unnamedSidewalks.forEach(e -> {
            envelope.expandToInclude(e.edge.getFromVertex().getCoordinate());
            envelope.expandToInclude(e.edge.getToVertex().getCoordinate());
        });
        return envelope.centre();
    }

    private void assignNameToSidewalk(EdgeOnLevel sidewalkOnLevel, AtomicInteger namesApplied) {
        StreetEdge sidewalk = sidewalkOnLevel.edge;
        Geometry buffer = this.preciseBuffer.preciseBuffer((Geometry)sidewalk.getGeometry());
        double sidewalkLength = SphericalDistanceLibrary.length(sidewalk.getGeometry());
        List<EdgeOnLevel> candidates = this.streetEdges.query(buffer.getEnvelopeInternal());
        SidewalkNamer.groupEdgesByName(candidates).filter(g -> g.levels.equals(sidewalkOnLevel.levels)).map(g -> SidewalkNamer.computePercentInsideBuffer(g, buffer, sidewalkLength)).filter(group -> group.percentInBuffer > 0.85).max(Comparator.comparingDouble(NamedEdgeGroup::percentInBuffer)).ifPresent(group -> {
            namesApplied.incrementAndGet();
            sidewalk.setName(Objects.requireNonNull(group.name));
        });
    }

    private static NamedEdgeGroup computePercentInsideBuffer(CandidateGroup g, Geometry buffer, double sidewalkLength) {
        double lengthInsideBuffer = g.intersectionLength(buffer);
        double percentInBuffer = lengthInsideBuffer / sidewalkLength;
        return new NamedEdgeGroup(percentInBuffer, g.name);
    }

    private static Stream<CandidateGroup> groupEdgesByName(List<EdgeOnLevel> candidates) {
        return candidates.stream().collect(Collectors.groupingBy(e -> e.edge.getName())).entrySet().stream().map(entry -> {
            Set<String> levels = ((List)entry.getValue()).stream().flatMap(e -> e.levels.stream()).collect(Collectors.toSet());
            return new CandidateGroup((I18NString)entry.getKey(), ((List)entry.getValue()).stream().map(e -> e.edge).toList(), levels);
        });
    }

    private record EdgeOnLevel(StreetEdge edge, Set<String> levels) {
    }

    private static final class PreciseBuffer {
        private final double distanceInMeters;
        private final MathTransform toTransform;
        private final MathTransform fromTransform;

        private PreciseBuffer(Coordinate coordinate, double distanceInMeters) {
            this.distanceInMeters = distanceInMeters;
            String code = "AUTO:42001,%s,%s".formatted(coordinate.x, coordinate.y);
            try {
                CoordinateReferenceSystem auto = CRS.decode((String)code);
                this.toTransform = CRS.findMathTransform((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, (CoordinateReferenceSystem)auto);
                this.fromTransform = CRS.findMathTransform((CoordinateReferenceSystem)auto, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
            }
            catch (FactoryException e) {
                throw new RuntimeException(e);
            }
        }

        private Geometry preciseBuffer(Geometry geometry) {
            try {
                Geometry pGeom = JTS.transform((Geometry)geometry, (MathTransform)this.toTransform);
                Geometry pBufferedGeom = pGeom.buffer(this.distanceInMeters, 4, 2);
                return JTS.transform((Geometry)pBufferedGeom, (MathTransform)this.fromTransform);
            }
            catch (TransformException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private record CandidateGroup(I18NString name, List<StreetEdge> edges, Set<String> levels) {
        double intersectionLength(Geometry polygon) {
            return this.edges.stream().mapToDouble(edge -> {
                Geometry intersection = polygon.intersection((Geometry)edge.getGeometry());
                return this.length(intersection);
            }).sum();
        }

        private double length(Geometry intersection) {
            Geometry geometry = intersection;
            Objects.requireNonNull(geometry);
            Geometry geometry2 = geometry;
            int n = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{LineString.class, MultiLineString.class, Point.class, Geometry.class}, (Object)geometry2, n)) {
                case 0 -> {
                    LineString ls = (LineString)geometry2;
                    yield SphericalDistanceLibrary.length(ls);
                }
                case 1 -> {
                    MultiLineString mls = (MultiLineString)geometry2;
                    yield GeometryUtils.getLineStrings(mls).stream().mapToDouble(this::intersectionLength).sum();
                }
                case 2 -> {
                    Point ignored = (Point)geometry2;
                    yield 0.0;
                }
                default -> {
                    Geometry g = geometry2;
                    throw new IllegalStateException("Didn't expect geometry %s".formatted(g.getClass()));
                }
            };
        }
    }

    private record NamedEdgeGroup(double percentInBuffer, I18NString name) {
        NamedEdgeGroup {
            Objects.requireNonNull(name);
        }
    }
}

