/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.graph_builder.module.osm.naming;

import java.util.HashSet;
import org.opentripplanner.framework.i18n.I18NString;
import org.opentripplanner.framework.i18n.NonLocalizedString;
import org.opentripplanner.graph_builder.module.osm.StreetEdgePair;
import org.opentripplanner.graph_builder.services.osm.EdgeNamer;
import org.opentripplanner.osm.model.OsmEntity;
import org.opentripplanner.street.model.edge.StreetEdge;

public class PortlandCustomNamer
implements EdgeNamer {
    public static String[] STREET_SUFFIXES = new String[]{"Avenue", "Street", "Drive", "Court", "Highway", "Lane", "Way", "Place", "Road", "Boulevard", "Alley"};
    public static String[] PATH_WORDS = new String[]{"Trail", "Trails", "Greenway", "Esplanade", "Spur", "Loop"};
    private final HashSet<StreetEdge> nameByOrigin = new HashSet();
    private final HashSet<StreetEdge> nameByDestination = new HashSet();

    @Override
    public I18NString name(OsmEntity way) {
        I18NString defaultName = way.getAssumedName();
        if (!way.hasTag("name")) {
            return defaultName;
        }
        if ((way.isTag("footway", "sidewalk") || way.isTag("path", "sidewalk")) && this.isStreet(defaultName.toString())) {
            return NonLocalizedString.ofNullable(this.sidewalk(defaultName.toString()));
        }
        String highway = way.getTag("highway");
        if (("footway".equals(highway) || "path".equals(highway) || "cycleway".equals(highway)) && !this.isObviouslyPath(defaultName.toString())) {
            return NonLocalizedString.ofNullable(this.path(defaultName.toString()));
        }
        if ("pedestrian".equals(highway)) {
            return NonLocalizedString.ofNullable(this.pedestrianStreet(defaultName.toString()));
        }
        return defaultName;
    }

    @Override
    public void recordEdges(OsmEntity way, StreetEdgePair edgePair) {
        boolean isHighwayLink = PortlandCustomNamer.isHighwayLink(way);
        boolean isLowerLink = PortlandCustomNamer.isLowerLink(way);
        edgePair.asIterable().forEach(edge -> {
            if (!edge.nameIsDerived()) {
                return;
            }
            if (isHighwayLink) {
                if (edge.isBack()) {
                    this.nameByDestination.add((StreetEdge)edge);
                } else {
                    this.nameByOrigin.add((StreetEdge)edge);
                }
            } else if (isLowerLink) {
                if (edge.isBack()) {
                    this.nameByOrigin.add((StreetEdge)edge);
                } else {
                    this.nameByDestination.add((StreetEdge)edge);
                }
            }
        });
    }

    @Override
    public void postprocess() {
        for (StreetEdge e : this.nameByOrigin) {
            PortlandCustomNamer.nameAccordingToOrigin(e, 15);
        }
        for (StreetEdge e : this.nameByDestination) {
            PortlandCustomNamer.nameAccordingToDestination(e, 15);
        }
    }

    private boolean isStreet(String defaultName) {
        for (String suffix : STREET_SUFFIXES) {
            if (!defaultName.endsWith(suffix)) continue;
            return true;
        }
        return false;
    }

    private boolean isObviouslyPath(String defaultName) {
        for (String word : PATH_WORDS) {
            if (!defaultName.contains(word)) continue;
            return true;
        }
        return false;
    }

    private String path(String name) {
        if (!((String)name).toLowerCase().contains("path")) {
            name = (String)name + " (path)".intern();
        }
        return name;
    }

    private String pedestrianStreet(String name) {
        if (!((String)name).toLowerCase().contains("pedestrian street")) {
            name = (String)name + " (pedestrian street)".intern();
        }
        return name;
    }

    private String sidewalk(String name) {
        if (!((String)name).toLowerCase().contains("sidewalk")) {
            name = (String)name + " (sidewalk)".intern();
        }
        return name;
    }

    private static String nameAccordingToDestination(StreetEdge e, int maxDepth) {
        if (maxDepth == 0) {
            return null;
        }
        for (StreetEdge out : e.getToVertex().getOutgoingStreetEdges()) {
            String name;
            if (out.nameIsDerived()) {
                name = PortlandCustomNamer.nameAccordingToDestination(out, maxDepth - 1);
                if (name == null) continue;
                e.setName(new NonLocalizedString(name));
                return name;
            }
            name = out.getDefaultName();
            e.setName(new NonLocalizedString(name));
            return name;
        }
        return null;
    }

    private static String nameAccordingToOrigin(StreetEdge e, int maxDepth) {
        if (maxDepth == 0) {
            return null;
        }
        for (StreetEdge in : e.getFromVertex().getIncomingStreetEdges()) {
            String name;
            if (in.nameIsDerived()) {
                name = PortlandCustomNamer.nameAccordingToOrigin(in, maxDepth - 1);
                if (name == null) continue;
                e.setName(new NonLocalizedString(name));
                return name;
            }
            name = in.getDefaultName();
            e.setName(new NonLocalizedString(name));
            return name;
        }
        return null;
    }

    private static boolean isHighwayLink(OsmEntity way) {
        String highway = way.getTag("highway");
        return "motorway_link".equals(highway) || "trunk_link".equals(highway);
    }

    private static boolean isLowerLink(OsmEntity way) {
        String highway = way.getTag("highway");
        return "secondary_link".equals(highway) || "primary_link".equals(highway) || "tertiary_link".equals(highway);
    }
}

