/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.graph_builder.module.osm;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygon;
import org.opentripplanner.astar.model.GraphPath;
import org.opentripplanner.astar.model.ShortestPathTree;
import org.opentripplanner.astar.spi.SkipEdgeStrategy;
import org.opentripplanner.framework.geometry.GeometryUtils;
import org.opentripplanner.framework.geometry.SphericalDistanceLibrary;
import org.opentripplanner.framework.i18n.I18NString;
import org.opentripplanner.graph_builder.issue.api.DataImportIssueStore;
import org.opentripplanner.graph_builder.module.osm.AreaTooComplicated;
import org.opentripplanner.graph_builder.module.osm.LinearBarrierNodeType;
import org.opentripplanner.graph_builder.module.osm.OsmArea;
import org.opentripplanner.graph_builder.module.osm.OsmAreaGroup;
import org.opentripplanner.graph_builder.module.osm.OsmDatabase;
import org.opentripplanner.graph_builder.module.osm.Ring;
import org.opentripplanner.graph_builder.module.osm.SafetyValueNormalizer;
import org.opentripplanner.graph_builder.module.osm.UnconnectedArea;
import org.opentripplanner.graph_builder.module.osm.VertexGenerator;
import org.opentripplanner.graph_builder.services.osm.EdgeNamer;
import org.opentripplanner.osm.model.OsmEntity;
import org.opentripplanner.osm.model.OsmNode;
import org.opentripplanner.osm.model.OsmRelation;
import org.opentripplanner.osm.model.OsmRelationMember;
import org.opentripplanner.osm.model.TraverseDirection;
import org.opentripplanner.osm.wayproperty.WayProperties;
import org.opentripplanner.routing.api.request.RouteRequest;
import org.opentripplanner.routing.api.request.StreetMode;
import org.opentripplanner.routing.api.request.request.StreetRequest;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.service.osminfo.OsmInfoGraphBuildRepository;
import org.opentripplanner.service.osminfo.model.Platform;
import org.opentripplanner.street.model.StreetTraversalPermission;
import org.opentripplanner.street.model.edge.Area;
import org.opentripplanner.street.model.edge.AreaEdge;
import org.opentripplanner.street.model.edge.AreaEdgeBuilder;
import org.opentripplanner.street.model.edge.AreaGroup;
import org.opentripplanner.street.model.edge.Edge;
import org.opentripplanner.street.model.edge.StreetEdge;
import org.opentripplanner.street.model.vertex.IntersectionVertex;
import org.opentripplanner.street.model.vertex.OsmVertex;
import org.opentripplanner.street.model.vertex.Vertex;
import org.opentripplanner.street.search.StreetSearchBuilder;
import org.opentripplanner.street.search.state.State;
import org.opentripplanner.street.search.strategy.DominanceFunctions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class WalkableAreaBuilder {
    private final DataImportIssueStore issueStore;
    private final int maxAreaNodes;
    private final Graph graph;
    private final OsmDatabase osmdb;
    private final OsmInfoGraphBuildRepository osmInfoGraphBuildRepository;
    private final Map<OsmEntity, WayProperties> wayPropertiesCache = new HashMap<OsmEntity, WayProperties>();
    private final VertexGenerator vertexBuilder;
    private final boolean platformEntriesLinking;
    private final List<OsmVertex> platformLinkingPoints;
    private final Set<String> boardingLocationRefTags;
    private final EdgeNamer namer;
    private final SafetyValueNormalizer normalizer;
    private static final String labelTemplate = "way (area) %s from %s to %s";
    private static final Logger LOG = LoggerFactory.getLogger(WalkableAreaBuilder.class);

    public WalkableAreaBuilder(Graph graph, OsmDatabase osmdb, OsmInfoGraphBuildRepository osmInfoGraphBuildRepository, VertexGenerator vertexBuilder, EdgeNamer namer, SafetyValueNormalizer normalizer, DataImportIssueStore issueStore, int maxAreaNodes, boolean platformEntriesLinking, Set<String> boardingLocationRefTags) {
        this.graph = graph;
        this.osmdb = osmdb;
        this.osmInfoGraphBuildRepository = osmInfoGraphBuildRepository;
        this.vertexBuilder = vertexBuilder;
        this.namer = namer;
        this.normalizer = normalizer;
        this.issueStore = issueStore;
        this.maxAreaNodes = maxAreaNodes;
        this.platformEntriesLinking = platformEntriesLinking;
        this.boardingLocationRefTags = boardingLocationRefTags;
        this.platformLinkingPoints = platformEntriesLinking ? graph.getVertices().stream().filter(OsmVertex.class::isInstance).map(OsmVertex.class::cast).filter(this::isPlatformLinkingPoint).collect(Collectors.toList()) : List.of();
    }

    public void buildWithoutVisibility(OsmAreaGroup group) {
        for (Ring ring : group.outermostRings) {
            HashSet<AreaEdge> edges = new HashSet<AreaEdge>();
            AreaGroup areaGroup = new AreaGroup(ring.jtsPolygon);
            HashSet<NodeEdge> alreadyAddedEdges = new HashSet<NodeEdge>();
            for (OsmArea area : group.areas) {
                if (!ring.jtsPolygon.contains((Geometry)area.jtsMultiPolygon)) continue;
                for (Ring outerRing : area.outermostRings) {
                    for (int i = 0; i < outerRing.nodes.size(); ++i) {
                        edges.addAll(this.createEdgesForRingSegment(areaGroup, area, outerRing, i, alreadyAddedEdges));
                    }
                    for (Ring innerRing : outerRing.getHoles()) {
                        for (int j = 0; j < innerRing.nodes.size(); ++j) {
                            edges.addAll(this.createEdgesForRingSegment(areaGroup, area, innerRing, j, alreadyAddedEdges));
                        }
                    }
                }
            }
            Set<IntersectionVertex> vertices = edges.stream().flatMap(v -> Stream.of(v.getFromVertex(), v.getToVertex()).filter(IntersectionVertex.class::isInstance).map(IntersectionVertex.class::cast)).collect(Collectors.toSet());
            areaGroup.addVisibilityVertices(vertices);
            this.createAreas(areaGroup, ring, group.areas);
        }
    }

    public void buildWithVisibility(OsmAreaGroup group) {
        HashSet<Vertex> startingVertices = new HashSet<Vertex>();
        HashSet<Edge> edges = new HashSet<Edge>();
        HashSet<Edge> ringEdges = new HashSet<Edge>();
        HashMap<AreaGroup, HashSet> visibilityVertexCandidates = new HashMap<AreaGroup, HashSet>();
        Set<Long> osmWayIds = group.areas.stream().map(area -> area.parent).flatMap(osmEntity -> {
            Stream<Long> stream;
            if (osmEntity instanceof OsmRelation) {
                OsmRelation relation = (OsmRelation)osmEntity;
                stream = relation.getMembers().stream().map(OsmRelationMember::getRef);
            } else {
                stream = Stream.of(Long.valueOf(osmEntity.getId()));
            }
            return stream;
        }).collect(Collectors.toSet());
        for (Ring ring : group.outermostRings) {
            Polygon polygon = ring.jtsPolygon;
            AreaGroup areaGroup2 = new AreaGroup(polygon);
            HashSet<NodeEdge> alreadyAddedEdges = new HashSet<NodeEdge>();
            HashSet<IntersectionVertex> platformLinkingVertices = new HashSet<IntersectionVertex>();
            HashSet<IntersectionVertex> visibilityVertices = new HashSet<IntersectionVertex>();
            GeometryFactory geometryFactory = GeometryUtils.getGeometryFactory();
            for (OsmArea area2 : group.areas) {
                OsmEntity areaEntity = area2.parent;
                if (!group.isSimpleAreaGroup() && !polygon.contains((Geometry)area2.jtsMultiPolygon)) continue;
                Collection<OsmNode> entrances = this.osmdb.getStopsInArea(area2.parent);
                for (OsmNode node : entrances) {
                    IntersectionVertex vertex = this.vertexBuilder.getVertexForOsmNode(node, areaEntity, LinearBarrierNodeType.SPLIT);
                    platformLinkingVertices.add(vertex);
                    visibilityVertices.add(vertex);
                    startingVertices.add(vertex);
                }
                for (Ring outerRing : area2.outermostRings) {
                    boolean linkPointsAdded;
                    boolean bl = linkPointsAdded = !entrances.isEmpty();
                    if (this.platformEntriesLinking && area2.parent.isPlatform()) {
                        List<OsmVertex> verticesWithin = this.platformLinkingPoints.stream().filter(t -> outerRing.jtsPolygon.contains((Geometry)geometryFactory.createPoint(t.getCoordinate()))).toList();
                        platformLinkingVertices.addAll(verticesWithin);
                        for (OsmVertex v : verticesWithin) {
                            startingVertices.add(v);
                            visibilityVertices.add(v);
                            linkPointsAdded = true;
                        }
                    }
                    for (int i = 0; i < outerRing.nodes.size(); ++i) {
                        OsmNode node = outerRing.nodes.get(i);
                        Set<AreaEdge> newEdges = this.createEdgesForRingSegment(areaGroup2, area2, outerRing, i, alreadyAddedEdges);
                        edges.addAll(newEdges);
                        ringEdges.addAll(newEdges);
                        if (outerRing.isNodeConvex(i) || linkPointsAdded && (i == 0 || i == outerRing.nodes.size() / 2)) {
                            visibilityVertices.add(this.vertexBuilder.getVertexForOsmNode(node, areaEntity, LinearBarrierNodeType.SPLIT));
                        }
                        if (!this.isStartingNode(node, osmWayIds)) continue;
                        IntersectionVertex v = this.vertexBuilder.getVertexForOsmNode(node, areaEntity, LinearBarrierNodeType.SPLIT);
                        startingVertices.add(v);
                        visibilityVertices.add(v);
                    }
                    for (Ring innerRing : outerRing.getHoles()) {
                        for (int j = 0; j < innerRing.nodes.size(); ++j) {
                            OsmNode node = innerRing.nodes.get(j);
                            Set<AreaEdge> newEdges = this.createEdgesForRingSegment(areaGroup2, area2, innerRing, j, alreadyAddedEdges);
                            edges.addAll(newEdges);
                            ringEdges.addAll(newEdges);
                            if (!innerRing.isNodeConvex(j)) {
                                visibilityVertices.add(this.vertexBuilder.getVertexForOsmNode(node, areaEntity, LinearBarrierNodeType.SPLIT));
                            }
                            if (!this.isStartingNode(node, osmWayIds)) continue;
                            IntersectionVertex v = this.vertexBuilder.getVertexForOsmNode(node, areaEntity, LinearBarrierNodeType.SPLIT);
                            startingVertices.add(v);
                            visibilityVertices.add(v);
                        }
                    }
                }
            }
            if (visibilityVertices.isEmpty()) {
                this.issueStore.add(new UnconnectedArea(group));
                for (Edge edge : edges) {
                    this.graph.removeEdge(edge);
                }
                continue;
            }
            if (visibilityVertices.size() > this.maxAreaNodes) {
                this.issueStore.add(new AreaTooComplicated(group, visibilityVertices.size(), this.maxAreaNodes));
            }
            visibilityVertexCandidates.put(areaGroup2, visibilityVertices);
            this.createAreas(areaGroup2, ring, group.areas);
            float skip_ratio = (float)this.maxAreaNodes / (float)visibilityVertices.size();
            int i = 0;
            float sum_i = 0.0f;
            for (IntersectionVertex vertex1 : visibilityVertices) {
                if (Math.floor(sum_i += skip_ratio) < (double)(i + 1)) continue;
                i = (int)Math.floor(sum_i);
                int j = 0;
                float sum_j = 0.0f;
                for (IntersectionVertex vertex2 : visibilityVertices) {
                    Coordinate[] coordinates;
                    LineString line;
                    if (Math.floor(sum_j += skip_ratio) < (double)(j + 1)) continue;
                    j = (int)Math.floor(sum_j);
                    if (this.shouldSkipEdge(vertex1, vertex2, alreadyAddedEdges) || !polygon.contains((Geometry)(line = geometryFactory.createLineString(coordinates = new Coordinate[]{vertex1.getCoordinate(), vertex2.getCoordinate()})))) continue;
                    Set<AreaEdge> segments = this.createSegments(vertex1, vertex2, group.areas, areaGroup2, true);
                    edges.addAll(segments);
                    if (platformLinkingVertices.contains(vertex1)) {
                        ringEdges.addAll(segments);
                    }
                    if (!platformLinkingVertices.contains(vertex2)) continue;
                    ringEdges.addAll(segments);
                }
            }
        }
        this.pruneAreaEdges(startingVertices, edges, ringEdges);
        visibilityVertexCandidates.forEach((areaGroup, vertices) -> {
            if (vertices.size() > this.maxAreaNodes) {
                areaGroup.addVisibilityVertices(vertices.stream().sorted((v1, v2) -> Long.compare(v2.getDegreeOut(), v1.getDegreeOut())).limit(this.maxAreaNodes).collect(Collectors.toSet()));
            } else {
                areaGroup.addVisibilityVertices((Set<IntersectionVertex>)vertices);
            }
        });
    }

    private void pruneAreaEdges(Collection<Vertex> startingVertices, Set<Edge> edges, Set<Edge> edgesToKeep) {
        if (edges.isEmpty()) {
            return;
        }
        StreetEdge firstEdge = (StreetEdge)edges.iterator().next();
        StreetMode mode = firstEdge.getPermission().allows(StreetTraversalPermission.PEDESTRIAN) ? StreetMode.WALK : (firstEdge.getPermission().allows(StreetTraversalPermission.BICYCLE) ? StreetMode.BIKE : StreetMode.CAR);
        RouteRequest request = RouteRequest.defaultValue();
        HashSet usedEdges = new HashSet();
        for (Vertex vertex : startingVertices) {
            ShortestPathTree spt = ((StreetSearchBuilder)((StreetSearchBuilder)((StreetSearchBuilder)StreetSearchBuilder.of().setSkipEdgeStrategy(new ListedEdgesOnly(edges))).setDominanceFunction(new DominanceFunctions.EarliestArrival())).setRequest(request).setStreetRequest(new StreetRequest(mode)).setFrom(vertex)).getShortestPathTree();
            for (Vertex endVertex : startingVertices) {
                GraphPath path = spt.getPath(endVertex);
                if (path == null) continue;
                usedEdges.addAll(path.edges);
            }
        }
        for (Edge edge : edges) {
            if (usedEdges.contains(edge) || edgesToKeep.contains(edge)) continue;
            this.graph.removeEdge(edge);
        }
    }

    private boolean isStartingNode(OsmNode node, Set<Long> osmWayIds) {
        return this.osmdb.isNodeBelongsToWay(node.getId()) || !this.osmdb.getAreasForNode(node.getId()).stream().allMatch(osmWay -> osmWayIds.contains(osmWay.getId())) || node.isBoardingLocation();
    }

    private WayProperties findAreaProperties(OsmEntity entity) {
        if (!this.wayPropertiesCache.containsKey(entity)) {
            WayProperties wayData = entity.getOsmProvider().getWayPropertySet().getDataForEntity(entity);
            this.wayPropertiesCache.put(entity, wayData);
            return wayData;
        }
        return this.wayPropertiesCache.get(entity);
    }

    private Set<AreaEdge> createEdgesForRingSegment(AreaGroup areaGroup, OsmArea area, Ring ring, int i, HashSet<NodeEdge> alreadyAddedEdges) {
        IntersectionVertex v2;
        OsmNode node = ring.nodes.get(i);
        OsmNode nextNode = ring.nodes.get((i + 1) % ring.nodes.size());
        IntersectionVertex v1 = this.vertexBuilder.getVertexForOsmNode(node, area.parent, LinearBarrierNodeType.SPLIT);
        if (this.shouldSkipEdge(v1, v2 = this.vertexBuilder.getVertexForOsmNode(nextNode, area.parent, LinearBarrierNodeType.SPLIT), alreadyAddedEdges)) {
            return Set.of();
        }
        return this.createSegments(v1, v2, List.of(area), areaGroup, false);
    }

    private Set<AreaEdge> createSegments(IntersectionVertex vertex1, IntersectionVertex vertex2, Collection<OsmArea> areas, AreaGroup areaGroup, boolean testIntersection) {
        Coordinate[] coordinates = new Coordinate[]{vertex1.getCoordinate(), vertex2.getCoordinate()};
        double length = SphericalDistanceLibrary.distance(vertex1.getCoordinate(), vertex2.getCoordinate());
        if (length < 0.01) {
            return Set.of();
        }
        GeometryFactory geometryFactory = GeometryUtils.getGeometryFactory();
        LineString line = geometryFactory.createLineString(coordinates);
        OsmEntity parent = null;
        WayProperties wayData = null;
        StreetTraversalPermission areaPermissions = StreetTraversalPermission.ALL;
        boolean wheelchairAccessible = true;
        for (OsmArea area : areas) {
            MultiPolygon polygon = area.jtsMultiPolygon;
            boolean bl = testIntersection ? polygon.intersection((Geometry)line).getLength() > 1.0E-6 : true;
            boolean crosses = bl;
            if (!crosses) continue;
            parent = area.parent;
            wayData = this.findAreaProperties(parent);
            areaPermissions = areaPermissions.intersection(wayData.getPermission());
            wheelchairAccessible = wheelchairAccessible && parent.isWheelchairAccessible();
        }
        if (parent == null) {
            return Set.of();
        }
        String label = String.format(labelTemplate, parent.getId(), vertex1.getLabel(), vertex2.getLabel());
        float carSpeed = parent.getOsmProvider().getOsmTagMapper().getCarSpeedForWay(parent, TraverseDirection.DIRECTIONLESS);
        I18NString name = this.namer.getNameForWay(parent, label);
        AreaEdgeBuilder streetEdgeBuilder = (AreaEdgeBuilder)((AreaEdgeBuilder)((AreaEdgeBuilder)((AreaEdgeBuilder)((AreaEdgeBuilder)((AreaEdgeBuilder)((AreaEdgeBuilder)((AreaEdgeBuilder)((AreaEdgeBuilder)((AreaEdgeBuilder)((AreaEdgeBuilder)new AreaEdgeBuilder().withFromVertex(vertex1)).withToVertex(vertex2)).withGeometry(line)).withName(name)).withMeterLength(length)).withPermission(areaPermissions)).withBack(false)).withArea(areaGroup).withCarSpeed(carSpeed)).withBogusName(parent.hasNoName())).withWheelchairAccessible(wheelchairAccessible)).withLink(parent.isLink());
        label = String.format(labelTemplate, parent.getId(), vertex2.getLabel(), vertex1.getLabel());
        name = this.namer.getNameForWay(parent, label);
        AreaEdgeBuilder backStreetEdgeBuilder = (AreaEdgeBuilder)((AreaEdgeBuilder)((AreaEdgeBuilder)((AreaEdgeBuilder)((AreaEdgeBuilder)((AreaEdgeBuilder)((AreaEdgeBuilder)((AreaEdgeBuilder)((AreaEdgeBuilder)((AreaEdgeBuilder)((AreaEdgeBuilder)new AreaEdgeBuilder().withFromVertex(vertex2)).withToVertex(vertex1)).withGeometry(line.reverse())).withName(name)).withMeterLength(length)).withPermission(areaPermissions)).withBack(true)).withArea(areaGroup).withCarSpeed(carSpeed)).withBogusName(parent.hasNoName())).withWheelchairAccessible(wheelchairAccessible)).withLink(parent.isLink());
        AreaEdge street = streetEdgeBuilder.buildAndConnect();
        AreaEdge backStreet = backStreetEdgeBuilder.buildAndConnect();
        this.normalizer.applyWayProperties(street, backStreet, wayData, wayData, parent);
        return Set.of(street, backStreet);
    }

    private void createAreas(AreaGroup areaGroup, Ring ring, Collection<OsmArea> areas) {
        Polygon containingArea = ring.jtsPolygon;
        for (OsmArea area : areas) {
            Set<String> references;
            Geometry intersection = containingArea.intersection((Geometry)area.jtsMultiPolygon);
            if (intersection.getArea() == 0.0) continue;
            Area namedArea = new Area();
            OsmEntity areaEntity = area.parent;
            String id = "way (area) " + areaEntity.getId();
            I18NString name = this.namer.getNameForWay(areaEntity, id);
            namedArea.setName(name);
            WayProperties wayData = this.findAreaProperties(areaEntity);
            namedArea.setBicycleSafety((float)wayData.bicycleSafety());
            namedArea.setWalkSafety((float)wayData.walkSafety());
            namedArea.setGeometry(intersection);
            namedArea.setPermission(wayData.getPermission());
            areaGroup.addArea(namedArea);
            if (!areaEntity.isBoardingLocation() || (references = areaEntity.getMultiTagValues(this.boardingLocationRefTags)).isEmpty()) continue;
            Platform platform = new Platform(name, (Geometry)area.findInteriorPoint(), references);
            this.osmInfoGraphBuildRepository.addPlatform(namedArea, platform);
        }
    }

    private boolean isPlatformLinkingPoint(OsmVertex osmVertex) {
        boolean isCandidate = false;
        Vertex start = null;
        for (Edge e : osmVertex.getIncoming()) {
            if (!(e instanceof StreetEdge)) continue;
            Edge se = (StreetEdge)e;
            if (e instanceof AreaEdge || !Arrays.asList(1, 2, 3).contains(((StreetEdge)se).getPermission().code)) continue;
            isCandidate = true;
            start = se.getFromVertex();
            break;
        }
        if (isCandidate && start != null) {
            boolean isLinkingPoint = true;
            for (Edge se : osmVertex.getOutgoing()) {
                if (se.getToVertex().getCoordinate().equals((Object)start.getCoordinate()) || se instanceof AreaEdge) continue;
                isLinkingPoint = false;
            }
            return isLinkingPoint;
        }
        return false;
    }

    private boolean shouldSkipEdge(IntersectionVertex v1, IntersectionVertex v2, HashSet<NodeEdge> alreadyAddedEdges) {
        if (v1 == v2) {
            return true;
        }
        NodeEdge edge = new NodeEdge(v1, v2);
        if (alreadyAddedEdges.contains(edge) || alreadyAddedEdges.contains(new NodeEdge(v2, v1))) {
            return true;
        }
        alreadyAddedEdges.add(edge);
        return false;
    }

    record ListedEdgesOnly(Set<Edge> edges) implements SkipEdgeStrategy<State, Edge>
    {
        @Override
        public boolean shouldSkipEdge(State current, Edge edge) {
            return !this.edges.contains(edge);
        }
    }

    private record NodeEdge(IntersectionVertex from, IntersectionVertex to) {
    }
}

