/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.graph_builder.module.osm;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import gnu.trove.list.TLongList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.locationtech.jts.geom.Coordinate;
import org.opentripplanner.framework.i18n.NonLocalizedString;
import org.opentripplanner.graph_builder.issue.api.DataImportIssueStore;
import org.opentripplanner.graph_builder.issues.BarrierIntersectingHighway;
import org.opentripplanner.graph_builder.issues.DifferentLevelsSharingBarrier;
import org.opentripplanner.graph_builder.module.osm.LinearBarrierNodeType;
import org.opentripplanner.graph_builder.module.osm.OsmArea;
import org.opentripplanner.graph_builder.module.osm.OsmDatabase;
import org.opentripplanner.graph_builder.module.osm.Ring;
import org.opentripplanner.osm.model.OsmEntity;
import org.opentripplanner.osm.model.OsmLevel;
import org.opentripplanner.osm.model.OsmNode;
import org.opentripplanner.osm.model.OsmWay;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.street.model.vertex.BarrierVertex;
import org.opentripplanner.street.model.vertex.IntersectionVertex;
import org.opentripplanner.street.model.vertex.OsmVertex;
import org.opentripplanner.street.model.vertex.VertexFactory;
import org.opentripplanner.transit.model.basic.Accessibility;

class VertexGenerator {
    private static final String nodeLabelFormat = "osm:node:%d";
    private final Map<Long, IntersectionVertex> intersectionNodes = new HashMap<Long, IntersectionVertex>();
    private final HashMap<Long, Map<OsmLevel, OsmVertex>> multiLevelNodes = new HashMap();
    private final Multimap<OsmNode, OsmWay> nodesInBarrierWays = HashMultimap.create();
    private final Multimap<OsmNode, OsmLevel> levelsConnectingBarriers = HashMultimap.create();
    private final Set<OsmNode> reportedLevelBarrierNodes = new HashSet<OsmNode>();
    private final Set<OsmNode> reportedLinearBarrierCrossings = new HashSet<OsmNode>();
    private final Map<OsmNode, Map<OsmEntity, OsmVertex>> splitVerticesOnBarriers = new HashMap<OsmNode, Map<OsmEntity, OsmVertex>>();
    private final OsmDatabase osmdb;
    private final Set<String> boardingAreaRefTags;
    private final Boolean includeOsmSubwayEntrances;
    private final VertexFactory vertexFactory;
    private final DataImportIssueStore issueStore;

    public VertexGenerator(OsmDatabase osmdb, Graph graph, Set<String> boardingAreaRefTags, boolean includeOsmSubwayEntrances, DataImportIssueStore issueStore) {
        this.osmdb = osmdb;
        this.vertexFactory = new VertexFactory(graph);
        this.boardingAreaRefTags = boardingAreaRefTags;
        this.includeOsmSubwayEntrances = includeOsmSubwayEntrances;
        this.issueStore = issueStore;
    }

    IntersectionVertex getVertexForOsmNode(OsmNode node, OsmEntity way, LinearBarrierNodeType linearBarrierNodeType) {
        IntersectionVertex iv = null;
        if (node.isMultiLevel()) {
            return this.recordLevel(node, way);
        }
        boolean isNodeOnLinearBarrier = this.nodesInBarrierWays.containsKey((Object)node);
        if (linearBarrierNodeType == LinearBarrierNodeType.SPLIT && isNodeOnLinearBarrier) {
            return this.getSplitVertexOnBarrier(node, way);
        }
        long nid = node.getId();
        iv = this.intersectionNodes.get(nid);
        if (iv == null) {
            String ref;
            Coordinate coordinate = node.getCoordinate();
            String highway = node.getTag("highway");
            if ("motorway_junction".equals(highway) && (ref = node.getTag("ref")) != null) {
                iv = this.vertexFactory.exit(nid, coordinate, ref);
            }
            if (node.isBoardingLocation()) {
                String label = String.format(nodeLabelFormat, node.getId());
                Set<String> refs = node.getMultiTagValues(this.boardingAreaRefTags);
                if (!refs.isEmpty()) {
                    String name = node.getTag("name");
                    iv = this.vertexFactory.osmBoardingLocation(coordinate, label, refs, NonLocalizedString.ofNullable(name));
                }
            }
            if (this.includeOsmSubwayEntrances.booleanValue() && node.isSubwayEntrance()) {
                ref = node.getTag("ref");
                iv = this.vertexFactory.stationEntrance(nid, coordinate, ref, node.explicitWheelchairAccessibility());
            }
            if (iv == null && node.isBarrier()) {
                iv = this.vertexFactory.barrier(nid, coordinate, node.explicitWheelchairAccessibility());
            }
            if (iv instanceof BarrierVertex) {
                BarrierVertex bv = (BarrierVertex)iv;
                bv.setBarrierPermissions(node.overridePermissions(BarrierVertex.defaultBarrierPermissions));
                if (bv.wheelchairAccessibility() == Accessibility.NO_INFORMATION && !node.isWheelchairAccessible()) {
                    bv.setWheelchairAccessibility(Accessibility.NOT_POSSIBLE);
                }
            }
            if (iv == null) {
                iv = this.vertexFactory.osm(coordinate, node.getId(), node.hasHighwayTrafficLight(), node.hasCrossingTrafficLight());
            }
            if (isNodeOnLinearBarrier && iv instanceof OsmVertex) {
                OsmVertex ov = (OsmVertex)iv;
                this.splitVerticesOnBarriers.putIfAbsent(node, new HashMap());
                Map<OsmEntity, OsmVertex> vertices = this.splitVerticesOnBarriers.get(node);
                vertices.put(null, ov);
                if (!node.isTaggedBarrierCrossing() && !this.reportedLinearBarrierCrossings.contains(node)) {
                    this.issueStore.add(new BarrierIntersectingHighway(node));
                    this.reportedLinearBarrierCrossings.add(node);
                }
            }
            this.intersectionNodes.put(nid, iv);
        }
        if (iv instanceof BarrierVertex) {
            this.checkLevelOnBarrier(node, way);
        }
        return iv;
    }

    private IntersectionVertex getSplitVertexOnBarrier(OsmNode nodeOnBarrier, OsmEntity way) {
        this.checkLevelOnBarrier(nodeOnBarrier, way);
        this.splitVerticesOnBarriers.putIfAbsent(nodeOnBarrier, new HashMap());
        Map<OsmEntity, OsmVertex> vertices = this.splitVerticesOnBarriers.get(nodeOnBarrier);
        OsmVertex existing = vertices.get(way);
        if (existing != null) {
            return existing;
        }
        OsmVertex vertex = this.vertexFactory.osmOnLinearBarrier(nodeOnBarrier.getCoordinate(), nodeOnBarrier.getId(), way.getId());
        vertices.put(way, vertex);
        return vertex;
    }

    private void checkLevelOnBarrier(OsmNode nodeOnBarrier, OsmEntity way) {
        Collection existingLevels;
        OsmLevel level = this.osmdb.getLevelForWay(way);
        if (!this.reportedLevelBarrierNodes.contains(nodeOnBarrier) && (existingLevels = this.levelsConnectingBarriers.get((Object)nodeOnBarrier)).stream().anyMatch(l -> !Objects.requireNonNull(l).equals(level))) {
            this.issueStore.add(new DifferentLevelsSharingBarrier(nodeOnBarrier));
            this.reportedLevelBarrierNodes.add(nodeOnBarrier);
        }
        this.levelsConnectingBarriers.put((Object)nodeOnBarrier, (Object)level);
    }

    Map<Long, Map<OsmLevel, OsmVertex>> multiLevelNodes() {
        return this.multiLevelNodes;
    }

    void initIntersectionNodes() {
        HashSet<Long> possibleIntersectionNodes = new HashSet<Long>();
        for (OsmWay way : this.osmdb.getWays()) {
            TLongList nodes = way.getNodeRefs();
            nodes.forEach(node -> {
                if (possibleIntersectionNodes.contains(node)) {
                    this.intersectionNodes.put(node, null);
                } else {
                    possibleIntersectionNodes.add(node);
                }
                return true;
            });
        }
        for (OsmArea area : Iterables.concat(this.osmdb.getWalkableAreas(), this.osmdb.getParkAndRideAreas(), this.osmdb.getBikeParkingAreas())) {
            for (Ring outerRing : area.outermostRings) {
                this.intersectAreaRingNodes(possibleIntersectionNodes, outerRing);
            }
        }
    }

    Collection<OsmWay> getLinearBarriersAtNode(OsmNode node) {
        return this.nodesInBarrierWays.get((Object)node);
    }

    Map<OsmNode, Map<OsmEntity, OsmVertex>> splitVerticesOnBarriers() {
        return this.splitVerticesOnBarriers;
    }

    public Multimap<OsmNode, OsmWay> nodesInBarrierWays() {
        return this.nodesInBarrierWays;
    }

    void initNodesInBarrierWays() {
        for (OsmWay way : this.osmdb.getWays()) {
            if (!way.isBarrier()) continue;
            TLongList nodes = way.getNodeRefs();
            boolean isClosed = nodes.get(0) == nodes.get(nodes.size() - 1);
            for (int i = 0; i < nodes.size() - (isClosed ? 1 : 0); ++i) {
                OsmNode node = this.osmdb.getNode(nodes.get(i));
                if (node == null) continue;
                this.nodesInBarrierWays.put((Object)node, (Object)way);
            }
        }
    }

    Map<Long, IntersectionVertex> intersectionNodes() {
        return this.intersectionNodes;
    }

    private OsmVertex recordLevel(OsmNode node, OsmEntity way) {
        Map<Object, Object> vertices;
        OsmLevel level = this.osmdb.getLevelForWay(way);
        long nodeId = node.getId();
        if (this.multiLevelNodes.containsKey(nodeId)) {
            vertices = this.multiLevelNodes.get(nodeId);
        } else {
            vertices = new HashMap();
            this.multiLevelNodes.put(nodeId, vertices);
        }
        if (!vertices.containsKey(level)) {
            OsmVertex vertex = this.vertexFactory.levelledOsm(node, level.shortName);
            vertices.put(level, vertex);
            return vertex;
        }
        return (OsmVertex)vertices.get(level);
    }

    private void intersectAreaRingNodes(Set<Long> possibleIntersectionNodes, Ring outerRing) {
        for (OsmNode node : outerRing.nodes) {
            long nodeId = node.getId();
            if (possibleIntersectionNodes.contains(nodeId)) {
                this.intersectionNodes.put(nodeId, null);
                continue;
            }
            possibleIntersectionNodes.add(nodeId);
        }
        outerRing.getHoles().forEach(hole -> this.intersectAreaRingNodes(possibleIntersectionNodes, (Ring)hole));
    }
}

