/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.graph_builder.module.osm;

import org.opentripplanner.graph_builder.issue.api.DataImportIssueStore;
import org.opentripplanner.graph_builder.issues.TurnRestrictionBad;
import org.opentripplanner.graph_builder.module.osm.OsmDatabase;
import org.opentripplanner.graph_builder.module.osm.TurnRestrictionTag;
import org.opentripplanner.service.osminfo.OsmInfoGraphBuildRepository;
import org.opentripplanner.street.model.TurnRestriction;
import org.opentripplanner.street.model.edge.StreetEdge;

class TurnRestrictionUnifier {
    TurnRestrictionUnifier() {
    }

    static void unifyTurnRestrictions(OsmDatabase osmdb, DataImportIssueStore issueStore, OsmInfoGraphBuildRepository osmInfoGraphBuildRepository) {
        for (Long fromWay : osmdb.getTurnRestrictionWayIds()) {
            for (TurnRestrictionTag restrictionTag : osmdb.getFromWayTurnRestrictions(fromWay)) {
                if (restrictionTag.possibleFrom.isEmpty()) {
                    issueStore.add(new TurnRestrictionBad(restrictionTag.relationOsmID, "No from edge found"));
                    continue;
                }
                if (restrictionTag.possibleTo.isEmpty()) {
                    issueStore.add(new TurnRestrictionBad(restrictionTag.relationOsmID, "No to edge found"));
                    continue;
                }
                for (StreetEdge from : restrictionTag.possibleFrom) {
                    if (from == null) {
                        issueStore.add(new TurnRestrictionBad(restrictionTag.relationOsmID, "from-edge is null"));
                        continue;
                    }
                    for (StreetEdge to : restrictionTag.possibleTo) {
                        if (to == null) {
                            issueStore.add(new TurnRestrictionBad(restrictionTag.relationOsmID, "to-edge is null"));
                            continue;
                        }
                        int angleDiff = from.getOutAngle() - to.getInAngle();
                        if (angleDiff < 0) {
                            angleDiff += 360;
                        }
                        switch (restrictionTag.direction) {
                            case LEFT: {
                                if (angleDiff < 160) break;
                                issueStore.add(new TurnRestrictionBad(restrictionTag.relationOsmID, "Left turn restriction is not on edges which turn left"));
                                break;
                            }
                            case RIGHT: {
                                if (angleDiff > 200) break;
                                issueStore.add(new TurnRestrictionBad(restrictionTag.relationOsmID, "Right turn restriction is not on edges which turn right"));
                                break;
                            }
                            case U: {
                                if (angleDiff > 150 && angleDiff <= 210) break;
                                issueStore.add(new TurnRestrictionBad(restrictionTag.relationOsmID, "U-turn restriction is not on U-turn"));
                                break;
                            }
                            case STRAIGHT: {
                                if (angleDiff < 30 || angleDiff >= 330) break;
                                issueStore.add(new TurnRestrictionBad(restrictionTag.relationOsmID, "Straight turn restriction is not on edges which go straight"));
                            }
                        }
                        TurnRestriction restriction = new TurnRestriction(from, to, restrictionTag.type, restrictionTag.modes);
                        osmInfoGraphBuildRepository.addTurnRestriction(restriction);
                    }
                }
            }
        }
    }
}

