/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.graph_builder.module.osm;

import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import org.opentripplanner.graph_builder.issue.api.DataImportIssueStore;
import org.opentripplanner.graph_builder.issues.Graphwide;
import org.opentripplanner.osm.model.OsmEntity;
import org.opentripplanner.osm.tagmapping.OsmTagMapper;
import org.opentripplanner.osm.wayproperty.WayProperties;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.street.model.edge.Area;
import org.opentripplanner.street.model.edge.AreaEdge;
import org.opentripplanner.street.model.edge.AreaGroup;
import org.opentripplanner.street.model.edge.Edge;
import org.opentripplanner.street.model.edge.StreetEdge;
import org.opentripplanner.street.model.note.StreetNoteAndMatcher;
import org.opentripplanner.street.model.vertex.Vertex;

class SafetyValueNormalizer {
    private final Graph graph;
    private final DataImportIssueStore issueStore;
    private float bestBikeSafety = 1.0f;
    private float bestWalkSafety = 1.0f;

    SafetyValueNormalizer(Graph graph, DataImportIssueStore issueStore) {
        this.graph = graph;
        this.issueStore = issueStore;
    }

    void applySafetyFactors() {
        this.issueStore.add(new Graphwide("Multiplying all bike safety values by " + 1.0f / this.bestBikeSafety));
        this.issueStore.add(new Graphwide("Multiplying all walk safety values by " + 1.0f / this.bestWalkSafety));
        HashSet<Edge> seenEdges = new HashSet<Edge>();
        HashSet<AreaGroup> seenAreas = new HashSet<AreaGroup>();
        for (Vertex vertex : this.graph.getVertices()) {
            for (Edge e : vertex.getOutgoing()) {
                if (e instanceof AreaEdge) {
                    AreaGroup areaGroup = ((AreaEdge)e).getArea();
                    if (seenAreas.contains(areaGroup)) continue;
                    seenAreas.add(areaGroup);
                    for (Area area : areaGroup.getAreas()) {
                        area.setBicycleSafety(area.getBicycleSafety() / this.bestBikeSafety);
                        area.setWalkSafety(area.getWalkSafety() / this.bestWalkSafety);
                    }
                }
                this.applyFactors(seenEdges, e);
            }
            for (Edge e : vertex.getIncoming()) {
                this.applyFactors(seenEdges, e);
            }
        }
    }

    void applyWayProperties(@Nullable StreetEdge street, @Nullable StreetEdge backStreet, WayProperties forwardWayData, WayProperties backwardWayData, OsmEntity way) {
        double walkSafety;
        double bicycleSafety;
        OsmTagMapper tagMapperForWay = way.getOsmProvider().getOsmTagMapper();
        Set<StreetNoteAndMatcher> notes = way.getOsmProvider().getWayPropertySet().getNoteForWay(way);
        boolean motorVehicleNoThrough = tagMapperForWay.isMotorVehicleThroughTrafficExplicitlyDisallowed(way);
        boolean bicycleNoThrough = tagMapperForWay.isBicycleThroughTrafficExplicitlyDisallowed(way);
        boolean walkNoThrough = tagMapperForWay.isWalkThroughTrafficExplicitlyDisallowed(way);
        if (street != null) {
            bicycleSafety = forwardWayData.bicycleSafety();
            street.setBicycleSafetyFactor((float)bicycleSafety);
            if (bicycleSafety < (double)this.bestBikeSafety) {
                this.bestBikeSafety = (float)bicycleSafety;
            }
            walkSafety = forwardWayData.walkSafety();
            street.setWalkSafetyFactor((float)walkSafety);
            if (walkSafety < (double)this.bestWalkSafety) {
                this.bestWalkSafety = (float)walkSafety;
            }
            if (notes != null) {
                for (StreetNoteAndMatcher it : notes) {
                    this.graph.streetNotesService.addStaticNote(street, it.note(), it.matcher());
                }
            }
            street.setMotorVehicleNoThruTraffic(motorVehicleNoThrough);
            street.setBicycleNoThruTraffic(bicycleNoThrough);
            street.setWalkNoThruTraffic(walkNoThrough);
        }
        if (backStreet != null) {
            bicycleSafety = backwardWayData.bicycleSafety();
            if (bicycleSafety < (double)this.bestBikeSafety) {
                this.bestBikeSafety = (float)bicycleSafety;
            }
            backStreet.setBicycleSafetyFactor((float)bicycleSafety);
            walkSafety = backwardWayData.walkSafety();
            if (walkSafety < (double)this.bestWalkSafety) {
                this.bestWalkSafety = (float)walkSafety;
            }
            backStreet.setWalkSafetyFactor((float)walkSafety);
            if (notes != null) {
                for (StreetNoteAndMatcher it : notes) {
                    this.graph.streetNotesService.addStaticNote(backStreet, it.note(), it.matcher());
                }
            }
            backStreet.setMotorVehicleNoThruTraffic(motorVehicleNoThrough);
            backStreet.setBicycleNoThruTraffic(bicycleNoThrough);
            backStreet.setWalkNoThruTraffic(walkNoThrough);
        }
    }

    private void applyFactors(HashSet<Edge> seenEdges, Edge e) {
        if (!(e instanceof StreetEdge)) {
            return;
        }
        StreetEdge pse = (StreetEdge)e;
        if (!seenEdges.contains(e)) {
            seenEdges.add(e);
            pse.setBicycleSafetyFactor(pse.getBicycleSafetyFactor() / this.bestBikeSafety);
            pse.setWalkSafetyFactor(pse.getWalkSafetyFactor() / this.bestWalkSafety);
        }
    }
}

