/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.graph_builder.module.osm;

import gnu.trove.list.TLongList;
import gnu.trove.map.TLongObjectMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import org.locationtech.jts.algorithm.Orientation;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Polygon;
import org.opentripplanner.framework.geometry.CoordinateArrayListSequence;
import org.opentripplanner.framework.geometry.GeometryUtils;
import org.opentripplanner.osm.model.OsmNode;

class Ring {
    private final LinearRing shell;
    private final List<Ring> holes = new ArrayList<Ring>();
    public List<OsmNode> nodes;
    public Polygon jtsPolygon;

    public Ring(List<OsmNode> osmNodes) {
        ArrayList<Coordinate> vertices = new ArrayList<Coordinate>();
        this.nodes = osmNodes;
        for (OsmNode node : osmNodes) {
            Coordinate point = new Coordinate(node.lon, node.lat);
            vertices.add(point);
        }
        if (Orientation.isCCW((CoordinateSequence)new CoordinateArrayListSequence(vertices))) {
            this.nodes = new ArrayList<OsmNode>(this.nodes);
            Collections.reverse(this.nodes);
            Collections.reverse(vertices);
        }
        GeometryFactory factory = GeometryUtils.getGeometryFactory();
        try {
            this.shell = factory.createLinearRing(vertices.toArray(new Coordinate[0]));
        }
        catch (IllegalArgumentException e) {
            throw new RingConstructionException();
        }
        this.jtsPolygon = this.calculateJtsPolygon();
    }

    public Ring(TLongList osmNodes, TLongObjectMap<OsmNode> _nodes) {
        this(LongStream.of(osmNodes.toArray()).mapToObj(arg_0 -> _nodes.get(arg_0)).collect(Collectors.toCollection(ArrayList::new)));
    }

    public List<Ring> getHoles() {
        return this.holes;
    }

    public void addHole(Ring hole) {
        this.holes.add(hole);
        this.jtsPolygon = this.calculateJtsPolygon();
    }

    boolean isNodeConvex(int i) {
        int n = this.nodes.size() - 1;
        OsmNode cur = this.nodes.get(i);
        OsmNode prev = this.nodes.get((i + n - 1) % n);
        OsmNode next = this.nodes.get((i + 1) % n);
        return (cur.lon - prev.lon) * (next.lat - cur.lat) - (cur.lat - prev.lat) * (next.lon - cur.lon) > 1.0E-11;
    }

    private Polygon calculateJtsPolygon() {
        GeometryFactory factory = GeometryUtils.getGeometryFactory();
        ArrayList<Polygon> polygonHoles = new ArrayList<Polygon>();
        for (Ring ring : this.holes) {
            Polygon polygon = factory.createPolygon(ring.shell, new LinearRing[0]);
            Iterator it = polygonHoles.iterator();
            while (it.hasNext()) {
                Polygon otherHole = (Polygon)it.next();
                if (!otherHole.relate((Geometry)polygon, "F***1****")) continue;
                polygon = (Polygon)polygon.union((Geometry)otherHole);
                it.remove();
            }
            polygonHoles.add(polygon);
        }
        ArrayList<LinearRing> lrholelist = new ArrayList<LinearRing>(polygonHoles.size());
        for (Polygon hole : polygonHoles) {
            Geometry boundary = hole.getBoundary();
            if (boundary instanceof LinearRing) {
                lrholelist.add((LinearRing)boundary);
                continue;
            }
            LinearRing line = hole.getExteriorRing();
            LinearRing ring = factory.createLinearRing(line.getCoordinates());
            lrholelist.add(ring);
        }
        LinearRing[] linearRingArray = lrholelist.toArray(new LinearRing[0]);
        return factory.createPolygon(this.shell, linearRingArray);
    }

    public static class RingConstructionException
    extends RuntimeException {
    }
}

