/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.graph_builder.module.osm;

import ch.poole.openinghoursparser.OpeningHoursParseException;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.OptionalInt;
import java.util.Set;
import java.util.function.BiFunction;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.opentripplanner.framework.geometry.WgsCoordinate;
import org.opentripplanner.framework.i18n.I18NString;
import org.opentripplanner.framework.i18n.LocalizedStringFormat;
import org.opentripplanner.framework.i18n.NonLocalizedString;
import org.opentripplanner.graph_builder.issue.api.DataImportIssueStore;
import org.opentripplanner.graph_builder.issues.InvalidVehicleParkingCapacity;
import org.opentripplanner.graph_builder.issues.ParkAndRideUnlinked;
import org.opentripplanner.graph_builder.module.osm.OsmArea;
import org.opentripplanner.graph_builder.module.osm.OsmAreaGroup;
import org.opentripplanner.graph_builder.module.osm.Ring;
import org.opentripplanner.graph_builder.module.osm.VertexAndName;
import org.opentripplanner.model.calendar.openinghours.OHCalendar;
import org.opentripplanner.osm.OsmOpeningHoursParser;
import org.opentripplanner.osm.model.OsmEntity;
import org.opentripplanner.osm.model.OsmNode;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.service.vehicleparking.model.VehicleParking;
import org.opentripplanner.service.vehicleparking.model.VehicleParkingHelper;
import org.opentripplanner.service.vehicleparking.model.VehicleParkingSpaces;
import org.opentripplanner.street.model.edge.Edge;
import org.opentripplanner.street.model.edge.StreetEdge;
import org.opentripplanner.street.model.edge.VehicleParkingEdge;
import org.opentripplanner.street.model.vertex.IntersectionVertex;
import org.opentripplanner.street.model.vertex.VehicleParkingEntranceVertex;
import org.opentripplanner.street.model.vertex.VertexFactory;
import org.opentripplanner.street.search.TraverseMode;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ParkingProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(ParkingProcessor.class);
    private static final String VEHICLE_PARKING_OSM_FEED_ID = "OSM";
    private final DataImportIssueStore issueStore;
    private final OsmOpeningHoursParser osmOpeningHoursParser;
    private final BiFunction<OsmNode, OsmEntity, IntersectionVertex> getVertexForOsmNode;
    private final VertexFactory vertexFactory;
    private final VehicleParkingHelper vehicleParkingHelper;

    public ParkingProcessor(Graph graph, DataImportIssueStore issueStore, BiFunction<OsmNode, OsmEntity, IntersectionVertex> getVertexForOsmNode) {
        this.issueStore = issueStore;
        this.getVertexForOsmNode = getVertexForOsmNode;
        this.osmOpeningHoursParser = new OsmOpeningHoursParser(graph.getOpeningHoursCalendarService(), issueStore);
        this.vertexFactory = new VertexFactory(graph);
        this.vehicleParkingHelper = new VehicleParkingHelper(graph);
    }

    public List<VehicleParking> buildParkAndRideNodes(Collection<OsmNode> nodes, boolean isCarParkAndRide) {
        LOG.info("Processing {} P+R nodes.", (Object)(isCarParkAndRide ? "car" : "bike"));
        int n = 0;
        ArrayList<VehicleParking> vehicleParkingToAdd = new ArrayList<VehicleParking>();
        for (OsmNode node : nodes) {
            ++n;
            I18NString creativeName = this.nameParkAndRideEntity(node);
            VehicleParking.VehicleParkingEntranceCreator entrance = builder -> builder.entranceId(new FeedScopedId(VEHICLE_PARKING_OSM_FEED_ID, String.format("%s/%s/entrance", node.getClass().getSimpleName(), node.getId()))).name(creativeName).coordinate(new WgsCoordinate(node.getCoordinate())).walkAccessible(true).carAccessible(isCarParkAndRide);
            VehicleParking vehicleParking = this.createVehicleParkingObjectFromOsmEntity(isCarParkAndRide, node.getCoordinate(), node, creativeName, List.of(entrance));
            vehicleParkingToAdd.add(vehicleParking);
            VehicleParkingEntranceVertex parkVertex = this.vertexFactory.vehicleParkingEntrance(vehicleParking);
            VehicleParkingEdge.createVehicleParkingEdge(parkVertex);
        }
        LOG.info("Created {} {} P+R nodes.", (Object)n, (Object)(isCarParkAndRide ? "car" : "bike"));
        return vehicleParkingToAdd;
    }

    public Collection<VehicleParking> buildBikeParkAndRideAreas(List<OsmAreaGroup> areaGroups) {
        return this.buildParkAndRideAreasForGroups(areaGroups, false);
    }

    public Collection<VehicleParking> buildParkAndRideAreas(List<OsmAreaGroup> areaGroups) {
        return this.buildParkAndRideAreasForGroups(areaGroups, true);
    }

    private List<VehicleParking> buildParkAndRideAreasForGroups(List<OsmAreaGroup> areaGroups, boolean isCarParkAndRide) {
        ArrayList<VehicleParking> vehicleParkingToAdd = new ArrayList<VehicleParking>();
        for (OsmAreaGroup group : areaGroups) {
            VehicleParking vehicleParking = this.buildParkAndRideAreasForGroup(group, isCarParkAndRide);
            if (vehicleParking == null) continue;
            vehicleParkingToAdd.add(vehicleParking);
        }
        return vehicleParkingToAdd;
    }

    private OHCalendar parseOpeningHours(OsmEntity entity) {
        String openingHoursTag = entity.getTag("opening_hours");
        if (openingHoursTag != null) {
            ZoneId zoneId = entity.getOsmProvider().getZoneId();
            long id = entity.getId();
            String link = entity.url();
            try {
                return this.osmOpeningHoursParser.parseOpeningHours(openingHoursTag, String.valueOf(id), link, zoneId);
            }
            catch (OpeningHoursParseException e) {
                this.issueStore.add("OsmOpeningHoursUnparsed", "OSM object with id '%s' (%s) has an invalid opening_hours value, it will always be open", id, link);
            }
        }
        return null;
    }

    private List<VertexAndName> processVehicleParkingArea(OsmArea area, Envelope envelope) {
        return area.outermostRings.stream().flatMap(ring -> this.processVehicleParkingArea((Ring)ring, area.parent, envelope).stream()).toList();
    }

    private List<VertexAndName> processVehicleParkingArea(Ring ring, OsmEntity entity, Envelope envelope) {
        ArrayList<VertexAndName> accessVertices = new ArrayList<VertexAndName>();
        for (OsmNode node : ring.nodes) {
            envelope.expandToInclude(new Coordinate(node.lon, node.lat));
            IntersectionVertex accessVertex = this.getVertexForOsmNode.apply(node, entity);
            if (accessVertex.getIncoming().isEmpty() || accessVertex.getOutgoing().isEmpty()) continue;
            accessVertices.add(new VertexAndName(node.getAssumedName(), accessVertex));
        }
        accessVertices.addAll(ring.getHoles().stream().flatMap(innerRing -> this.processVehicleParkingArea((Ring)innerRing, entity, envelope).stream()).toList());
        return accessVertices;
    }

    private VehicleParking buildParkAndRideAreasForGroup(OsmAreaGroup group, boolean isCarParkAndRide) {
        List<VehicleParking.VehicleParkingEntranceCreator> entrances;
        Envelope envelope = new Envelope();
        HashSet<VertexAndName> accessVertices = new HashSet<VertexAndName>();
        OsmEntity entity = null;
        for (OsmArea area : group.areas) {
            entity = area.parent;
            List<VertexAndName> areaAccessVertices = this.processVehicleParkingArea(area, envelope);
            accessVertices.addAll(areaAccessVertices);
        }
        if (entity == null) {
            return null;
        }
        I18NString creativeName = this.nameParkAndRideEntity(entity);
        boolean walkAccessibleIn = false;
        boolean carAccessibleIn = false;
        boolean walkAccessibleOut = false;
        boolean carAccessibleOut = false;
        for (VertexAndName access : accessVertices) {
            StreetEdge streetEdge;
            IntersectionVertex accessVertex = access.vertex();
            for (Edge incoming : accessVertex.getIncoming()) {
                if (!(incoming instanceof StreetEdge)) continue;
                streetEdge = (StreetEdge)incoming;
                if (streetEdge.canTraverse(TraverseMode.WALK)) {
                    walkAccessibleIn = true;
                }
                if (!streetEdge.canTraverse(TraverseMode.CAR)) continue;
                carAccessibleIn = true;
            }
            for (Edge outgoing : accessVertex.getOutgoing()) {
                if (!(outgoing instanceof StreetEdge)) continue;
                streetEdge = (StreetEdge)outgoing;
                if (streetEdge.canTraverse(TraverseMode.WALK)) {
                    walkAccessibleOut = true;
                }
                if (!streetEdge.canTraverse(TraverseMode.CAR)) continue;
                carAccessibleOut = true;
            }
        }
        if (walkAccessibleIn != walkAccessibleOut) {
            LOG.error("P+R walk IN/OUT accessibility mismatch! Please have a look as this should not happen.");
        }
        if (isCarParkAndRide) {
            if (!(walkAccessibleOut && carAccessibleIn && walkAccessibleIn && carAccessibleOut)) {
                this.issueStore.add(new ParkAndRideUnlinked(creativeName.toString(), entity));
            }
        } else if (!walkAccessibleOut || !walkAccessibleIn) {
            this.issueStore.add(new ParkAndRideUnlinked(creativeName.toString(), entity));
        }
        if ((entrances = this.createParkingEntrancesFromAccessVertices(accessVertices, creativeName, entity)).isEmpty()) {
            entrances = this.createArtificialEntrances(group, creativeName, entity, isCarParkAndRide);
        }
        VehicleParking vehicleParking = this.createVehicleParkingObjectFromOsmEntity(isCarParkAndRide, envelope.centre(), entity, creativeName, entrances);
        this.vehicleParkingHelper.linkVehicleParkingToGraph(vehicleParking);
        return vehicleParking;
    }

    private List<VehicleParking.VehicleParkingEntranceCreator> createArtificialEntrances(OsmAreaGroup group, I18NString vehicleParkingName, OsmEntity entity, boolean isCarPark) {
        LOG.debug("Creating an artificial entrance for {} as it's not linked to the street network", (Object)entity.url());
        return List.of(builder -> builder.entranceId(new FeedScopedId(VEHICLE_PARKING_OSM_FEED_ID, String.format("%s/%d/centroid", entity.getClass().getSimpleName(), entity.getId()))).name(vehicleParkingName).coordinate(new WgsCoordinate(group.union.getInteriorPoint())).vertex(null).walkAccessible(true).carAccessible(isCarPark));
    }

    VehicleParking createVehicleParkingObjectFromOsmEntity(boolean isCarParkAndRide, Coordinate coordinate, OsmEntity entity, I18NString creativeName, List<VehicleParking.VehicleParkingEntranceCreator> entrances) {
        OptionalInt wheelchairAccessibleCarCapacity;
        OptionalInt bicycleCapacity;
        OptionalInt carCapacity;
        if (isCarParkAndRide) {
            carCapacity = this.parseCapacity(entity);
            bicycleCapacity = this.parseCapacity(entity, "capacity:bike");
            wheelchairAccessibleCarCapacity = this.parseCapacity(entity, "capacity:disabled");
        } else {
            bicycleCapacity = this.parseCapacity(entity);
            carCapacity = OptionalInt.empty();
            wheelchairAccessibleCarCapacity = OptionalInt.empty();
        }
        VehicleParkingSpaces vehicleParkingSpaces = null;
        if (bicycleCapacity.isPresent() || carCapacity.isPresent() || wheelchairAccessibleCarCapacity.isPresent()) {
            vehicleParkingSpaces = VehicleParkingSpaces.builder().bicycleSpaces(bicycleCapacity.isPresent() ? Integer.valueOf(bicycleCapacity.getAsInt()) : null).carSpaces(carCapacity.isPresent() ? Integer.valueOf(carCapacity.getAsInt()) : null).wheelchairAccessibleCarSpaces(wheelchairAccessibleCarCapacity.isPresent() ? Integer.valueOf(wheelchairAccessibleCarCapacity.getAsInt()) : null).build();
        }
        boolean bicyclePlaces = !isCarParkAndRide || bicycleCapacity.orElse(0) > 0;
        boolean carPlaces = isCarParkAndRide && wheelchairAccessibleCarCapacity.isEmpty() && carCapacity.isEmpty() || carCapacity.orElse(0) > 0;
        boolean wheelchairAccessibleCarPlaces = wheelchairAccessibleCarCapacity.orElse(0) > 0;
        OHCalendar openingHours = this.parseOpeningHours(entity);
        FeedScopedId id = new FeedScopedId(VEHICLE_PARKING_OSM_FEED_ID, String.format("%s/%d", entity.getClass().getSimpleName(), entity.getId()));
        ArrayList<String> tags = new ArrayList<String>();
        tags.add(isCarParkAndRide ? "osm:amenity=parking" : "osm:amenity=bicycle_parking");
        if (entity.isTagTrue("fee")) {
            tags.add("osm:fee");
        }
        if (entity.hasTag("supervised") && !entity.isTagTrue("supervised")) {
            tags.add("osm:supervised");
        }
        if (entity.hasTag("covered") && !entity.isTagFalse("covered")) {
            tags.add("osm:covered");
        }
        if (entity.hasTag("surveillance") && !entity.isTagFalse("surveillance")) {
            tags.add("osm:surveillance");
        }
        return VehicleParking.builder().id(id).name(creativeName).coordinate(new WgsCoordinate(coordinate)).tags(tags).detailsUrl(entity.getTag("website")).openingHoursCalendar(openingHours).bicyclePlaces(bicyclePlaces).carPlaces(carPlaces).wheelchairAccessibleCarPlaces(wheelchairAccessibleCarPlaces).capacity(vehicleParkingSpaces).entrances(entrances).build();
    }

    private I18NString nameParkAndRideEntity(OsmEntity osmEntity) {
        I18NString creativeName = osmEntity.getAssumedName();
        if (creativeName == null) {
            creativeName = osmEntity.getOsmProvider().getWayPropertySet().getCreativeNameForWay(osmEntity);
        }
        if (creativeName == null) {
            creativeName = new NonLocalizedString("Park & Ride (%s/%d)".formatted(osmEntity.getClass().getSimpleName(), osmEntity.getId()));
        }
        return creativeName;
    }

    private OptionalInt parseCapacity(OsmEntity element) {
        return this.parseCapacity(element, "capacity");
    }

    private OptionalInt parseCapacity(OsmEntity element, String capacityTag) {
        return element.parseIntOrBoolean(capacityTag, v -> this.issueStore.add(new InvalidVehicleParkingCapacity(element, (String)v)));
    }

    private List<VehicleParking.VehicleParkingEntranceCreator> createParkingEntrancesFromAccessVertices(Set<VertexAndName> accessVertices, I18NString vehicleParkingName, OsmEntity entity) {
        ArrayList<VehicleParking.VehicleParkingEntranceCreator> entrances = new ArrayList<VehicleParking.VehicleParkingEntranceCreator>();
        List<VertexAndName> sortedAccessVertices = accessVertices.stream().sorted(Comparator.comparing(vn -> vn.vertex().getLabelString())).toList();
        for (VertexAndName access : sortedAccessVertices) {
            I18NString suffix = null;
            if (access.name() != null) {
                suffix = access.name();
            }
            if (suffix == null) {
                suffix = new NonLocalizedString(String.format("#%d", entrances.size() + 1));
            }
            LocalizedStringFormat entranceName = new LocalizedStringFormat("%s (%s)", vehicleParkingName, suffix);
            entrances.add(builder -> builder.entranceId(new FeedScopedId(VEHICLE_PARKING_OSM_FEED_ID, String.format("%s/%d/%s", entity.getClass().getSimpleName(), entity.getId(), access.vertex().getLabel()))).name(entranceName).coordinate(new WgsCoordinate(access.vertex().getCoordinate())).vertex(access.vertex()).walkAccessible(access.vertex().isConnectedToWalkingEdge()).carAccessible(access.vertex().isConnectedToDriveableEdge()));
        }
        return entrances;
    }
}

