/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.graph_builder.module.osm;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import gnu.trove.list.TLongList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.opentripplanner.framework.geometry.GeometryUtils;
import org.opentripplanner.framework.geometry.SphericalDistanceLibrary;
import org.opentripplanner.framework.i18n.I18NString;
import org.opentripplanner.graph_builder.issue.api.DataImportIssueStore;
import org.opentripplanner.graph_builder.model.GraphBuilderModule;
import org.opentripplanner.graph_builder.module.osm.BarrierEdgeBuilder;
import org.opentripplanner.graph_builder.module.osm.ElevatorProcessor;
import org.opentripplanner.graph_builder.module.osm.EscalatorProcessor;
import org.opentripplanner.graph_builder.module.osm.LinearBarrierNodeType;
import org.opentripplanner.graph_builder.module.osm.OsmArea;
import org.opentripplanner.graph_builder.module.osm.OsmAreaGroup;
import org.opentripplanner.graph_builder.module.osm.OsmDatabase;
import org.opentripplanner.graph_builder.module.osm.OsmModuleBuilder;
import org.opentripplanner.graph_builder.module.osm.ParkingProcessor;
import org.opentripplanner.graph_builder.module.osm.SafetyValueNormalizer;
import org.opentripplanner.graph_builder.module.osm.StreetEdgePair;
import org.opentripplanner.graph_builder.module.osm.TurnRestrictionTag;
import org.opentripplanner.graph_builder.module.osm.TurnRestrictionUnifier;
import org.opentripplanner.graph_builder.module.osm.VertexGenerator;
import org.opentripplanner.graph_builder.module.osm.WalkableAreaBuilder;
import org.opentripplanner.graph_builder.module.osm.parameters.OsmProcessingParameters;
import org.opentripplanner.osm.OsmProvider;
import org.opentripplanner.osm.model.OsmEntity;
import org.opentripplanner.osm.model.OsmLevel;
import org.opentripplanner.osm.model.OsmNode;
import org.opentripplanner.osm.model.OsmWay;
import org.opentripplanner.osm.model.TraverseDirection;
import org.opentripplanner.osm.wayproperty.WayPropertiesPair;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.routing.util.ElevationUtils;
import org.opentripplanner.service.osminfo.OsmInfoGraphBuildRepository;
import org.opentripplanner.service.osminfo.model.Platform;
import org.opentripplanner.service.vehicleparking.VehicleParkingRepository;
import org.opentripplanner.service.vehicleparking.model.VehicleParking;
import org.opentripplanner.street.model.StreetLimitationParameters;
import org.opentripplanner.street.model.StreetTraversalPermission;
import org.opentripplanner.street.model.edge.StreetEdge;
import org.opentripplanner.street.model.edge.StreetEdgeBuilder;
import org.opentripplanner.street.model.vertex.BarrierVertex;
import org.opentripplanner.street.model.vertex.IntersectionVertex;
import org.opentripplanner.street.model.vertex.OsmVertex;
import org.opentripplanner.street.model.vertex.Vertex;
import org.opentripplanner.utils.logging.ProgressTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OsmModule
implements GraphBuilderModule {
    private static final Logger LOG = LoggerFactory.getLogger(OsmModule.class);
    private final Map<Vertex, Double> elevationData = new HashMap<Vertex, Double>();
    private final List<OsmProvider> providers;
    private final Graph graph;
    private final OsmInfoGraphBuildRepository osmInfoGraphBuildRepository;
    private final VehicleParkingRepository parkingRepository;
    private final DataImportIssueStore issueStore;
    private final OsmProcessingParameters params;
    private final SafetyValueNormalizer normalizer;
    private final StreetLimitationParameters streetLimitationParameters;

    OsmModule(Collection<OsmProvider> providers, Graph graph, OsmInfoGraphBuildRepository osmInfoGraphBuildRepository, VehicleParkingRepository parkingRepository, DataImportIssueStore issueStore, StreetLimitationParameters streetLimitationParameters, OsmProcessingParameters params) {
        this.providers = List.copyOf(providers);
        this.graph = graph;
        this.osmInfoGraphBuildRepository = osmInfoGraphBuildRepository;
        this.parkingRepository = parkingRepository;
        this.issueStore = issueStore;
        this.params = params;
        this.normalizer = new SafetyValueNormalizer(graph, issueStore);
        this.streetLimitationParameters = Objects.requireNonNull(streetLimitationParameters);
    }

    public static OsmModuleBuilder of(Collection<OsmProvider> providers, Graph graph, OsmInfoGraphBuildRepository osmInfoGraphBuildRepository, VehicleParkingRepository vehicleParkingRepository) {
        return new OsmModuleBuilder(providers, graph, osmInfoGraphBuildRepository, vehicleParkingRepository);
    }

    public static OsmModuleBuilder of(OsmProvider provider, Graph graph, OsmInfoGraphBuildRepository osmInfoGraphBuildRepository, VehicleParkingRepository vehicleParkingRepository) {
        return OsmModule.of(List.of(provider), graph, osmInfoGraphBuildRepository, vehicleParkingRepository);
    }

    @Override
    public void buildGraph() {
        OsmDatabase osmdb = new OsmDatabase(this.issueStore);
        VertexGenerator vertexGenerator = new VertexGenerator(osmdb, this.graph, this.params.boardingAreaRefTags(), this.params.includeOsmSubwayEntrances(), this.issueStore);
        for (OsmProvider provider : this.providers) {
            LOG.info("Gathering OSM from provider: {}", (Object)provider);
            LOG.info("Using OSM way configuration from {}.", (Object)provider.getOsmTagMapper().getClass().getSimpleName());
            provider.readOsm(osmdb);
        }
        osmdb.postLoad();
        LOG.info("Building street graph from OSM");
        this.build(osmdb, vertexGenerator);
        this.graph.hasStreets = true;
        this.streetLimitationParameters.initMaxCarSpeed(this.getMaxCarSpeed());
        this.streetLimitationParameters.initMaxAreaNodes(this.params.maxAreaNodes());
    }

    @Override
    public void checkInputs() {
        for (OsmProvider provider : this.providers) {
            provider.checkInputs();
        }
    }

    public Map<Vertex, Double> elevationDataOutput() {
        return this.elevationData;
    }

    private void build(OsmDatabase osmdb, VertexGenerator vertexGenerator) {
        List<OsmAreaGroup> areaGroups;
        ParkingProcessor parkingProcessor = new ParkingProcessor(this.graph, this.issueStore, (node, way) -> vertexGenerator.getVertexForOsmNode((OsmNode)node, (OsmEntity)way, LinearBarrierNodeType.SPLIT));
        ArrayList<VehicleParking> parkingLots = new ArrayList<VehicleParking>();
        if (this.params.staticParkAndRide()) {
            List<VehicleParking> carParkingNodes = parkingProcessor.buildParkAndRideNodes(osmdb.getCarParkingNodes(), true);
            parkingLots.addAll(carParkingNodes);
        }
        if (this.params.staticBikeParkAndRide()) {
            List<VehicleParking> bikeParkingNodes = parkingProcessor.buildParkAndRideNodes(osmdb.getBikeParkingNodes(), false);
            parkingLots.addAll(bikeParkingNodes);
        }
        for (OsmArea area : Iterables.concat(osmdb.getWalkableAreas(), osmdb.getParkAndRideAreas(), osmdb.getBikeParkingAreas())) {
            this.setWayName(area.parent);
        }
        vertexGenerator.initIntersectionNodes();
        vertexGenerator.initNodesInBarrierWays();
        this.buildBasicGraph(osmdb, vertexGenerator);
        this.buildWalkableAreas(osmdb, vertexGenerator, !this.params.areaVisibility());
        this.buildBarrierEdges(vertexGenerator);
        this.validateBarriers();
        if (this.params.staticParkAndRide()) {
            areaGroups = this.groupAreas(osmdb, osmdb.getParkAndRideAreas(), (Multimap<OsmNode, OsmWay>)ImmutableMultimap.of());
            Collection<VehicleParking> carParkingAreas = parkingProcessor.buildParkAndRideAreas(areaGroups);
            parkingLots.addAll(carParkingAreas);
            LOG.info("Created {} car P+R areas.", (Object)carParkingAreas.size());
        }
        if (this.params.staticBikeParkAndRide()) {
            areaGroups = this.groupAreas(osmdb, osmdb.getBikeParkingAreas(), (Multimap<OsmNode, OsmWay>)ImmutableMultimap.of());
            Collection<VehicleParking> bikeParkingAreas = parkingProcessor.buildBikeParkAndRideAreas(areaGroups);
            parkingLots.addAll(bikeParkingAreas);
            LOG.info("Created {} bike P+R areas", (Object)bikeParkingAreas.size());
        }
        if (!parkingLots.isEmpty()) {
            this.parkingRepository.updateVehicleParking(parkingLots, List.of());
        }
        ElevatorProcessor elevatorProcessor = new ElevatorProcessor(this.issueStore, osmdb, vertexGenerator);
        elevatorProcessor.buildElevatorEdges(this.graph);
        TurnRestrictionUnifier.unifyTurnRestrictions(osmdb, this.issueStore, this.osmInfoGraphBuildRepository);
        this.params.edgeNamer().postprocess();
        this.normalizer.applySafetyFactors();
    }

    private static double getGeometryLengthMeters(Geometry geometry) {
        Coordinate[] coordinates = geometry.getCoordinates();
        double d = 0.0;
        for (int i = 1; i < coordinates.length; ++i) {
            d += SphericalDistanceLibrary.distance(coordinates[i - 1], coordinates[i]);
        }
        return d;
    }

    private List<OsmAreaGroup> groupAreas(OsmDatabase osmdb, Collection<OsmArea> areas, Multimap<OsmNode, OsmWay> barriers) {
        HashMap<OsmArea, OsmLevel> areasLevels = new HashMap<OsmArea, OsmLevel>(areas.size());
        for (OsmArea area : areas) {
            areasLevels.put(area, osmdb.getLevelForWay(area.parent));
        }
        return OsmAreaGroup.groupAreas(areasLevels, barriers);
    }

    private void buildWalkableAreas(OsmDatabase osmdb, VertexGenerator vertexGenerator, boolean skipVisibility) {
        if (skipVisibility) {
            LOG.info("Skipping visibility graph construction for walkable areas and using just area rings for edges.");
        } else {
            LOG.info("Building visibility graphs for walkable areas.");
        }
        List<OsmAreaGroup> areaGroups = this.groupAreas(osmdb, osmdb.getWalkableAreas(), vertexGenerator.nodesInBarrierWays());
        WalkableAreaBuilder walkableAreaBuilder = new WalkableAreaBuilder(this.graph, osmdb, this.osmInfoGraphBuildRepository, vertexGenerator, this.params.edgeNamer(), this.normalizer, this.issueStore, this.params.maxAreaNodes(), this.params.platformEntriesLinking(), this.params.boardingAreaRefTags());
        if (skipVisibility) {
            for (OsmAreaGroup group : areaGroups) {
                walkableAreaBuilder.buildWithoutVisibility(group);
            }
        } else {
            ProgressTracker progress = ProgressTracker.track((String)"Build visibility graph for areas", (int)50, (long)areaGroups.size());
            for (OsmAreaGroup group : areaGroups) {
                walkableAreaBuilder.buildWithVisibility(group);
                progress.step(m -> LOG.info(m));
            }
            LOG.info(progress.completeMessage());
        }
        if (skipVisibility) {
            LOG.info("Done building rings for walkable areas.");
        } else {
            LOG.info("Done building visibility graphs for walkable areas.");
        }
    }

    private void buildBasicGraph(OsmDatabase osmdb, VertexGenerator vertexGenerator) {
        long wayCount = osmdb.getWays().size();
        ProgressTracker progress = ProgressTracker.track((String)"Build street graph", (int)5000, (long)wayCount);
        LOG.info(progress.startMessage());
        EscalatorProcessor escalatorProcessor = new EscalatorProcessor(vertexGenerator.intersectionNodes(), this.issueStore);
        block0: for (OsmWay way : osmdb.getWays()) {
            WayPropertiesPair wayData = way.getOsmProvider().getWayPropertySet().getDataForWay(way);
            this.setWayName(way);
            StreetTraversalPermission forwardPermission = wayData.forward().getPermission();
            StreetTraversalPermission backwardPermission = wayData.backward().getPermission();
            if (!way.isRoutable() || forwardPermission.allowsNothing() && backwardPermission.allowsNothing()) continue;
            ArrayList<Long> nodes = new ArrayList<Long>(way.getNodeRefs().size());
            long last = -1L;
            double lastLat = -1.0;
            double lastLon = -1.0;
            String lastLevel = null;
            for (long nodeId : way.getNodeRefs()) {
                OsmNode node = osmdb.getNode(nodeId);
                if (node == null) continue block0;
                boolean levelsDiffer = false;
                String level = node.getTag("level");
                if (lastLevel == null) {
                    if (level != null) {
                        levelsDiffer = true;
                    }
                } else if (!lastLevel.equals(level)) {
                    levelsDiffer = true;
                }
                if (nodeId != last && (node.lat != lastLat || node.lon != lastLon || levelsDiffer)) {
                    nodes.add(nodeId);
                }
                last = nodeId;
                lastLon = node.lon;
                lastLat = node.lat;
                lastLevel = level;
            }
            IntersectionVertex startEndpoint = null;
            IntersectionVertex endEndpoint = null;
            ArrayList<Coordinate> segmentCoordinates = new ArrayList<Coordinate>();
            Long startNode = null;
            OsmNode osmStartNode = null;
            Optional<Platform> platform = this.getPlatform(osmdb, way);
            for (int i = 0; i < nodes.size() - 1; ++i) {
                Double elevation;
                String ele;
                OsmNode segmentStartOsmNode = osmdb.getNode((Long)nodes.get(i));
                if (segmentStartOsmNode == null) continue;
                Long endNode = (Long)nodes.get(i + 1);
                if (osmStartNode == null) {
                    startNode = (Long)nodes.get(i);
                    osmStartNode = segmentStartOsmNode;
                }
                OsmNode osmEndNode = osmdb.getNode(endNode);
                if (segmentCoordinates.isEmpty()) {
                    segmentCoordinates.add(osmStartNode.getCoordinate());
                }
                if (!(vertexGenerator.intersectionNodes().containsKey(endNode) || i == nodes.size() - 2 || nodes.subList(0, i).contains(nodes.get(i)) || osmEndNode.hasTag("ele") || osmEndNode.isBoardingLocation() || osmEndNode.isBarrier() || vertexGenerator.nodesInBarrierWays().containsKey((Object)osmEndNode))) {
                    segmentCoordinates.add(osmEndNode.getCoordinate());
                    continue;
                }
                segmentCoordinates.add(osmEndNode.getCoordinate());
                LineString geometry = GeometryUtils.getGeometryFactory().createLineString(segmentCoordinates.toArray(new Coordinate[0]));
                segmentCoordinates.clear();
                if (startEndpoint == null) {
                    startEndpoint = vertexGenerator.getVertexForOsmNode(osmStartNode, way, LinearBarrierNodeType.NORMAL);
                    ele = segmentStartOsmNode.getTag("ele");
                    if (ele != null && (elevation = ElevationUtils.parseEleTag(ele)) != null) {
                        this.elevationData.put(startEndpoint, elevation);
                    }
                } else {
                    startEndpoint = endEndpoint;
                }
                endEndpoint = vertexGenerator.getVertexForOsmNode(osmEndNode, way, LinearBarrierNodeType.NORMAL);
                ele = osmEndNode.getTag("ele");
                if (ele != null && (elevation = ElevationUtils.parseEleTag(ele)) != null) {
                    this.elevationData.put(endEndpoint, elevation);
                }
                if (way.isEscalator()) {
                    double length = OsmModule.getGeometryLengthMeters((Geometry)geometry);
                    escalatorProcessor.buildEscalatorEdge(way, length);
                    continue;
                }
                StreetEdgePair streets = this.getEdgesForStreet(startEndpoint, endEndpoint, way, i, forwardPermission, backwardPermission, geometry);
                this.params.edgeNamer().recordEdges(way, streets);
                StreetEdge street = streets.main();
                StreetEdge backStreet = streets.back();
                this.normalizer.applyWayProperties(street, backStreet, wayData.forward(), wayData.backward(), way);
                platform.ifPresent(plat -> {
                    for (StreetEdge s : streets.asIterable()) {
                        this.osmInfoGraphBuildRepository.addPlatform(s, (Platform)plat);
                    }
                });
                this.applyEdgesToTurnRestrictions(osmdb, way, startNode, endNode, street, backStreet);
                startNode = endNode;
                osmStartNode = osmdb.getNode(startNode);
            }
            progress.step(m -> LOG.info(m));
        }
        LOG.info(progress.completeMessage());
    }

    private void buildBarrierEdges(VertexGenerator vertexGenerator) {
        BarrierEdgeBuilder barrierEdgeBuilder = new BarrierEdgeBuilder(this.params.edgeNamer());
        LOG.info("Building edges to pass through linear barriers");
        Map<OsmNode, Map<OsmEntity, OsmVertex>> verticesGroups = vertexGenerator.splitVerticesOnBarriers();
        ProgressTracker progress = ProgressTracker.track((String)"Build edges through barriers", (int)50, (long)verticesGroups.size());
        for (Map.Entry<OsmNode, Map<OsmEntity, OsmVertex>> item : verticesGroups.entrySet()) {
            barrierEdgeBuilder.build(item.getKey(), item.getValue().values(), vertexGenerator.getLinearBarriersAtNode(item.getKey()));
            progress.step(m -> LOG.info(m));
        }
        LOG.info(progress.completeMessage());
        LOG.info("Complete building edges through linear barriers");
    }

    private Optional<Platform> getPlatform(OsmDatabase osmdb, OsmWay way) {
        Set<String> references = way.getMultiTagValues(this.params.boardingAreaRefTags());
        if (way.isBoardingLocation() && !references.isEmpty()) {
            TLongList nodeRefs = way.getNodeRefs();
            int size = nodeRefs.size();
            Coordinate[] nodes = new Coordinate[size];
            for (int i = 0; i < size; ++i) {
                nodes[i] = osmdb.getNode(nodeRefs.get(i)).getCoordinate();
            }
            GeometryFactory geometryFactory = GeometryUtils.getGeometryFactory();
            LineString geometry = geometryFactory.createLineString(nodes);
            return Optional.of(new Platform(this.params.edgeNamer().getNameForWay(way, "platform " + way.getId()), (Geometry)geometry, references));
        }
        return Optional.empty();
    }

    private void validateBarriers() {
        List<BarrierVertex> vertices = this.graph.getVerticesOfType(BarrierVertex.class);
        vertices.forEach(bv -> bv.makeBarrierAtEndReachable());
    }

    private void setWayName(OsmEntity way) {
        I18NString creativeName;
        if (!way.hasTag("name") && (creativeName = way.getOsmProvider().getWayPropertySet().getCreativeNameForWay(way)) != null) {
            way.setCreativeName(creativeName);
        }
    }

    private void applyEdgesToTurnRestrictions(OsmDatabase osmdb, OsmWay way, long startNode, long endNode, @Nullable StreetEdge street, @Nullable StreetEdge backStreet) {
        Collection<TurnRestrictionTag> restrictionTags = osmdb.getFromWayTurnRestrictions(way.getId());
        if (restrictionTags != null) {
            for (TurnRestrictionTag tag : restrictionTags) {
                if (tag.via == startNode) {
                    tag.possibleFrom.add(backStreet);
                    continue;
                }
                if (tag.via != endNode) continue;
                tag.possibleFrom.add(street);
            }
        }
        if ((restrictionTags = osmdb.getToWayTurnRestrictions(way.getId())) != null) {
            for (TurnRestrictionTag tag : restrictionTags) {
                if (tag.via == startNode) {
                    tag.possibleTo.add(street);
                    continue;
                }
                if (tag.via != endNode) continue;
                tag.possibleTo.add(backStreet);
            }
        }
    }

    private StreetEdgePair getEdgesForStreet(IntersectionVertex startEndpoint, IntersectionVertex endEndpoint, OsmWay way, int index, StreetTraversalPermission forwardPermission, StreetTraversalPermission backwardPermission, LineString geometry) {
        if (forwardPermission.allowsNothing() && backwardPermission.allowsNothing()) {
            return new StreetEdgePair(null, null);
        }
        LineString backGeometry = geometry.reverse();
        StreetEdge street = null;
        StreetEdge backStreet = null;
        double length = OsmModule.getGeometryLengthMeters((Geometry)geometry);
        if (forwardPermission.allowsAnything()) {
            street = this.getEdgeForStreet(startEndpoint, endEndpoint, way, index, length, forwardPermission, geometry, TraverseDirection.FORWARD);
        }
        if (backwardPermission.allowsAnything()) {
            backStreet = this.getEdgeForStreet(endEndpoint, startEndpoint, way, index, length, backwardPermission, backGeometry, TraverseDirection.BACKWARD);
        }
        if (street != null && backStreet != null) {
            backStreet.shareData(street);
        }
        return new StreetEdgePair(street, backStreet);
    }

    private StreetEdge getEdgeForStreet(IntersectionVertex startEndpoint, IntersectionVertex endEndpoint, OsmWay way, int index, double length, StreetTraversalPermission permissions, LineString geometry, TraverseDirection direction) {
        if (direction == TraverseDirection.DIRECTIONLESS) {
            throw new IllegalArgumentException("A direction must be specified when getting an edge for a street.");
        }
        Object label = "way " + way.getId() + " from " + index;
        label = ((String)label).intern();
        I18NString name = this.params.edgeNamer().getNameForWay(way, (String)label);
        float carSpeed = way.getOsmProvider().getOsmTagMapper().getCarSpeedForWay(way, direction);
        Object seb = ((StreetEdgeBuilder)((StreetEdgeBuilder)((StreetEdgeBuilder)((StreetEdgeBuilder)((StreetEdgeBuilder)((StreetEdgeBuilder)((StreetEdgeBuilder)((StreetEdgeBuilder)((StreetEdgeBuilder)((StreetEdgeBuilder)((StreetEdgeBuilder)((StreetEdgeBuilder)((StreetEdgeBuilder)new StreetEdgeBuilder().withFromVertex(startEndpoint)).withToVertex(endEndpoint)).withGeometry(geometry)).withName(name)).withMeterLength(length)).withPermission(permissions)).withBack(direction == TraverseDirection.BACKWARD)).withCarSpeed(carSpeed)).withLink(way.isLink())).withRoundabout(way.isRoundabout())).withSlopeOverride(way.getOsmProvider().getWayPropertySet().getSlopeOverride(way))).withStairs(way.isSteps())).withWheelchairAccessible(way.isWheelchairAccessible())).withBogusName(way.hasNoName());
        return ((StreetEdgeBuilder)seb).buildAndConnect();
    }

    private float getMaxCarSpeed() {
        float maxSpeed = 0.0f;
        for (OsmProvider provider : this.providers) {
            Float carSpeed = provider.getOsmTagMapper().getMaxUsedCarSpeed(provider.getWayPropertySet());
            if (!(carSpeed.floatValue() > maxSpeed)) continue;
            maxSpeed = carSpeed.floatValue();
        }
        return maxSpeed;
    }
}

