/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.graph_builder.module.osm;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import gnu.trove.TLongCollection;
import gnu.trove.list.TLongList;
import gnu.trove.map.TLongObjectMap;
import gnu.trove.map.hash.TLongObjectHashMap;
import gnu.trove.set.TLongSet;
import gnu.trove.set.hash.TLongHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.opentripplanner.framework.collection.TroveUtils;
import org.opentripplanner.framework.geometry.GeometryUtils;
import org.opentripplanner.framework.geometry.HashGridSpatialIndex;
import org.opentripplanner.graph_builder.issue.api.DataImportIssueStore;
import org.opentripplanner.graph_builder.issue.api.Issue;
import org.opentripplanner.graph_builder.issues.DisconnectedOsmNode;
import org.opentripplanner.graph_builder.issues.InvalidOsmGeometry;
import org.opentripplanner.graph_builder.issues.LevelAmbiguous;
import org.opentripplanner.graph_builder.issues.TurnRestrictionBad;
import org.opentripplanner.graph_builder.issues.TurnRestrictionException;
import org.opentripplanner.graph_builder.issues.TurnRestrictionUnknown;
import org.opentripplanner.graph_builder.module.osm.OsmArea;
import org.opentripplanner.graph_builder.module.osm.Ring;
import org.opentripplanner.graph_builder.module.osm.TurnRestrictionTag;
import org.opentripplanner.osm.model.OsmEntity;
import org.opentripplanner.osm.model.OsmLevel;
import org.opentripplanner.osm.model.OsmNode;
import org.opentripplanner.osm.model.OsmRelation;
import org.opentripplanner.osm.model.OsmRelationMember;
import org.opentripplanner.osm.model.OsmTag;
import org.opentripplanner.osm.model.OsmWay;
import org.opentripplanner.street.model.StreetTraversalPermission;
import org.opentripplanner.street.model.TurnRestrictionType;
import org.opentripplanner.street.search.TraverseMode;
import org.opentripplanner.street.search.TraverseModeSet;
import org.opentripplanner.utils.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OsmDatabase {
    private static final Logger LOG = LoggerFactory.getLogger(OsmDatabase.class);
    private final DataImportIssueStore issueStore;
    private final TLongObjectMap<OsmNode> nodesById = new TLongObjectHashMap();
    private final TLongObjectMap<OsmNode> bikeParkingNodes = new TLongObjectHashMap();
    private final TLongObjectMap<OsmNode> carParkingNodes = new TLongObjectHashMap();
    private final TLongObjectMap<OsmWay> waysById = new TLongObjectHashMap();
    private final TLongObjectMap<OsmWay> areaWaysById = new TLongObjectHashMap();
    private final TLongObjectMap<OsmRelation> relationsById = new TLongObjectHashMap();
    private final List<OsmArea> walkableAreas = new ArrayList<OsmArea>();
    private final List<OsmArea> parkAndRideAreas = new ArrayList<OsmArea>();
    private final List<OsmArea> bikeParkingAreas = new ArrayList<OsmArea>();
    private final TLongObjectMap<Set<OsmWay>> areasForNode = new TLongObjectHashMap();
    private final List<OsmWay> singleWayAreas = new ArrayList<OsmWay>();
    private final Set<OsmEntity> processedAreas = new HashSet<OsmEntity>();
    private final TLongSet areaWayIds = new TLongHashSet();
    private final TLongSet waysNodeIds = new TLongHashSet();
    private final TLongSet areaNodeIds = new TLongHashSet();
    private final Map<OsmEntity, OsmLevel> wayLevels = new HashMap<OsmEntity, OsmLevel>();
    private final Multimap<Long, TurnRestrictionTag> turnRestrictionsByFromWay = ArrayListMultimap.create();
    private final Multimap<Long, TurnRestrictionTag> turnRestrictionsByToWay = ArrayListMultimap.create();
    private final Multimap<OsmEntity, OsmNode> stopsInAreas = HashMultimap.create();
    private long virtualNodeId = -100000L;
    public boolean noZeroLevels = true;

    public OsmDatabase(DataImportIssueStore issueStore) {
        this.issueStore = issueStore;
    }

    public OsmNode getNode(Long nodeId) {
        return (OsmNode)this.nodesById.get(nodeId.longValue());
    }

    public OsmWay getWay(Long wayId) {
        return (OsmWay)this.waysById.get(wayId.longValue());
    }

    public Collection<OsmWay> getWays() {
        return Collections.unmodifiableCollection(this.waysById.valueCollection());
    }

    public boolean isAreaWay(Long wayId) {
        return this.areaWayIds.contains(wayId.longValue());
    }

    public int nodeCount() {
        return this.nodesById.size();
    }

    public int wayCount() {
        return this.waysById.size();
    }

    public Collection<OsmNode> getBikeParkingNodes() {
        return Collections.unmodifiableCollection(this.bikeParkingNodes.valueCollection());
    }

    public Collection<OsmNode> getCarParkingNodes() {
        return Collections.unmodifiableCollection(this.carParkingNodes.valueCollection());
    }

    public Collection<OsmArea> getWalkableAreas() {
        return Collections.unmodifiableCollection(this.walkableAreas);
    }

    public Collection<OsmArea> getParkAndRideAreas() {
        return Collections.unmodifiableCollection(this.parkAndRideAreas);
    }

    public Collection<OsmArea> getBikeParkingAreas() {
        return Collections.unmodifiableCollection(this.bikeParkingAreas);
    }

    public Collection<Long> getTurnRestrictionWayIds() {
        return Collections.unmodifiableCollection(this.turnRestrictionsByFromWay.keySet());
    }

    public Collection<TurnRestrictionTag> getFromWayTurnRestrictions(Long fromWayId) {
        return this.turnRestrictionsByFromWay.get((Object)fromWayId);
    }

    public Collection<TurnRestrictionTag> getToWayTurnRestrictions(Long toWayId) {
        return this.turnRestrictionsByToWay.get((Object)toWayId);
    }

    public Collection<OsmNode> getStopsInArea(OsmEntity areaParent) {
        return this.stopsInAreas.get((Object)areaParent);
    }

    public OsmLevel getLevelForWay(OsmEntity way) {
        return Objects.requireNonNullElse(this.wayLevels.get(way), OsmLevel.DEFAULT);
    }

    public Set<OsmWay> getAreasForNode(Long nodeId) {
        Set areas = (Set)this.areasForNode.get(nodeId.longValue());
        if (areas == null) {
            return Set.of();
        }
        return areas;
    }

    public boolean isNodeBelongsToWay(Long nodeId) {
        return this.waysNodeIds.contains(nodeId.longValue());
    }

    public void addNode(OsmNode node) {
        if (node.isBikeParking()) {
            this.bikeParkingNodes.put(node.getId(), (Object)node);
        }
        if (node.isParkAndRide()) {
            this.carParkingNodes.put(node.getId(), (Object)node);
        }
        if (!(this.waysNodeIds.contains(node.getId()) || this.areaNodeIds.contains(node.getId()) || node.isBoardingLocation())) {
            return;
        }
        if (this.nodesById.containsKey(node.getId())) {
            return;
        }
        this.nodesById.put(node.getId(), (Object)node);
    }

    public void addWay(OsmWay way) {
        long wayId = way.getId();
        if (this.waysById.containsKey(wayId) || this.areaWaysById.containsKey(wayId)) {
            return;
        }
        if (this.areaWayIds.contains(wayId)) {
            this.areaWaysById.put(wayId, (Object)way);
        }
        if (!way.isRelevantForRouting() && !way.isBarrier()) {
            return;
        }
        this.applyLevelsForWay(way);
        if (way.isRoutableArea()) {
            if (!this.areaWayIds.contains(wayId)) {
                this.singleWayAreas.add(way);
                this.areaWaysById.put(wayId, (Object)way);
                this.areaWayIds.add(wayId);
                way.getNodeRefs().forEach(node -> {
                    TroveUtils.addToMapSet(this.areasForNode, node, way);
                    return true;
                });
            }
            return;
        }
        this.waysById.put(wayId, (Object)way);
    }

    public void addRelation(OsmRelation relation) {
        if (this.relationsById.containsKey(relation.getId())) {
            return;
        }
        if (relation.isMultiPolygon() && (relation.isRoutable() || relation.isParkAndRide()) || relation.isBikeParking()) {
            if (!(relation.isRoutable() || relation.isParkAndRide() || relation.isBikeParking())) {
                return;
            }
            for (OsmRelationMember member : relation.getMembers()) {
                this.areaWayIds.add(member.getRef());
            }
            this.applyLevelsForWay(relation);
        } else if (!(relation.isRestriction() || relation.isRoadRoute() || relation.isMultiPolygon() && relation.isRoutable() || relation.isLevelMap() || relation.isStopArea() || relation.isRoadRoute() || relation.isBicycleRoute())) {
            return;
        }
        this.relationsById.put(relation.getId(), (Object)relation);
    }

    public void doneFirstPhaseRelations() {
    }

    public void doneSecondPhaseWays() {
        this.markNodesForKeeping(this.waysById.valueCollection().stream().filter(OsmWay::isRelevantForRouting).toList(), this.waysNodeIds);
        this.markNodesForKeeping(this.areaWaysById.valueCollection(), this.areaNodeIds);
    }

    public void doneThirdPhaseNodes() {
        this.processMultipolygonRelations();
        this.processSingleWayAreas();
    }

    public void postLoad() {
        this.processRelations();
        this.processUnconnectedAreas();
    }

    private static boolean checkIntersectionDistance(Point p, OsmNode n, double epsilon) {
        return Math.abs(p.getY() - n.lat) < epsilon && Math.abs(p.getX() - n.lon) < epsilon;
    }

    private static boolean checkDistanceWithin(OsmNode a, OsmNode b, double epsilon) {
        return Math.abs(a.lat - b.lat) < epsilon && Math.abs(a.lon - b.lon) < epsilon;
    }

    private void processUnconnectedAreas() {
        LOG.info("Intersecting unconnected areas...");
        HashSet<KeyPair> commonSegments = new HashSet<KeyPair>();
        HashGridSpatialIndex<RingSegment> spndx = new HashGridSpatialIndex<RingSegment>();
        for (OsmArea area : Iterables.concat(this.parkAndRideAreas, this.bikeParkingAreas)) {
            for (Ring ring : area.outermostRings) {
                this.processAreaRingForUnconnectedAreas(commonSegments, spndx, area, ring);
            }
        }
        int nCreatedNodes = 0;
        for (OsmWay way : this.waysById.valueCollection()) {
            OsmLevel wayLevel = this.getLevelForWay(way);
            block3: for (int i = 0; i < way.getNodeRefs().size() - 1; ++i) {
                Envelope env;
                List<RingSegment> ringSegments;
                OsmNode nA = (OsmNode)this.nodesById.get(way.getNodeRefs().get(i));
                OsmNode nB = (OsmNode)this.nodesById.get(way.getNodeRefs().get(i + 1));
                if (nA == null || nB == null || (ringSegments = spndx.query(env = new Envelope(nA.lon, nB.lon, nA.lat, nB.lat))).size() == 0) continue;
                LineString seg = GeometryUtils.makeLineString(nA.lon, nA.lat, nB.lon, nB.lat);
                for (RingSegment ringSegment : ringSegments) {
                    OsmNode splitNode;
                    OsmLevel areaLevel;
                    boolean wayWasSplit = false;
                    if (ringSegment.nA.getId() == nA.getId() || ringSegment.nA.getId() == nB.getId() || ringSegment.nB.getId() == nA.getId() || ringSegment.nB.getId() == nB.getId() || !wayLevel.equals(areaLevel = this.getLevelForWay(ringSegment.area.parent))) continue;
                    LineString seg2 = GeometryUtils.makeLineString(ringSegment.nA.lon, ringSegment.nA.lat, ringSegment.nB.lon, ringSegment.nB.lat);
                    Geometry intersection = seg2.intersection((Geometry)seg);
                    Point p = null;
                    if (intersection.isEmpty()) continue;
                    if (!(intersection instanceof Point)) {
                        LOG.error("Alien intersection type between {} ({}--{}) and {} ({}--{}): {}", new Object[]{way, nA, nB, ringSegment.area.parent, ringSegment.nA, ringSegment.nB, intersection});
                        continue;
                    }
                    p = (Point)intersection;
                    double epsilon = 1.0E-7;
                    if (OsmDatabase.checkIntersectionDistance(p, nA, epsilon)) {
                        splitNode = nA;
                        if (ringSegment.ring.nodes.contains(splitNode)) continue;
                        if (OsmDatabase.checkDistanceWithin(ringSegment.nA, nA, epsilon) || OsmDatabase.checkDistanceWithin(ringSegment.nB, nA, epsilon)) {
                            this.issueStore.add(new DisconnectedOsmNode(nA, way, ringSegment.area.parent));
                        }
                    } else if (OsmDatabase.checkIntersectionDistance(p, nB, epsilon)) {
                        splitNode = nB;
                        if (ringSegment.ring.nodes.contains(splitNode)) continue;
                        if (OsmDatabase.checkDistanceWithin(ringSegment.nA, nB, epsilon) || OsmDatabase.checkDistanceWithin(ringSegment.nB, nB, epsilon)) {
                            this.issueStore.add(new DisconnectedOsmNode(nB, way, ringSegment.area.parent));
                        }
                    } else {
                        if (OsmDatabase.checkIntersectionDistance(p, ringSegment.nA, epsilon)) {
                            if (way.getNodeRefs().contains(ringSegment.nA.getId())) continue;
                            way.addNodeRef(ringSegment.nA.getId(), i + 1);
                            if (OsmDatabase.checkDistanceWithin(ringSegment.nA, nA, epsilon) || OsmDatabase.checkDistanceWithin(ringSegment.nA, nB, epsilon)) {
                                this.issueStore.add(new DisconnectedOsmNode(nB, ringSegment.area.parent, way));
                            }
                            --i;
                            continue block3;
                        }
                        if (OsmDatabase.checkIntersectionDistance(p, ringSegment.nB, epsilon)) {
                            if (way.getNodeRefs().contains(ringSegment.nB.getId())) continue;
                            way.addNodeRef(ringSegment.nB.getId(), i + 1);
                            if (OsmDatabase.checkDistanceWithin(ringSegment.nB, nA, epsilon) || OsmDatabase.checkDistanceWithin(ringSegment.nB, nB, epsilon)) {
                                this.issueStore.add(new DisconnectedOsmNode(ringSegment.nB, ringSegment.area.parent, way));
                            }
                            --i;
                            continue block3;
                        }
                        splitNode = this.createVirtualNode(p.getCoordinate());
                        ++nCreatedNodes;
                        LOG.debug("Adding virtual {}, intersection of {} ({}--{}) and area {} ({}--{}) at {}.", new Object[]{splitNode, way, nA, nB, ringSegment.area.parent, ringSegment.nA, ringSegment.nB, p});
                        way.addNodeRef(splitNode.getId(), i + 1);
                        wayWasSplit = true;
                    }
                    int j = ringSegment.ring.nodes.indexOf(ringSegment.nB);
                    ringSegment.ring.nodes.add(j, splitNode);
                    RingSegment ringSegment2 = new RingSegment();
                    ringSegment2.area = ringSegment.area;
                    ringSegment2.ring = ringSegment.ring;
                    ringSegment2.nA = splitNode;
                    ringSegment2.nB = ringSegment.nB;
                    Envelope env2 = new Envelope(ringSegment2.nA.lon, ringSegment2.nB.lon, ringSegment2.nA.lat, ringSegment2.nB.lat);
                    spndx.insert(env2, (Object)ringSegment2);
                    ringSegment.nB = splitNode;
                    if (!wayWasSplit) continue;
                    --i;
                    continue block3;
                }
            }
        }
        LOG.info("Created {} virtual intersection nodes.", (Object)nCreatedNodes);
    }

    private void processAreaRingForUnconnectedAreas(Set<KeyPair> commonSegments, HashGridSpatialIndex<RingSegment> spndx, OsmArea area, Ring ring) {
        for (int j = 0; j < ring.nodes.size(); ++j) {
            RingSegment ringSegment = new RingSegment();
            ringSegment.area = area;
            ringSegment.ring = ring;
            ringSegment.nA = ring.nodes.get(j);
            ringSegment.nB = ring.nodes.get((j + 1) % ring.nodes.size());
            Envelope env = new Envelope(ringSegment.nA.lon, ringSegment.nB.lon, ringSegment.nA.lat, ringSegment.nB.lat);
            KeyPair key1 = new KeyPair(ringSegment.nA.getId(), ringSegment.nB.getId());
            KeyPair key2 = new KeyPair(ringSegment.nB.getId(), ringSegment.nA.getId());
            if (commonSegments.contains(key1) || commonSegments.contains(key2)) continue;
            spndx.insert(env, (Object)ringSegment);
            commonSegments.add(key1);
            commonSegments.add(key2);
        }
        ring.getHoles().forEach(hole -> this.processAreaRingForUnconnectedAreas(commonSegments, spndx, area, (Ring)hole));
    }

    private OsmNode createVirtualNode(Coordinate c) {
        OsmNode node = new OsmNode();
        node.lon = c.x;
        node.lat = c.y;
        node.setId(this.virtualNodeId);
        --this.virtualNodeId;
        this.waysNodeIds.add(node.getId());
        this.nodesById.put(node.getId(), (Object)node);
        return node;
    }

    private void applyLevelsForWay(OsmEntity way) {
        if (!this.wayLevels.containsKey(way)) {
            String levelName = null;
            OsmLevel level = OsmLevel.DEFAULT;
            if (way.hasTag("level")) {
                levelName = way.getTag("level");
                level = OsmLevel.fromString(levelName, OsmLevel.Source.LEVEL_TAG, this.noZeroLevels, this.issueStore, way);
            } else if (way.hasTag("layer")) {
                levelName = way.getTag("layer");
                level = OsmLevel.fromString(levelName, OsmLevel.Source.LAYER_TAG, this.noZeroLevels, this.issueStore, way);
            }
            if (level == null || !level.reliable) {
                this.issueStore.add(new LevelAmbiguous(levelName, way));
                level = OsmLevel.DEFAULT;
            }
            this.wayLevels.put(way, level);
        }
    }

    private void markNodesForKeeping(Collection<OsmWay> osmWays, TLongSet nodeSet) {
        for (OsmWay way : osmWays) {
            TLongList nodes = way.getNodeRefs();
            if (nodes.size() <= 1) continue;
            nodeSet.addAll((TLongCollection)nodes);
        }
    }

    private void processSingleWayAreas() {
        block3: for (OsmWay way : this.singleWayAreas) {
            if (this.processedAreas.contains(way)) continue;
            for (long nodeRef : way.getNodeRefs()) {
                if (this.nodesById.containsKey(nodeRef)) continue;
                continue block3;
            }
            try {
                this.addArea(new OsmArea(way, List.of(way), Collections.emptyList(), this.nodesById));
                this.waysById.remove(way.getId());
            }
            catch (OsmArea.AreaConstructionException | Ring.RingConstructionException e) {
                this.issueStore.add(new InvalidOsmGeometry(way));
            }
            catch (IllegalArgumentException iae) {
                this.issueStore.add(new InvalidOsmGeometry(way));
            }
            this.processedAreas.add(way);
        }
    }

    private void processMultipolygonRelations() {
        block2: for (OsmRelation relation : this.relationsById.valueCollection()) {
            if (this.processedAreas.contains(relation) || !relation.isMultiPolygon() || !relation.isRoutable() && !relation.isParkAndRide() && !relation.isBikeParking()) continue;
            ArrayList<OsmWay> innerWays = new ArrayList<OsmWay>();
            ArrayList<OsmWay> outerWays = new ArrayList<OsmWay>();
            for (OsmRelationMember member : relation.getMembers()) {
                OsmWay way = (OsmWay)this.areaWaysById.get(member.getRef());
                if (way == null) continue block2;
                for (long nodeId : way.getNodeRefs()) {
                    if (!this.nodesById.containsKey(nodeId)) continue block2;
                    TroveUtils.addToMapSet(this.areasForNode, nodeId, way);
                }
                if (member.hasRoleInner()) {
                    innerWays.add(way);
                    continue;
                }
                if (member.hasRoleOuter()) {
                    outerWays.add(way);
                    continue;
                }
                LOG.warn("Unexpected role '{}' in multipolygon", (Object)member.getRole());
            }
            this.processedAreas.add(relation);
            try {
                this.addArea(new OsmArea(relation, outerWays, innerWays, this.nodesById));
            }
            catch (OsmArea.AreaConstructionException | Ring.RingConstructionException e) {
                this.issueStore.add(new InvalidOsmGeometry(relation));
            }
        }
    }

    private void addArea(OsmArea area) {
        StreetTraversalPermission permissions = area.getPermission();
        if (area.parent.isRoutable() && permissions != StreetTraversalPermission.NONE) {
            this.walkableAreas.add(area);
        }
        if (area.parent.isParkAndRide()) {
            this.parkAndRideAreas.add(area);
        }
        if (area.parent.isBikeParking()) {
            this.bikeParkingAreas.add(area);
        }
    }

    private void processRelations() {
        LOG.debug("Processing relations...");
        for (OsmRelation relation : this.relationsById.valueCollection()) {
            if (relation.isRestriction()) {
                this.processRestriction(relation);
                continue;
            }
            if (relation.isLevelMap()) {
                this.processLevelMap(relation);
                continue;
            }
            if (relation.isRoute()) {
                this.processRoute(relation);
                continue;
            }
            if (!relation.isPublicTransport()) continue;
            this.processPublicTransportStopArea(relation);
        }
    }

    private void processBicycleRoute(OsmRelation relation) {
        if (relation.isBicycleRoute()) {
            String network = relation.getTagOpt("network").orElse("lcn");
            this.setNetworkForAllMembers(relation, network);
        }
    }

    private void setNetworkForAllMembers(OsmRelation relation, String key) {
        relation.getMembers().forEach(member -> {
            boolean isOsmWay = member.hasTypeWay();
            OsmWay way = (OsmWay)this.waysById.get(member.getRef());
            if (way != null && isOsmWay && !way.hasTag(key)) {
                way.addTag(key, "yes");
            }
        });
    }

    private void processRestriction(OsmRelation relation) {
        TurnRestrictionTag tag;
        long from = -1L;
        long to = -1L;
        long via = -1L;
        for (OsmRelationMember member : relation.getMembers()) {
            String[] role = member.getRole();
            if (role.equals("from")) {
                from = member.getRef();
                continue;
            }
            if (role.equals("to")) {
                to = member.getRef();
                continue;
            }
            if (!role.equals("via")) continue;
            via = member.getRef();
        }
        if (from == -1L || to == -1L || via == -1L) {
            this.issueStore.add(new TurnRestrictionBad(relation.getId(), "One of from|via|to edges are empty in relation"));
            return;
        }
        TraverseModeSet modes = new TraverseModeSet(TraverseMode.BICYCLE, TraverseMode.CAR);
        String exceptModes = relation.getTag("except");
        if (exceptModes != null) {
            for (String m : exceptModes.split(";")) {
                if (m.equals("motorcar")) {
                    modes.setCar(false);
                    continue;
                }
                if (!m.equals("bicycle")) continue;
                modes.setBicycle(false);
                this.issueStore.add(new TurnRestrictionException(via, from));
            }
        }
        if (relation.isTag("restriction", "no_right_turn")) {
            tag = new TurnRestrictionTag(via, TurnRestrictionType.NO_TURN, TurnRestrictionTag.Direction.RIGHT, relation.getId());
        } else if (relation.isTag("restriction", "no_left_turn")) {
            tag = new TurnRestrictionTag(via, TurnRestrictionType.NO_TURN, TurnRestrictionTag.Direction.LEFT, relation.getId());
        } else if (relation.isTag("restriction", "no_straight_on")) {
            tag = new TurnRestrictionTag(via, TurnRestrictionType.NO_TURN, TurnRestrictionTag.Direction.STRAIGHT, relation.getId());
        } else if (relation.isTag("restriction", "no_u_turn")) {
            tag = new TurnRestrictionTag(via, TurnRestrictionType.NO_TURN, TurnRestrictionTag.Direction.U, relation.getId());
        } else if (relation.isTag("restriction", "only_straight_on")) {
            tag = new TurnRestrictionTag(via, TurnRestrictionType.ONLY_TURN, TurnRestrictionTag.Direction.STRAIGHT, relation.getId());
        } else if (relation.isTag("restriction", "only_right_turn")) {
            tag = new TurnRestrictionTag(via, TurnRestrictionType.ONLY_TURN, TurnRestrictionTag.Direction.RIGHT, relation.getId());
        } else if (relation.isTag("restriction", "only_left_turn")) {
            tag = new TurnRestrictionTag(via, TurnRestrictionType.ONLY_TURN, TurnRestrictionTag.Direction.LEFT, relation.getId());
        } else if (relation.isTag("restriction", "only_u_turn")) {
            tag = new TurnRestrictionTag(via, TurnRestrictionType.ONLY_TURN, TurnRestrictionTag.Direction.U, relation.getId());
        } else {
            this.issueStore.add(new TurnRestrictionUnknown(relation, relation.getTag("restriction")));
            return;
        }
        tag.modes = modes.clone();
        this.turnRestrictionsByFromWay.put((Object)from, (Object)tag);
        this.turnRestrictionsByToWay.put((Object)to, (Object)tag);
    }

    private void processLevelMap(OsmRelation relation) {
        String levelsTag = relation.getTag("levels");
        if (!StringUtils.hasValue((String)levelsTag)) {
            this.issueStore.add(Issue.issue("InvalidLevelMap", "Could not parse level map for osm relation %d as it was malformed. Skipped.", relation.getId()));
            return;
        }
        Map<String, OsmLevel> levels = OsmLevel.mapFromSpecList(levelsTag, OsmLevel.Source.LEVEL_MAP, true, this.issueStore, relation);
        for (OsmRelationMember member : relation.getMembers()) {
            String role;
            OsmWay way;
            if (!member.hasTypeWay() || !this.waysById.containsKey(member.getRef()) || (way = (OsmWay)this.waysById.get(member.getRef())) == null || relation.hasTag("role:" + (role = member.getRole()))) continue;
            if (levels.containsKey(role)) {
                this.wayLevels.put(way, levels.get(role));
                continue;
            }
            LOG.warn("{} has undefined level {}", (Object)member.getRef(), (Object)role);
        }
    }

    private void processRoute(OsmRelation relation) {
        for (OsmRelationMember member : relation.getMembers()) {
            OsmEntity way;
            if (!member.hasTypeWay() || !this.waysById.containsKey(member.getRef()) || (way = (OsmEntity)this.waysById.get(member.getRef())) == null) continue;
            if (relation.hasTag("name")) {
                if (way.hasTag("otp:route_name")) {
                    way.addTag("otp:route_name", this.addUniqueName(way.getTag("otp:route_name"), relation.getTag("name")));
                } else {
                    way.addTag(new OsmTag("otp:route_name", relation.getTag("name")));
                }
            }
            if (!relation.hasTag("ref")) continue;
            if (way.hasTag("otp:route_ref")) {
                way.addTag("otp:route_ref", this.addUniqueName(way.getTag("otp:route_ref"), relation.getTag("ref")));
                continue;
            }
            way.addTag(new OsmTag("otp:route_ref", relation.getTag("ref")));
        }
        this.processBicycleRoute(relation);
    }

    private void processPublicTransportStopArea(OsmRelation relation) {
        HashSet<OsmEntity> platformAreas = new HashSet<OsmEntity>();
        HashSet<OsmNode> platformNodes = new HashSet<OsmNode>();
        block5: for (OsmRelationMember member : relation.getMembers()) {
            switch (member.getType()) {
                case NODE: {
                    OsmNode node2 = (OsmNode)this.nodesById.get(member.getRef());
                    if (node2 == null || !node2.isEntrance() && !node2.isBoardingLocation()) continue block5;
                    platformNodes.add(node2);
                    break;
                }
                case WAY: {
                    if (!member.hasRolePlatform() || !this.areaWaysById.containsKey(member.getRef())) break;
                    platformAreas.add((OsmEntity)this.areaWaysById.get(member.getRef()));
                    break;
                }
                case RELATION: {
                    if (!member.hasRolePlatform() || !this.relationsById.containsKey(member.getRef())) break;
                    platformAreas.add((OsmEntity)this.relationsById.get(member.getRef()));
                }
            }
        }
        for (OsmEntity area : platformAreas) {
            if (area == null) {
                throw new RuntimeException("Could not process public transport relation '%s' (%s)".formatted(relation, relation.url()));
            }
            Set<String> filterLevels = area.getLevels();
            platformNodes.stream().filter(node -> node.getLevels().containsAll(filterLevels)).forEach(node -> this.stopsInAreas.put((Object)area, node));
        }
    }

    private String addUniqueName(String routes, String name) {
        String[] names;
        for (String existing : names = routes.split(", ")) {
            if (!existing.equals(name)) continue;
            return routes;
        }
        return routes + ", " + name;
    }

    static class RingSegment {
        OsmArea area;
        Ring ring;
        OsmNode nA;
        OsmNode nB;

        RingSegment() {
        }
    }

    private record KeyPair(long id0, long id1) {
    }
}

