/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.graph_builder.module.osm;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import gnu.trove.list.TLongList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygon;
import org.opentripplanner.framework.geometry.GeometryUtils;
import org.opentripplanner.graph_builder.module.osm.DisjointSet;
import org.opentripplanner.graph_builder.module.osm.OsmArea;
import org.opentripplanner.graph_builder.module.osm.OsmNodePair;
import org.opentripplanner.graph_builder.module.osm.Ring;
import org.opentripplanner.osm.model.OsmEntity;
import org.opentripplanner.osm.model.OsmLevel;
import org.opentripplanner.osm.model.OsmNode;
import org.opentripplanner.osm.model.OsmWay;
import org.opentripplanner.street.model.StreetTraversalPermission;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OsmAreaGroup {
    private static final Logger LOG = LoggerFactory.getLogger(OsmAreaGroup.class);
    Collection<OsmArea> areas;
    List<Ring> outermostRings = new ArrayList<Ring>();
    public final Geometry union;

    public OsmAreaGroup(Collection<OsmArea> areas) {
        this.areas = areas;
        ArrayList<Polygon> allRings = new ArrayList<Polygon>();
        HashMap<Coordinate, OsmNode> nodeMap = new HashMap<Coordinate, OsmNode>();
        for (OsmArea area : areas) {
            for (Ring ring : area.outermostRings) {
                allRings.add(ring.jtsPolygon);
                for (OsmNode node : ring.nodes) {
                    nodeMap.put(new Coordinate(node.lon, node.lat), node);
                }
                for (Ring inner : ring.getHoles()) {
                    for (OsmNode node : inner.nodes) {
                        nodeMap.put(new Coordinate(node.lon, node.lat), node);
                    }
                }
            }
        }
        GeometryFactory geometryFactory = GeometryUtils.getGeometryFactory();
        MultiPolygon allPolygons = geometryFactory.createMultiPolygon(allRings.toArray(new Polygon[0]));
        this.union = allPolygons.union();
        Object object = this.union;
        if (object instanceof GeometryCollection) {
            GeometryCollection coll;
            GeometryCollection mp = coll = (GeometryCollection)object;
            for (int i = 0; i < mp.getNumGeometries(); ++i) {
                Geometry geom = mp.getGeometryN(i);
                if (geom instanceof Polygon) {
                    Polygon polygon = (Polygon)geom;
                    this.outermostRings.add(this.toRing(polygon, nodeMap));
                    continue;
                }
                LOG.warn("Unexpected non-polygon when merging areas: {}", (Object)geom);
            }
        } else {
            object = this.union;
            if (object instanceof Polygon) {
                Polygon polygon = (Polygon)object;
                this.outermostRings.add(this.toRing(polygon, nodeMap));
            } else {
                LOG.warn("Unexpected non-polygon when merging areas: {}", (Object)this.union);
            }
        }
    }

    private static Collection<OsmWay> getBarriers(Multimap<OsmNode, OsmWay> barriers, OsmNode first, OsmNode second) {
        return CollectionUtils.intersection((Iterable)barriers.get((Object)first), (Iterable)barriers.get((Object)second)).stream().filter(barrier -> {
            TLongList nodeRefs = Objects.requireNonNull(barrier).getNodeRefs();
            for (int i = 0; i < nodeRefs.size() - 1; ++i) {
                if (nodeRefs.get(i) == first.getId() && nodeRefs.get(i + 1) == second.getId()) {
                    return true;
                }
                if (nodeRefs.get(i) != second.getId() || nodeRefs.get(i + 1) != first.getId()) continue;
                return true;
            }
            return false;
        }).toList();
    }

    public static List<OsmAreaGroup> groupAreas(Map<OsmArea, OsmLevel> areasLevels, Multimap<OsmNode, OsmWay> barriers) {
        DisjointSet<OsmArea> groups = new DisjointSet<OsmArea>();
        HashMultimap areasForNodePair = HashMultimap.create();
        HashMap<OsmArea, Map<OsmWay, Set<OsmNodePair>>> barriersForArea = new HashMap<OsmArea, Map<OsmWay, Set<OsmNodePair>>>();
        for (OsmArea area : areasLevels.keySet()) {
            for (Ring ring : area.outermostRings) {
                for (Ring ring2 : ring.getHoles()) {
                    OsmAreaGroup.processRing(area, ring2, barriers, (Multimap<OsmNodePair, OsmArea>)areasForNodePair, barriersForArea);
                }
                OsmAreaGroup.processRing(area, ring, barriers, (Multimap<OsmNodePair, OsmArea>)areasForNodePair, barriersForArea);
            }
        }
        for (OsmNodePair nodePair : areasForNodePair.keySet()) {
            for (OsmArea area1 : areasForNodePair.get((Object)nodePair)) {
                OsmLevel level1 = areasLevels.get(area1);
                for (OsmArea area2 : areasForNodePair.get((Object)nodePair)) {
                    boolean shareBarrier;
                    OsmLevel level2 = areasLevels.get(area2);
                    boolean onSameLevel = level1 == null && level2 == null || level1 != null && level1.equals(level2);
                    StreetTraversalPermission crossablePermissions = Objects.requireNonNull(area1).getPermission().intersection(Objects.requireNonNull(area2).getPermission());
                    List<OsmWay> sharedBarriers = CollectionUtils.intersection(barriersForArea.getOrDefault(area1, Map.of()).keySet(), barriersForArea.getOrDefault(area2, Map.of()).keySet()).stream().filter(barrier -> {
                        boolean blocksTraversal = crossablePermissions.intersection(Objects.requireNonNull(barrier).getPermission()) != crossablePermissions;
                        boolean sharesEdgeWithBothAreas = !CollectionUtils.intersection((Iterable)((Iterable)((Map)barriersForArea.get(area1)).get(barrier)), (Iterable)((Iterable)((Map)barriersForArea.get(area2)).get(barrier))).isEmpty();
                        return blocksTraversal && sharesEdgeWithBothAreas;
                    }).toList();
                    boolean bl = shareBarrier = area1 != area2 && !sharedBarriers.isEmpty();
                    if (!onSameLevel || shareBarrier) continue;
                    groups.union(area1, area2);
                }
            }
        }
        ArrayList<OsmAreaGroup> out = new ArrayList<OsmAreaGroup>();
        for (Set<OsmArea> set : groups.sets()) {
            try {
                out.add(new OsmAreaGroup(set));
            }
            catch (Ring.RingConstructionException e) {
                for (OsmArea osmArea : set) {
                    LOG.debug("Failed to create merged area for " + String.valueOf(osmArea) + ".  This area might not be at fault; it might be one of the other areas in this list.");
                    out.add(new OsmAreaGroup(Arrays.asList(osmArea)));
                }
            }
        }
        return out;
    }

    private static void processRing(OsmArea area, Ring ring, Multimap<OsmNode, OsmWay> barriers, Multimap<OsmNodePair, OsmArea> areasForNodePair, Map<OsmArea, Map<OsmWay, Set<OsmNodePair>>> barriersForArea) {
        List<OsmNode> nodes = ring.nodes;
        for (int i = 0; i < nodes.size() - 1; ++i) {
            OsmNode node = nodes.get(i);
            OsmNode nextNode = nodes.get(i + 1);
            OsmNodePair pair = new OsmNodePair(node, nextNode);
            areasForNodePair.put((Object)pair, (Object)area);
            Collection<OsmWay> sharedBarriers = OsmAreaGroup.getBarriers(barriers, node, nextNode);
            for (OsmWay barrier : sharedBarriers) {
                Map<OsmWay, Set<OsmNodePair>> barrierMap;
                if (!barriersForArea.containsKey(area)) {
                    barriersForArea.put(area, new HashMap());
                }
                if (!(barrierMap = barriersForArea.get(area)).containsKey(barrier)) {
                    barrierMap.put(barrier, new HashSet());
                }
                Set<OsmNodePair> nodesOnBarrier = barrierMap.get(barrier);
                nodesOnBarrier.add(pair);
            }
        }
    }

    public OsmEntity getSomeOsmObject() {
        return this.areas.iterator().next().parent;
    }

    public boolean isSimpleAreaGroup() {
        return this.areas.size() == 1 && this.outermostRings.size() == 1;
    }

    private Ring toRing(Polygon polygon, HashMap<Coordinate, OsmNode> nodeMap) {
        ArrayList<OsmNode> shell = new ArrayList<OsmNode>();
        for (Coordinate coord : polygon.getExteriorRing().getCoordinates()) {
            OsmNode node = nodeMap.get(coord);
            if (node == null) {
                throw new Ring.RingConstructionException();
            }
            shell.add(node);
        }
        Ring ring = new Ring(shell);
        for (int i = 0; i < polygon.getNumInteriorRing(); ++i) {
            LinearRing interior = polygon.getInteriorRingN(i);
            ArrayList<OsmNode> hole = new ArrayList<OsmNode>();
            for (Coordinate coord : interior.getCoordinates()) {
                OsmNode node = nodeMap.get(coord);
                if (node == null) {
                    throw new Ring.RingConstructionException();
                }
                hole.add(node);
            }
            ring.addHole(new Ring(hole));
        }
        return ring;
    }
}

