/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.graph_builder.module.osm;

import com.google.common.collect.ArrayListMultimap;
import gnu.trove.TLongCollection;
import gnu.trove.list.TLongList;
import gnu.trove.list.array.TLongArrayList;
import gnu.trove.map.TLongObjectMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.TopologyException;
import org.locationtech.jts.operation.valid.IsValidOp;
import org.locationtech.jts.operation.valid.TopologyValidationError;
import org.opentripplanner.framework.geometry.GeometryUtils;
import org.opentripplanner.graph_builder.module.osm.Ring;
import org.opentripplanner.osm.model.OsmEntity;
import org.opentripplanner.osm.model.OsmNode;
import org.opentripplanner.osm.model.OsmWay;
import org.opentripplanner.street.model.StreetTraversalPermission;

class OsmArea {
    final List<Ring> outermostRings;
    final OsmEntity parent;
    public MultiPolygon jtsMultiPolygon;

    OsmArea(OsmEntity parent, List<OsmWay> outerRingWays, List<OsmWay> innerRingWays, TLongObjectMap<OsmNode> nodes) {
        this.parent = parent;
        List<TLongList> innerRingNodes = this.constructRings(innerRingWays);
        List<TLongList> outerRingNodes = this.constructRings(outerRingWays);
        if (innerRingNodes == null || outerRingNodes == null) {
            throw new AreaConstructionException("innerRing or outerRing nodes are null");
        }
        ArrayList<TLongList> allRings = new ArrayList<TLongList>(innerRingNodes);
        allRings.addAll(outerRingNodes);
        ArrayList<Ring> innerRings = new ArrayList<Ring>();
        ArrayList<Ring> outerRings = new ArrayList<Ring>();
        for (TLongList tLongList : innerRingNodes) {
            innerRings.add(new Ring(tLongList, nodes));
        }
        for (TLongList tLongList : outerRingNodes) {
            outerRings.add(new Ring(tLongList, nodes));
        }
        ArrayList<Ring> outermostRings = new ArrayList<Ring>();
        try {
            block4: for (Ring outer : outerRings) {
                for (Ring possibleContainer : outerRings) {
                    if (outer == possibleContainer || !outer.jtsPolygon.within((Geometry)possibleContainer.jtsPolygon)) continue;
                    continue block4;
                }
                outermostRings.add(outer);
                for (Ring possibleHole : innerRings) {
                    if (!possibleHole.jtsPolygon.within((Geometry)outer.jtsPolygon)) continue;
                    outer.addHole(possibleHole);
                }
            }
        }
        catch (TopologyException topologyException) {
            throw new AreaConstructionException(topologyException.getMessage());
        }
        this.outermostRings = List.copyOf(outermostRings);
        this.jtsMultiPolygon = this.calculateJTSMultiPolygon();
    }

    public List<TLongList> constructRings(List<OsmWay> ways) {
        if (ways.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<TLongList> closedRings = new ArrayList<TLongList>();
        ArrayListMultimap waysByEndpoint = ArrayListMultimap.create();
        for (OsmWay osmWay : ways) {
            long end;
            TLongList refs = osmWay.getNodeRefs();
            long start = refs.get(0);
            if (start == (end = refs.get(refs.size() - 1))) {
                TLongArrayList ring = new TLongArrayList((TLongCollection)refs);
                closedRings.add((TLongList)ring);
                continue;
            }
            waysByEndpoint.put((Object)start, (Object)osmWay);
            waysByEndpoint.put((Object)end, (Object)osmWay);
        }
        TLongArrayList endpointsToRemove = new TLongArrayList();
        for (Long endpoint2 : waysByEndpoint.keySet()) {
            List list = waysByEndpoint.get((Object)endpoint2);
            if (list.size() % 2 != 1) continue;
            endpointsToRemove.add(endpoint2.longValue());
        }
        endpointsToRemove.forEach(endpoint -> {
            waysByEndpoint.removeAll((Object)endpoint);
            return true;
        });
        TLongArrayList tLongArrayList = new TLongArrayList();
        if (waysByEndpoint.size() == 0) {
            return closedRings;
        }
        long firstEndpoint = 0L;
        long otherEndpoint = 0L;
        OsmWay firstWay = null;
        Iterator iterator = waysByEndpoint.keySet().iterator();
        if (iterator.hasNext()) {
            Long endpoint3 = (Long)iterator.next();
            List list = waysByEndpoint.get((Object)endpoint3);
            firstWay = (OsmWay)list.get(0);
            TLongList nodeRefs = firstWay.getNodeRefs();
            tLongArrayList.addAll((TLongCollection)nodeRefs);
            firstEndpoint = nodeRefs.get(0);
            otherEndpoint = nodeRefs.get(nodeRefs.size() - 1);
        }
        waysByEndpoint.get((Object)firstEndpoint).remove(firstWay);
        waysByEndpoint.get((Object)otherEndpoint).remove(firstWay);
        if (this.constructRingsRecursive((ArrayListMultimap<Long, OsmWay>)waysByEndpoint, (TLongList)tLongArrayList, closedRings, firstEndpoint)) {
            return closedRings;
        }
        return null;
    }

    public Point findInteriorPoint() {
        Point centroid = this.jtsMultiPolygon.getCentroid();
        if (this.jtsMultiPolygon.intersects((Geometry)centroid)) {
            return centroid;
        }
        return this.jtsMultiPolygon.getInteriorPoint();
    }

    public StreetTraversalPermission getPermission() {
        return this.parent.getPermission();
    }

    private MultiPolygon calculateJTSMultiPolygon() {
        ArrayList<Polygon> polygons = new ArrayList<Polygon>();
        for (Ring ring : this.outermostRings) {
            polygons.add(ring.jtsPolygon);
        }
        MultiPolygon jtsMultiPolygon = GeometryUtils.getGeometryFactory().createMultiPolygon(polygons.toArray(new Polygon[0]));
        IsValidOp validOp = new IsValidOp((Geometry)jtsMultiPolygon);
        if (!validOp.isValid()) {
            TopologyValidationError validationError = validOp.getValidationError();
            throw new AreaConstructionException("%s at %s".formatted(validationError.getMessage(), validationError.getCoordinate()));
        }
        return jtsMultiPolygon;
    }

    private boolean constructRingsRecursive(ArrayListMultimap<Long, OsmWay> waysByEndpoint, TLongList ring, List<TLongList> closedRings, long endpoint) {
        ArrayList ways = new ArrayList(waysByEndpoint.get((Object)endpoint));
        for (OsmWay way : ways) {
            long newFirstEndpoint;
            TLongList nodeRefs = way.getNodeRefs();
            long firstEndpoint = nodeRefs.get(0);
            long otherEndpoint = nodeRefs.get(nodeRefs.size() - 1);
            waysByEndpoint.remove((Object)firstEndpoint, (Object)way);
            waysByEndpoint.remove((Object)otherEndpoint, (Object)way);
            TLongArrayList newRing = new TLongArrayList(ring.size() + nodeRefs.size());
            if (firstEndpoint == endpoint) {
                for (int j = nodeRefs.size() - 1; j >= 1; --j) {
                    newRing.add(nodeRefs.get(j));
                }
                newRing.addAll((TLongCollection)ring);
                newFirstEndpoint = otherEndpoint;
            } else {
                newRing.addAll((TLongCollection)nodeRefs.subList(0, nodeRefs.size() - 1));
                newRing.addAll((TLongCollection)ring);
                newFirstEndpoint = firstEndpoint;
            }
            if (newRing.get(newRing.size() - 1) == newRing.get(0)) {
                closedRings.add((TLongList)newRing);
                if (waysByEndpoint.size() == 0) {
                    return true;
                }
                newRing = new TLongArrayList();
                OsmWay firstWay = null;
                Iterator iterator = waysByEndpoint.keySet().iterator();
                if (iterator.hasNext()) {
                    Long entry = (Long)iterator.next();
                    List list = waysByEndpoint.get((Object)entry);
                    firstWay = (OsmWay)list.get(0);
                    nodeRefs = firstWay.getNodeRefs();
                    newRing.addAll((TLongCollection)nodeRefs);
                    firstEndpoint = nodeRefs.get(0);
                    otherEndpoint = nodeRefs.get(nodeRefs.size() - 1);
                }
                waysByEndpoint.remove((Object)firstEndpoint, firstWay);
                waysByEndpoint.remove((Object)otherEndpoint, firstWay);
                if (this.constructRingsRecursive(waysByEndpoint, (TLongList)newRing, closedRings, firstEndpoint)) {
                    return true;
                }
                waysByEndpoint.remove((Object)firstEndpoint, (Object)firstWay);
                waysByEndpoint.remove((Object)otherEndpoint, (Object)firstWay);
            } else if (waysByEndpoint.get((Object)newFirstEndpoint) != null && this.constructRingsRecursive(waysByEndpoint, (TLongList)newRing, closedRings, newFirstEndpoint)) {
                return true;
            }
            if (firstEndpoint == endpoint) {
                waysByEndpoint.put((Object)otherEndpoint, (Object)way);
                continue;
            }
            waysByEndpoint.put((Object)firstEndpoint, (Object)way);
        }
        return false;
    }

    public static class AreaConstructionException
    extends RuntimeException {
        private final String message;

        public AreaConstructionException(String message) {
            this.message = message;
        }

        @Override
        public String getMessage() {
            return this.message;
        }
    }
}

