/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.graph_builder.module.osm;

import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.opentripplanner.graph_builder.issue.api.DataImportIssueStore;
import org.opentripplanner.graph_builder.issue.api.Issue;
import org.opentripplanner.osm.model.OsmWay;
import org.opentripplanner.street.model.edge.EscalatorEdge;
import org.opentripplanner.street.model.vertex.IntersectionVertex;

class EscalatorProcessor {
    private final Map<Long, IntersectionVertex> intersectionNodes;
    private final DataImportIssueStore issueStore;
    private static final double SLOW_ESCALATOR_ERROR_CUTOFF = 0.05;
    private static final double FAST_ESCALATOR_ERROR_CUTOFF = 5.0;

    public EscalatorProcessor(Map<Long, IntersectionVertex> intersectionNodes, DataImportIssueStore issueStore) {
        this.intersectionNodes = intersectionNodes;
        this.issueStore = issueStore;
    }

    public void buildEscalatorEdge(OsmWay escalatorWay, double length) {
        double speed;
        List<Long> nodes = Arrays.stream(escalatorWay.getNodeRefs().toArray()).filter(nodeRef -> this.intersectionNodes.containsKey(nodeRef) && this.intersectionNodes.get(nodeRef) != null).boxed().toList();
        Optional<Duration> duration = escalatorWay.getDuration(v -> this.issueStore.add(Issue.issue("InvalidDuration", "Duration for osm node {} is not a valid duration: '{}'; the value is ignored.", escalatorWay.url(), v)));
        if (duration.isPresent() && ((speed = length / (double)duration.get().toSeconds()) < 0.05 || speed > 5.0)) {
            duration = Optional.empty();
            this.issueStore.add(Issue.issue("InvalidDuration", "Duration for osm node {} makes implied speed {} be outside acceptable range.", escalatorWay.url(), speed));
        }
        for (int i = 0; i < nodes.size() - 1; ++i) {
            if (escalatorWay.isForwardEscalator()) {
                EscalatorEdge.createEscalatorEdge(this.intersectionNodes.get(nodes.get(i)), this.intersectionNodes.get(nodes.get(i + 1)), length, duration.orElse(null));
                continue;
            }
            if (escalatorWay.isBackwardEscalator()) {
                EscalatorEdge.createEscalatorEdge(this.intersectionNodes.get(nodes.get(i + 1)), this.intersectionNodes.get(nodes.get(i)), length, duration.orElse(null));
                continue;
            }
            EscalatorEdge.createEscalatorEdge(this.intersectionNodes.get(nodes.get(i)), this.intersectionNodes.get(nodes.get(i + 1)), length, duration.orElse(null));
            EscalatorEdge.createEscalatorEdge(this.intersectionNodes.get(nodes.get(i + 1)), this.intersectionNodes.get(nodes.get(i)), length, duration.orElse(null));
        }
    }
}

