/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.graph_builder.module.osm;

import gnu.trove.list.TLongList;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.opentripplanner.framework.i18n.NonLocalizedString;
import org.opentripplanner.graph_builder.issue.api.DataImportIssueStore;
import org.opentripplanner.graph_builder.issue.api.Issue;
import org.opentripplanner.graph_builder.module.osm.OsmDatabase;
import org.opentripplanner.graph_builder.module.osm.VertexGenerator;
import org.opentripplanner.osm.model.OsmLevel;
import org.opentripplanner.osm.model.OsmNode;
import org.opentripplanner.osm.model.OsmWay;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.street.model.StreetTraversalPermission;
import org.opentripplanner.street.model.edge.ElevatorAlightEdge;
import org.opentripplanner.street.model.edge.ElevatorBoardEdge;
import org.opentripplanner.street.model.edge.ElevatorHopEdge;
import org.opentripplanner.street.model.vertex.ElevatorVertex;
import org.opentripplanner.street.model.vertex.IntersectionVertex;
import org.opentripplanner.street.model.vertex.OsmVertex;
import org.opentripplanner.street.model.vertex.Vertex;
import org.opentripplanner.street.model.vertex.VertexFactory;
import org.opentripplanner.transit.model.basic.Accessibility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ElevatorProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(ElevatorProcessor.class);
    private final OsmDatabase osmdb;
    private final VertexGenerator vertexGenerator;
    private final Consumer<String> osmEntityDurationIssueConsumer;

    public ElevatorProcessor(DataImportIssueStore issueStore, OsmDatabase osmdb, VertexGenerator vertexGenerator) {
        this.osmdb = osmdb;
        this.vertexGenerator = vertexGenerator;
        this.osmEntityDurationIssueConsumer = v -> issueStore.add(Issue.issue("InvalidDuration", "Duration for osm node {} is not a valid duration: '{}'; the value is ignored.", v));
    }

    public void buildElevatorEdges(Graph graph) {
        for (Long nodeId : this.vertexGenerator.multiLevelNodes().keySet()) {
            OsmNode node = this.osmdb.getNode(nodeId);
            Map<OsmLevel, OsmVertex> vertices = this.vertexGenerator.multiLevelNodes().get(nodeId);
            Object[] levels = vertices.keySet().toArray(new OsmLevel[0]);
            Arrays.sort(levels);
            ArrayList<Vertex> onboardVertices = new ArrayList<Vertex>();
            for (Object level : levels) {
                OsmVertex sourceVertex = vertices.get(level);
                String levelName = ((OsmLevel)level).longName;
                ElevatorProcessor.createElevatorVertices(graph, onboardVertices, sourceVertex, sourceVertex.getLabelString(), levelName);
            }
            long travelTime = node.getDuration(this.osmEntityDurationIssueConsumer).map(Duration::toSeconds).orElse(-1L);
            Accessibility wheelchair = node.explicitWheelchairAccessibility();
            ElevatorProcessor.createElevatorHopEdges(onboardVertices, wheelchair, !node.isBicycleDenied(), levels.length, (int)travelTime);
        }
        Iterator elevators = this.osmdb.getWays().stream().filter(this::isElevatorWay).iterator();
        while (elevators.hasNext()) {
            OsmWay elevatorWay = (OsmWay)elevators.next();
            List<Long> nodes = Arrays.stream(elevatorWay.getNodeRefs().toArray()).filter(nodeRef -> this.vertexGenerator.intersectionNodes().containsKey(nodeRef) && this.vertexGenerator.intersectionNodes().get(nodeRef) != null).boxed().toList();
            ArrayList<Vertex> onboardVertices = new ArrayList<Vertex>();
            for (int i = 0; i < nodes.size(); ++i) {
                Long node = nodes.get(i);
                IntersectionVertex sourceVertex = this.vertexGenerator.intersectionNodes().get(node);
                String sourceVertexLabel = sourceVertex.getLabelString();
                String levelName = elevatorWay.getId() + " / " + i;
                ElevatorProcessor.createElevatorVertices(graph, onboardVertices, sourceVertex, elevatorWay.getId() + "_" + sourceVertexLabel, levelName);
            }
            long travelTime = elevatorWay.getDuration(this.osmEntityDurationIssueConsumer).map(Duration::toSeconds).orElse(-1L);
            int levels = nodes.size();
            Accessibility wheelchair = elevatorWay.explicitWheelchairAccessibility();
            ElevatorProcessor.createElevatorHopEdges(onboardVertices, wheelchair, !elevatorWay.isBicycleDenied(), levels, (int)travelTime);
            LOG.debug("Created elevatorHopEdges for way {}", (Object)elevatorWay.getId());
        }
    }

    private static void createElevatorVertices(Graph graph, ArrayList<Vertex> onboardVertices, IntersectionVertex sourceVertex, String label, String levelName) {
        VertexFactory factory = new VertexFactory(graph);
        ElevatorVertex onboardVertex = factory.elevator(sourceVertex, label, levelName);
        ElevatorBoardEdge.createElevatorBoardEdge(sourceVertex, onboardVertex);
        ElevatorAlightEdge.createElevatorAlightEdge(onboardVertex, sourceVertex, new NonLocalizedString(levelName));
        onboardVertices.add(onboardVertex);
    }

    private static void createElevatorHopEdges(ArrayList<Vertex> onboardVertices, Accessibility wheelchair, boolean bicycleAllowed, int levels, int travelTime) {
        int vSize = onboardVertices.size() - 1;
        for (int i = 0; i < vSize; ++i) {
            StreetTraversalPermission permission;
            Vertex from = onboardVertices.get(i);
            Vertex to = onboardVertices.get(i + 1);
            StreetTraversalPermission streetTraversalPermission = permission = bicycleAllowed ? StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE : StreetTraversalPermission.PEDESTRIAN;
            if (travelTime > -1 && levels > 0) {
                ElevatorHopEdge.bidirectional(from, to, permission, wheelchair, levels, travelTime);
                continue;
            }
            ElevatorHopEdge.bidirectional(from, to, permission, wheelchair);
        }
    }

    private boolean isElevatorWay(OsmWay way) {
        if (!way.isElevator()) {
            return false;
        }
        if (this.osmdb.isAreaWay(way.getId())) {
            return false;
        }
        TLongList nodeRefs = way.getNodeRefs();
        return nodeRefs.get(0) != nodeRefs.get(nodeRefs.size() - 1);
    }
}

