/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.graph_builder.module.osm;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.opentripplanner.framework.geometry.GeometryUtils;
import org.opentripplanner.framework.i18n.I18NString;
import org.opentripplanner.graph_builder.services.osm.EdgeNamer;
import org.opentripplanner.osm.model.OsmNode;
import org.opentripplanner.osm.model.OsmWay;
import org.opentripplanner.routing.linking.VertexLinker;
import org.opentripplanner.street.model.StreetTraversalPermission;
import org.opentripplanner.street.model.edge.StreetEdgeBuilder;
import org.opentripplanner.street.model.vertex.OsmVertex;
import org.opentripplanner.street.model.vertex.Vertex;
import org.opentripplanner.street.search.TraverseMode;

public class BarrierEdgeBuilder {
    private final EdgeNamer edgeNamer;

    public BarrierEdgeBuilder(EdgeNamer edgeNamer) {
        this.edgeNamer = edgeNamer;
    }

    public void build(OsmNode node, Collection<OsmVertex> vertices, Collection<OsmWay> barriers) {
        StreetTraversalPermission permission = StreetTraversalPermission.ALL;
        boolean wheelchairAccessible = true;
        I18NString name = null;
        if (!node.hasTag("barrier")) {
            for (OsmWay barrier : barriers) {
                permission = permission.intersection(barrier.overridePermissions(StreetTraversalPermission.ALL));
                boolean bl = wheelchairAccessible = wheelchairAccessible && barrier.isWheelchairAccessible();
                if (barrier.hasNoName()) continue;
                name = this.edgeNamer.getNameForWay(barrier, ("barrier " + barrier.getId()).intern());
            }
        }
        if ((permission = node.overridePermissions(permission)).allowsNothing()) {
            return;
        }
        OsmVertex[] vs = vertices.toArray(new OsmVertex[0]);
        Integer[] inDegrees = (Integer[])Arrays.stream(vs).map(Vertex::getDegreeIn).toArray(Integer[]::new);
        Integer[] outDegrees = (Integer[])Arrays.stream(vs).map(Vertex::getDegreeOut).toArray(Integer[]::new);
        for (int i = 0; i < vs.length; ++i) {
            for (int j = 0; j < vs.length; ++j) {
                if (i == j) continue;
                OsmVertex from = vs[i];
                OsmVertex to = vs[j];
                if (inDegrees[i] <= 0 || outDegrees[j] <= 0) continue;
                Object seb = ((StreetEdgeBuilder)((StreetEdgeBuilder)((StreetEdgeBuilder)((StreetEdgeBuilder)((StreetEdgeBuilder)((StreetEdgeBuilder)new StreetEdgeBuilder().withFromVertex(from)).withToVertex(to)).withGeometry(GeometryUtils.makeLineString(List.of(from.getCoordinate(), to.getCoordinate())))).withName(name == null ? I18NString.of("barrier crossing at node " + vs[i].nodeId) : name)).withPermission(permission)).withWheelchairAccessible(wheelchairAccessible)).withBogusName(name == null);
                for (TraverseMode mode : VertexLinker.getNoThruModes(from.getIncoming())) {
                    ((StreetEdgeBuilder)seb).withNoThruTrafficTraverseMode(mode);
                }
                for (TraverseMode mode : VertexLinker.getNoThruModes(to.getOutgoing())) {
                    ((StreetEdgeBuilder)seb).withNoThruTrafficTraverseMode(mode);
                }
                ((StreetEdgeBuilder)seb).buildAndConnect();
            }
        }
    }
}

