/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.graph_builder.module.ned;

import it.geosolutions.jaiext.range.NoDataContainer;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.geotools.api.coverage.CannotEvaluateException;
import org.geotools.api.coverage.PointOutsideCoverageException;
import org.geotools.api.coverage.SampleDimension;
import org.geotools.api.coverage.grid.GridCoverage;
import org.geotools.api.coverage.grid.GridGeometry;
import org.geotools.api.geometry.Bounds;
import org.geotools.api.geometry.Position;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.util.Record;
import org.geotools.api.util.RecordType;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.util.CoverageUtilities;

public class NoDataGridCoverage
implements GridCoverage {
    private final GridCoverage2D gridCoverage;
    private final NoDataContainer noData;

    private NoDataGridCoverage(GridCoverage2D gridCoverage) {
        this.gridCoverage = gridCoverage;
        this.noData = CoverageUtilities.getNoDataProperty((GridCoverage2D)gridCoverage);
    }

    public boolean isDataEditable() {
        return this.gridCoverage.isDataEditable();
    }

    public GridGeometry getGridGeometry() {
        return this.gridCoverage.getGridGeometry();
    }

    public int[] getOptimalDataBlockSizes() {
        return this.gridCoverage.getOptimalDataBlockSizes();
    }

    public int getNumOverviews() {
        return this.gridCoverage.getNumOverviews();
    }

    public GridGeometry getOverviewGridGeometry(int index) throws IndexOutOfBoundsException {
        return this.gridCoverage.getOverviewGridGeometry(index);
    }

    public GridCoverage getOverview(int index) throws IndexOutOfBoundsException {
        return this.gridCoverage.getOverview(index);
    }

    public List<GridCoverage> getSources() {
        return this.gridCoverage.getSources();
    }

    public RenderedImage getRenderedImage() {
        return this.gridCoverage.getRenderedImage();
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.gridCoverage.getCoordinateReferenceSystem();
    }

    public Bounds getEnvelope() {
        return this.gridCoverage.getEnvelope();
    }

    public RecordType getRangeType() {
        return this.gridCoverage.getRangeType();
    }

    public Set<Record> evaluate(Position directPosition, Collection<String> collection) throws CannotEvaluateException {
        throw new UnsupportedOperationException("This methods is unsupported");
    }

    public Object evaluate(Position directPosition) throws CannotEvaluateException {
        throw new UnsupportedOperationException("This methods is unsupported");
    }

    public boolean[] evaluate(Position directPosition, boolean[] booleans) throws CannotEvaluateException, ArrayIndexOutOfBoundsException {
        throw new UnsupportedOperationException("This methods is unsupported");
    }

    public byte[] evaluate(Position directPosition, byte[] bytes) throws CannotEvaluateException, ArrayIndexOutOfBoundsException {
        throw new UnsupportedOperationException("This methods is unsupported");
    }

    public int[] evaluate(Position directPosition, int[] ints) throws CannotEvaluateException, ArrayIndexOutOfBoundsException {
        throw new UnsupportedOperationException("This methods is unsupported");
    }

    public float[] evaluate(Position directPosition, float[] floats) throws CannotEvaluateException, ArrayIndexOutOfBoundsException {
        throw new UnsupportedOperationException("This methods is unsupported");
    }

    public double[] evaluate(Position directPosition, double[] dest) throws CannotEvaluateException, ArrayIndexOutOfBoundsException {
        this.gridCoverage.evaluate(directPosition, dest);
        if (this.noData != null && this.noData.getAsSingleValue() == dest[0]) {
            throw new PointOutsideCoverageException("Value is NO_DATA.");
        }
        return dest;
    }

    public int getNumSampleDimensions() {
        return this.gridCoverage.getNumSampleDimensions();
    }

    public SampleDimension getSampleDimension(int index) throws IndexOutOfBoundsException {
        return this.gridCoverage.getSampleDimension(index);
    }

    public RenderableImage getRenderableImage(int xAxis, int yAxis) throws UnsupportedOperationException, IndexOutOfBoundsException {
        return this.gridCoverage.getRenderableImage(xAxis, yAxis);
    }

    static GridCoverage create(GridCoverage2D gridCoverage2D) {
        return new NoDataGridCoverage(gridCoverage2D);
    }
}

