/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.graph_builder.module.ned;

import java.awt.RenderingHints;
import java.io.File;
import java.io.IOException;
import javax.media.jai.Interpolation;
import javax.media.jai.InterpolationBilinear;
import org.geotools.api.coverage.grid.GridCoverage;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.Interpolator2D;
import org.geotools.gce.geotiff.GeoTiffFormat;
import org.geotools.gce.geotiff.GeoTiffReader;
import org.geotools.util.factory.Hints;
import org.opentripplanner.datastore.api.DataSource;
import org.opentripplanner.datastore.api.FileType;
import org.opentripplanner.datastore.file.FileDataSource;
import org.opentripplanner.graph_builder.module.ned.NoDataGridCoverage;
import org.opentripplanner.graph_builder.services.ned.ElevationGridCoverageFactory;
import org.opentripplanner.routing.graph.Graph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeotiffGridCoverageFactoryImpl
implements ElevationGridCoverageFactory {
    private static final Logger LOG = LoggerFactory.getLogger(GeotiffGridCoverageFactoryImpl.class);
    private final DataSource input;
    private final double elevationUnitMultiplier;
    private GridCoverage2D coverage;

    public GeotiffGridCoverageFactoryImpl(DataSource dataSource, double elevationUnitMultiplier) {
        this.input = dataSource;
        this.elevationUnitMultiplier = elevationUnitMultiplier;
    }

    public GeotiffGridCoverageFactoryImpl(File path) {
        this(new FileDataSource(path, FileType.DEM), 1.0);
    }

    public GridCoverage getGridCoverage() {
        return NoDataGridCoverage.create(Interpolator2D.create((GridCoverage2D)this.getUninterpolatedGridCoverage(), (Interpolation)new InterpolationBilinear()));
    }

    @Override
    public double elevationUnitMultiplier() {
        return this.elevationUnitMultiplier;
    }

    @Override
    public void checkInputs() {
        if (!this.input.exists()) {
            throw new RuntimeException("Can't read elevation path: " + this.input.path());
        }
    }

    @Override
    public void fetchData(Graph graph) {
    }

    public GridCoverage2D getUninterpolatedGridCoverage() {
        if (this.coverage == null) {
            try {
                Hints forceLongLat = new Hints((RenderingHints.Key)Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER, (Object)Boolean.TRUE);
                GeoTiffFormat format = new GeoTiffFormat();
                GeoTiffReader reader = format.getReader(this.getSource(), forceLongLat);
                this.coverage = reader.read(null);
                LOG.debug("Elevation model CRS is: {}", (Object)this.coverage.getCoordinateReferenceSystem2D());
            }
            catch (IOException e) {
                throw new RuntimeException("Error getting coverage automatically. ", e);
            }
        }
        return this.coverage;
    }

    private Object getSource() {
        return this.input.asInputStream();
    }
}

