/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.graph_builder.module.nearbystops;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Sets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opentripplanner.astar.model.ShortestPathTree;
import org.opentripplanner.astar.strategy.DurationSkipEdgeStrategy;
import org.opentripplanner.astar.strategy.MaxCountTerminationStrategy;
import org.opentripplanner.ext.dataoverlay.routing.DataOverlayContext;
import org.opentripplanner.framework.application.OTPFeature;
import org.opentripplanner.framework.application.OTPRequestTimeoutException;
import org.opentripplanner.graph_builder.module.nearbystops.NearbyStopFinder;
import org.opentripplanner.routing.api.request.RouteRequest;
import org.opentripplanner.routing.api.request.StreetMode;
import org.opentripplanner.routing.api.request.request.StreetRequest;
import org.opentripplanner.routing.graphfinder.NearbyStop;
import org.opentripplanner.street.model.edge.Edge;
import org.opentripplanner.street.model.edge.StreetEdge;
import org.opentripplanner.street.model.vertex.StreetVertex;
import org.opentripplanner.street.model.vertex.TemporaryStreetLocation;
import org.opentripplanner.street.model.vertex.TransitStopVertex;
import org.opentripplanner.street.model.vertex.Vertex;
import org.opentripplanner.street.search.StreetSearchBuilder;
import org.opentripplanner.street.search.TraverseMode;
import org.opentripplanner.street.search.state.State;
import org.opentripplanner.street.search.strategy.DominanceFunctions;
import org.opentripplanner.transit.model.site.AreaStop;

public class StreetNearbyStopFinder
implements NearbyStopFinder {
    private final Duration durationLimit;
    private final int maxStopCount;
    private final DataOverlayContext dataOverlayContext;
    private final Set<Vertex> ignoreVertices;

    public StreetNearbyStopFinder(Duration durationLimit, int maxStopCount, DataOverlayContext dataOverlayContext) {
        this(durationLimit, maxStopCount, dataOverlayContext, Set.of());
    }

    public StreetNearbyStopFinder(Duration durationLimit, int maxStopCount, DataOverlayContext dataOverlayContext, Set<Vertex> ignoreVertices) {
        this.dataOverlayContext = dataOverlayContext;
        this.durationLimit = durationLimit;
        this.maxStopCount = maxStopCount;
        this.ignoreVertices = ignoreVertices;
    }

    @Override
    public Collection<NearbyStop> findNearbyStops(Vertex vertex, RouteRequest routingRequest, StreetRequest streetRequest, boolean reverseDirection) {
        return this.findNearbyStops(Set.of(vertex), routingRequest, streetRequest, reverseDirection);
    }

    public Collection<NearbyStop> findNearbyStops(Set<Vertex> originVertices, RouteRequest request, StreetRequest streetRequest, boolean reverseDirection) {
        OTPRequestTimeoutException.checkForTimeout();
        List<NearbyStop> stopsFound = NearbyStop.nearbyStopsForTransitStopVerticesFiltered((Collection<? extends Vertex>)Sets.difference(originVertices, this.ignoreVertices), reverseDirection, request, streetRequest);
        if (streetRequest.mode() == StreetMode.NOT_SET || this.maxStopCount > 0 && stopsFound.size() >= this.maxStopCount) {
            return stopsFound;
        }
        stopsFound = new ArrayList<NearbyStop>(stopsFound);
        StreetSearchBuilder streetSearch = ((StreetSearchBuilder)((StreetSearchBuilder)((StreetSearchBuilder)((StreetSearchBuilder)((StreetSearchBuilder)StreetSearchBuilder.of().setSkipEdgeStrategy(new DurationSkipEdgeStrategy(this.durationLimit))).setDominanceFunction(new DominanceFunctions.MinimumWeight())).setRequest(request).setArriveBy(reverseDirection)).setStreetRequest(streetRequest).setFrom(reverseDirection ? null : originVertices)).setTo(reverseDirection ? originVertices : null)).setDataOverlayContext(this.dataOverlayContext);
        if (this.maxStopCount > 0) {
            streetSearch.setTerminationStrategy(new MaxCountTerminationStrategy<State>(this.maxStopCount, this::hasReachedStop));
        }
        ShortestPathTree spt = streetSearch.getShortestPathTree();
        ArrayListMultimap locationsMap = ArrayListMultimap.create();
        if (spt != null) {
            for (State state : spt.getAllStates()) {
                StreetVertex streetVertex;
                Vertex targetVertex = state.getVertex();
                if (originVertices.contains(targetVertex) || this.ignoreVertices.contains(targetVertex)) continue;
                if (targetVertex instanceof TransitStopVertex) {
                    TransitStopVertex tsv = (TransitStopVertex)targetVertex;
                    if (state.isFinal()) {
                        stopsFound.add(NearbyStop.nearbyStopForState(state, tsv.getStop()));
                    }
                }
                if (!OTPFeature.FlexRouting.isOn() || !(targetVertex instanceof StreetVertex) || (streetVertex = (StreetVertex)targetVertex).areaStops().isEmpty()) continue;
                for (AreaStop areaStop : ((StreetVertex)targetVertex).areaStops()) {
                    if (!this.canBoardFlex(state, reverseDirection)) continue;
                    locationsMap.put((Object)areaStop, (Object)state);
                }
            }
        }
        if (OTPFeature.FlexRouting.isOn()) {
            for (Map.Entry entry : locationsMap.asMap().entrySet()) {
                AreaStop areaStop = (AreaStop)entry.getKey();
                Collection states = (Collection)entry.getValue();
                State min = Collections.min(states, Comparator.comparing(State::getWeight));
                if (min.getBackState().getVertex() instanceof TemporaryStreetLocation) {
                    min = min.getBackState();
                }
                stopsFound.add(NearbyStop.nearbyStopForState(min, areaStop));
            }
        }
        return stopsFound;
    }

    private boolean canBoardFlex(State state, boolean reverse) {
        Collection<Edge> edges = reverse ? state.getVertex().getIncoming() : state.getVertex().getOutgoing();
        return edges.stream().anyMatch(e -> {
            StreetEdge se;
            return e instanceof StreetEdge && (se = (StreetEdge)e).getPermission().allows(TraverseMode.CAR);
        });
    }

    private boolean hasReachedStop(State state) {
        Vertex vertex = state.getVertex();
        return vertex instanceof TransitStopVertex && state.isFinal() && !this.ignoreVertices.contains(vertex);
    }
}

