/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.graph_builder.module.nearbystops;

import java.time.Duration;
import java.util.List;
import org.locationtech.jts.geom.Coordinate;
import org.opentripplanner.graph_builder.module.nearbystops.NearbyStopFinder;
import org.opentripplanner.routing.api.request.RouteRequest;
import org.opentripplanner.routing.api.request.preference.WalkPreferences;
import org.opentripplanner.routing.api.request.request.StreetRequest;
import org.opentripplanner.routing.graphfinder.DirectGraphFinder;
import org.opentripplanner.routing.graphfinder.NearbyStop;
import org.opentripplanner.street.model.vertex.Vertex;
import org.opentripplanner.transit.service.TransitService;

public class StraightLineNearbyStopFinder
implements NearbyStopFinder {
    private final Duration durationLimit;
    private final DirectGraphFinder directGraphFinder;

    public StraightLineNearbyStopFinder(TransitService transitService, Duration durationLimit) {
        this.durationLimit = durationLimit;
        this.directGraphFinder = new DirectGraphFinder(transitService::findRegularStopsByBoundingBox);
    }

    public List<NearbyStop> findNearbyStops(Vertex vertex, RouteRequest routingRequest, StreetRequest streetRequest, boolean reverseDirection) {
        return this.findNearbyStopsViaDirectTransfers(vertex);
    }

    private List<NearbyStop> findNearbyStopsViaDirectTransfers(Vertex vertex) {
        double limitMeters = (double)this.durationLimit.toSeconds() * WalkPreferences.DEFAULT.speed();
        Coordinate c0 = vertex.getCoordinate();
        return this.directGraphFinder.findClosestStops(c0, limitMeters);
    }
}

