/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.graph_builder.module.nearbystops;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.opentripplanner.ext.flex.trip.FlexTrip;
import org.opentripplanner.framework.application.OTPFeature;
import org.opentripplanner.graph_builder.module.nearbystops.MinMap;
import org.opentripplanner.graph_builder.module.nearbystops.NearbyStopFinder;
import org.opentripplanner.routing.api.request.RouteRequest;
import org.opentripplanner.routing.api.request.request.StreetRequest;
import org.opentripplanner.routing.graphfinder.NearbyStop;
import org.opentripplanner.street.model.vertex.Vertex;
import org.opentripplanner.transit.model.network.TripPattern;
import org.opentripplanner.transit.model.site.RegularStop;
import org.opentripplanner.transit.model.site.StopLocation;
import org.opentripplanner.transit.service.TransitService;

public class PatternConsideringNearbyStopFinder
implements NearbyStopFinder {
    private final NearbyStopFinder delegateNearbyStopFinder;
    private final TransitService transitService;

    public PatternConsideringNearbyStopFinder(TransitService transitService, NearbyStopFinder delegateNearbyStopFinder) {
        this.transitService = transitService;
        this.delegateNearbyStopFinder = delegateNearbyStopFinder;
    }

    public List<NearbyStop> findNearbyStops(Vertex vertex, RouteRequest routingRequest, StreetRequest streetRequest, boolean reverseDirection) {
        MinMap<TripPattern, NearbyStop> closestStopForPattern = new MinMap<TripPattern, NearbyStop>();
        MinMap closestStopForFlexTrip = new MinMap();
        HashSet<NearbyStop> uniqueStopsResult = new HashSet<NearbyStop>();
        for (NearbyStop nearbyStop : this.delegateNearbyStopFinder.findNearbyStops(vertex, routingRequest, streetRequest, reverseDirection)) {
            StopLocation ts1 = nearbyStop.stop;
            if (ts1 instanceof RegularStop) {
                RegularStop regularStop = (RegularStop)ts1;
                Collection<TripPattern> patternsForStop = this.transitService.findPatterns(ts1);
                if (OTPFeature.IncludeEmptyRailStopsInTransfers.isOn() && patternsForStop.isEmpty() && regularStop.isRailStop()) {
                    uniqueStopsResult.add(nearbyStop);
                }
                for (TripPattern pattern : patternsForStop) {
                    if (!(reverseDirection ? pattern.canAlight(nearbyStop.stop) : pattern.canBoard(nearbyStop.stop))) continue;
                    closestStopForPattern.putMin(pattern, nearbyStop);
                }
            }
            if (!OTPFeature.FlexRouting.isOn()) continue;
            for (FlexTrip<?, ?> trip : this.transitService.getFlexIndex().getFlexTripsByStop(ts1)) {
                if (!(reverseDirection ? trip.isAlightingPossible(nearbyStop.stop) : trip.isBoardingPossible(nearbyStop.stop))) continue;
                closestStopForFlexTrip.putMin(trip, nearbyStop);
            }
        }
        uniqueStopsResult.addAll(closestStopForFlexTrip.values());
        uniqueStopsResult.addAll(closestStopForPattern.values());
        return uniqueStopsResult.stream().toList();
    }
}

