/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.graph_builder.module.configure;

import dagger.BindsInstance;
import dagger.Component;
import jakarta.inject.Singleton;
import java.time.ZoneId;
import java.util.List;
import javax.annotation.Nullable;
import org.opentripplanner.ext.dataoverlay.EdgeUpdaterModule;
import org.opentripplanner.ext.emission.EmissionRepository;
import org.opentripplanner.ext.emission.configure.EmissionGraphBuilderModule;
import org.opentripplanner.ext.emission.internal.graphbuilder.EmissionGraphBuilder;
import org.opentripplanner.ext.flex.AreaStopsToVerticesMapper;
import org.opentripplanner.ext.stopconsolidation.StopConsolidationModule;
import org.opentripplanner.ext.stopconsolidation.StopConsolidationRepository;
import org.opentripplanner.ext.transferanalyzer.DirectTransferAnalyzer;
import org.opentripplanner.graph_builder.GraphBuilder;
import org.opentripplanner.graph_builder.GraphBuilderDataSources;
import org.opentripplanner.graph_builder.configure.GraphBuilderModule;
import org.opentripplanner.graph_builder.issue.report.DataImportIssueReporter;
import org.opentripplanner.graph_builder.module.DirectTransferGenerator;
import org.opentripplanner.graph_builder.module.GraphCoherencyCheckerModule;
import org.opentripplanner.graph_builder.module.OsmBoardingLocationsModule;
import org.opentripplanner.graph_builder.module.RouteToCentroidStationIdsValidator;
import org.opentripplanner.graph_builder.module.StreetLinkerModule;
import org.opentripplanner.graph_builder.module.TimeZoneAdjusterModule;
import org.opentripplanner.graph_builder.module.TripPatternNamer;
import org.opentripplanner.graph_builder.module.TurnRestrictionModule;
import org.opentripplanner.graph_builder.module.configure.GraphBuilderModules;
import org.opentripplanner.graph_builder.module.geometry.CalculateWorldEnvelopeModule;
import org.opentripplanner.graph_builder.module.islandpruning.PruneIslands;
import org.opentripplanner.graph_builder.module.ned.ElevationModule;
import org.opentripplanner.graph_builder.module.osm.OsmModule;
import org.opentripplanner.gtfs.graphbuilder.GtfsModule;
import org.opentripplanner.netex.NetexModule;
import org.opentripplanner.routing.fares.FareServiceFactory;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.routing.linking.VertexLinker;
import org.opentripplanner.routing.linking.configure.VertexLinkerGraphBuildingModule;
import org.opentripplanner.service.osminfo.OsmInfoGraphBuildRepository;
import org.opentripplanner.service.osminfo.configure.OsmInfoGraphBuildServiceModule;
import org.opentripplanner.service.vehicleparking.VehicleParkingRepository;
import org.opentripplanner.service.worldenvelope.WorldEnvelopeRepository;
import org.opentripplanner.standalone.config.BuildConfig;
import org.opentripplanner.street.model.StreetLimitationParameters;
import org.opentripplanner.transit.service.TimetableRepository;

@Singleton
@Component(modules={GraphBuilderModule.class, GraphBuilderModules.class, OsmInfoGraphBuildServiceModule.class, EmissionGraphBuilderModule.class, VertexLinkerGraphBuildingModule.class})
public interface GraphBuilderFactory {
    public AreaStopsToVerticesMapper areaStopsToVerticesMapper();

    public CalculateWorldEnvelopeModule calculateWorldEnvelopeModule();

    public DataImportIssueReporter dataImportIssueReporter();

    public DirectTransferGenerator directTransferGenerator();

    public DirectTransferAnalyzer directTransferAnalyzer();

    public GraphCoherencyCheckerModule graphCoherencyCheckerModule();

    public GraphBuilder graphBuilder();

    public GtfsModule gtfsModule();

    public List<ElevationModule> elevationModules();

    public NetexModule netexModule();

    public OsmBoardingLocationsModule osmBoardingLocationsModule();

    public OsmModule osmModule();

    public PruneIslands pruneIslands();

    public StreetLinkerModule streetLinkerModule();

    public TimeZoneAdjusterModule timeZoneAdjusterModule();

    public TripPatternNamer tripPatternNamer();

    @Nullable
    public EdgeUpdaterModule dataOverlayFactory();

    public TurnRestrictionModule turnRestrictionModule();

    @Nullable
    public EmissionGraphBuilder emissionGraphBuilder();

    @Nullable
    public RouteToCentroidStationIdsValidator routeToCentroidStationIdValidator();

    @Nullable
    public StopConsolidationModule stopConsolidationModule();

    public FareServiceFactory fareServiceFactory();

    public VertexLinker vertexLinker();

    @Component.Builder
    public static interface Builder {
        @BindsInstance
        public Builder config(BuildConfig var1);

        @BindsInstance
        public Builder graph(Graph var1);

        @BindsInstance
        public Builder timetableRepository(TimetableRepository var1);

        @BindsInstance
        public Builder osmInfoGraphBuildRepository(OsmInfoGraphBuildRepository var1);

        @BindsInstance
        public Builder worldEnvelopeRepository(WorldEnvelopeRepository var1);

        @BindsInstance
        public Builder stopConsolidationRepository(@Nullable StopConsolidationRepository var1);

        @BindsInstance
        public Builder vehicleParkingRepository(VehicleParkingRepository var1);

        @BindsInstance
        public Builder fareServiceFactory(FareServiceFactory var1);

        @BindsInstance
        public Builder streetLimitationParameters(StreetLimitationParameters var1);

        @BindsInstance
        public Builder dataSources(GraphBuilderDataSources var1);

        @BindsInstance
        public Builder timeZoneId(@Nullable ZoneId var1);

        public GraphBuilderFactory build();

        @BindsInstance
        public Builder emissionRepository(@Nullable EmissionRepository var1);
    }
}

