/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.graph_builder.module.configure;

import dagger.internal.DaggerGenerated;
import dagger.internal.DoubleCheck;
import dagger.internal.InstanceFactory;
import dagger.internal.Preconditions;
import dagger.internal.Provider;
import java.time.ZoneId;
import java.util.List;
import javax.annotation.Nullable;
import org.opentripplanner.ext.dataoverlay.EdgeUpdaterModule;
import org.opentripplanner.ext.emission.EmissionRepository;
import org.opentripplanner.ext.emission.configure.EmissionGraphBuilderModule_ProvideEmissionModuleFactory;
import org.opentripplanner.ext.emission.internal.graphbuilder.EmissionGraphBuilder;
import org.opentripplanner.ext.flex.AreaStopsToVerticesMapper;
import org.opentripplanner.ext.stopconsolidation.StopConsolidationModule;
import org.opentripplanner.ext.stopconsolidation.StopConsolidationRepository;
import org.opentripplanner.ext.transferanalyzer.DirectTransferAnalyzer;
import org.opentripplanner.graph_builder.GraphBuilder;
import org.opentripplanner.graph_builder.GraphBuilderDataSources;
import org.opentripplanner.graph_builder.configure.GraphBuilderModule_ProvideGraphBuilderFactory;
import org.opentripplanner.graph_builder.issue.api.DataImportIssueStore;
import org.opentripplanner.graph_builder.issue.report.DataImportIssueReporter;
import org.opentripplanner.graph_builder.module.DirectTransferGenerator;
import org.opentripplanner.graph_builder.module.GraphCoherencyCheckerModule;
import org.opentripplanner.graph_builder.module.OsmBoardingLocationsModule;
import org.opentripplanner.graph_builder.module.RouteToCentroidStationIdsValidator;
import org.opentripplanner.graph_builder.module.StreetLinkerModule;
import org.opentripplanner.graph_builder.module.TimeZoneAdjusterModule;
import org.opentripplanner.graph_builder.module.TripPatternNamer;
import org.opentripplanner.graph_builder.module.TurnRestrictionModule;
import org.opentripplanner.graph_builder.module.configure.GraphBuilderFactory;
import org.opentripplanner.graph_builder.module.configure.GraphBuilderModules_ProvideDataImportIssuesStoreFactory;
import org.opentripplanner.graph_builder.module.configure.GraphBuilderModules_ProvideDataImportIssuesToHTMLFactory;
import org.opentripplanner.graph_builder.module.configure.GraphBuilderModules_ProvideDataOverlayFactoryFactory;
import org.opentripplanner.graph_builder.module.configure.GraphBuilderModules_ProvideDirectTransferAnalyzerFactory;
import org.opentripplanner.graph_builder.module.configure.GraphBuilderModules_ProvideDirectTransferGeneratorFactory;
import org.opentripplanner.graph_builder.module.configure.GraphBuilderModules_ProvideElevationModulesFactory;
import org.opentripplanner.graph_builder.module.configure.GraphBuilderModules_ProvideGtfsModuleFactory;
import org.opentripplanner.graph_builder.module.configure.GraphBuilderModules_ProvideNetexModuleFactory;
import org.opentripplanner.graph_builder.module.configure.GraphBuilderModules_ProvideOsmModuleFactory;
import org.opentripplanner.graph_builder.module.configure.GraphBuilderModules_ProvidePruneIslandsFactory;
import org.opentripplanner.graph_builder.module.configure.GraphBuilderModules_ProvideStreetLinkerModuleFactory;
import org.opentripplanner.graph_builder.module.configure.GraphBuilderModules_ProvideTurnRestrictionModuleFactory;
import org.opentripplanner.graph_builder.module.configure.GraphBuilderModules_ProvidesStopConsolidationModuleFactory;
import org.opentripplanner.graph_builder.module.configure.GraphBuilderModules_RouteToCentroidStationIdValidatorFactory;
import org.opentripplanner.graph_builder.module.geometry.CalculateWorldEnvelopeModule;
import org.opentripplanner.graph_builder.module.islandpruning.PruneIslands;
import org.opentripplanner.graph_builder.module.ned.ElevationModule;
import org.opentripplanner.graph_builder.module.osm.OsmModule;
import org.opentripplanner.gtfs.graphbuilder.GtfsModule;
import org.opentripplanner.netex.NetexModule;
import org.opentripplanner.routing.fares.FareServiceFactory;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.routing.linking.VertexLinker;
import org.opentripplanner.routing.linking.configure.VertexLinkerGraphBuildingModule_LinkerFactory;
import org.opentripplanner.service.osminfo.OsmInfoGraphBuildRepository;
import org.opentripplanner.service.osminfo.internal.DefaultOsmInfoGraphBuildService;
import org.opentripplanner.service.vehicleparking.VehicleParkingRepository;
import org.opentripplanner.service.worldenvelope.WorldEnvelopeRepository;
import org.opentripplanner.standalone.config.BuildConfig;
import org.opentripplanner.street.model.StreetLimitationParameters;
import org.opentripplanner.transit.service.TimetableRepository;

@DaggerGenerated
public final class DaggerGraphBuilderFactory {
    private DaggerGraphBuilderFactory() {
    }

    public static GraphBuilderFactory.Builder builder() {
        return new Builder();
    }

    private static final class Builder
    implements GraphBuilderFactory.Builder {
        private BuildConfig config;
        private Graph graph;
        private TimetableRepository timetableRepository;
        private OsmInfoGraphBuildRepository osmInfoGraphBuildRepository;
        private WorldEnvelopeRepository worldEnvelopeRepository;
        private StopConsolidationRepository stopConsolidationRepository;
        private VehicleParkingRepository vehicleParkingRepository;
        private FareServiceFactory fareServiceFactory;
        private StreetLimitationParameters streetLimitationParameters;
        private GraphBuilderDataSources dataSources;
        private ZoneId timeZoneId;
        private EmissionRepository emissionRepository;

        private Builder() {
        }

        @Override
        public Builder config(BuildConfig config) {
            this.config = (BuildConfig)Preconditions.checkNotNull((Object)config);
            return this;
        }

        @Override
        public Builder graph(Graph graph) {
            this.graph = (Graph)Preconditions.checkNotNull((Object)graph);
            return this;
        }

        @Override
        public Builder timetableRepository(TimetableRepository timetableRepository) {
            this.timetableRepository = (TimetableRepository)Preconditions.checkNotNull((Object)timetableRepository);
            return this;
        }

        @Override
        public Builder osmInfoGraphBuildRepository(OsmInfoGraphBuildRepository osmInfoGraphBuildRepository) {
            this.osmInfoGraphBuildRepository = (OsmInfoGraphBuildRepository)Preconditions.checkNotNull((Object)osmInfoGraphBuildRepository);
            return this;
        }

        @Override
        public Builder worldEnvelopeRepository(WorldEnvelopeRepository worldEnvelopeRepository) {
            this.worldEnvelopeRepository = (WorldEnvelopeRepository)Preconditions.checkNotNull((Object)worldEnvelopeRepository);
            return this;
        }

        @Override
        public Builder stopConsolidationRepository(@Nullable StopConsolidationRepository stopConsolidationRepository) {
            this.stopConsolidationRepository = stopConsolidationRepository;
            return this;
        }

        @Override
        public Builder vehicleParkingRepository(VehicleParkingRepository parkingRepository) {
            this.vehicleParkingRepository = (VehicleParkingRepository)Preconditions.checkNotNull((Object)parkingRepository);
            return this;
        }

        @Override
        public Builder fareServiceFactory(FareServiceFactory fareServiceFactory) {
            this.fareServiceFactory = (FareServiceFactory)Preconditions.checkNotNull((Object)fareServiceFactory);
            return this;
        }

        @Override
        public Builder streetLimitationParameters(StreetLimitationParameters streetLimitationParameters) {
            this.streetLimitationParameters = (StreetLimitationParameters)Preconditions.checkNotNull((Object)streetLimitationParameters);
            return this;
        }

        @Override
        public Builder dataSources(GraphBuilderDataSources graphBuilderDataSources) {
            this.dataSources = (GraphBuilderDataSources)Preconditions.checkNotNull((Object)graphBuilderDataSources);
            return this;
        }

        @Override
        public Builder timeZoneId(@Nullable ZoneId zoneId) {
            this.timeZoneId = zoneId;
            return this;
        }

        @Override
        public Builder emissionRepository(@Nullable EmissionRepository emissionRepository) {
            this.emissionRepository = emissionRepository;
            return this;
        }

        @Override
        public GraphBuilderFactory build() {
            Preconditions.checkBuilderRequirement((Object)this.config, BuildConfig.class);
            Preconditions.checkBuilderRequirement((Object)this.graph, Graph.class);
            Preconditions.checkBuilderRequirement((Object)this.timetableRepository, TimetableRepository.class);
            Preconditions.checkBuilderRequirement((Object)this.osmInfoGraphBuildRepository, OsmInfoGraphBuildRepository.class);
            Preconditions.checkBuilderRequirement((Object)this.worldEnvelopeRepository, WorldEnvelopeRepository.class);
            Preconditions.checkBuilderRequirement((Object)this.vehicleParkingRepository, VehicleParkingRepository.class);
            Preconditions.checkBuilderRequirement((Object)this.fareServiceFactory, FareServiceFactory.class);
            Preconditions.checkBuilderRequirement((Object)this.streetLimitationParameters, StreetLimitationParameters.class);
            Preconditions.checkBuilderRequirement((Object)this.dataSources, GraphBuilderDataSources.class);
            return new GraphBuilderFactoryImpl(this.config, this.graph, this.timetableRepository, this.osmInfoGraphBuildRepository, this.worldEnvelopeRepository, this.stopConsolidationRepository, this.vehicleParkingRepository, this.fareServiceFactory, this.streetLimitationParameters, this.dataSources, this.timeZoneId, this.emissionRepository);
        }
    }

    private static final class GraphBuilderFactoryImpl
    implements GraphBuilderFactory {
        private final Graph graph;
        private final TimetableRepository timetableRepository;
        private final WorldEnvelopeRepository worldEnvelopeRepository;
        private final OsmInfoGraphBuildRepository osmInfoGraphBuildRepository;
        private final FareServiceFactory fareServiceFactory;
        private final GraphBuilderFactoryImpl graphBuilderFactoryImpl = this;
        Provider<GraphBuilderDataSources> dataSourcesProvider;
        Provider<BuildConfig> configProvider;
        Provider<DataImportIssueStore> provideDataImportIssuesStoreProvider;
        Provider<DataImportIssueReporter> provideDataImportIssuesToHTMLProvider;
        Provider<Graph> graphProvider;
        Provider<TimetableRepository> timetableRepositoryProvider;
        Provider<DirectTransferGenerator> provideDirectTransferGeneratorProvider;
        Provider<VertexLinker> linkerProvider;
        Provider<DirectTransferAnalyzer> provideDirectTransferAnalyzerProvider;
        Provider<GraphBuilder> provideGraphBuilderProvider;
        Provider<FareServiceFactory> fareServiceFactoryProvider;
        Provider<GtfsModule> provideGtfsModuleProvider;
        Provider<OsmInfoGraphBuildRepository> osmInfoGraphBuildRepositoryProvider;
        Provider<VehicleParkingRepository> vehicleParkingRepositoryProvider;
        Provider<StreetLimitationParameters> streetLimitationParametersProvider;
        Provider<OsmModule> provideOsmModuleProvider;
        Provider<List<ElevationModule>> provideElevationModulesProvider;
        Provider<NetexModule> provideNetexModuleProvider;
        Provider<PruneIslands> providePruneIslandsProvider;
        Provider<StreetLinkerModule> provideStreetLinkerModuleProvider;
        Provider<EdgeUpdaterModule> provideDataOverlayFactoryProvider;
        Provider<TurnRestrictionModule> provideTurnRestrictionModuleProvider;
        Provider<EmissionRepository> emissionRepositoryProvider;
        Provider<EmissionGraphBuilder> provideEmissionModuleProvider;
        Provider<RouteToCentroidStationIdsValidator> routeToCentroidStationIdValidatorProvider;
        Provider<StopConsolidationRepository> stopConsolidationRepositoryProvider;
        Provider<StopConsolidationModule> providesStopConsolidationModuleProvider;

        GraphBuilderFactoryImpl(BuildConfig configParam, Graph graphParam, TimetableRepository timetableRepositoryParam, OsmInfoGraphBuildRepository osmInfoGraphBuildRepositoryParam, WorldEnvelopeRepository worldEnvelopeRepositoryParam, StopConsolidationRepository stopConsolidationRepositoryParam, VehicleParkingRepository vehicleParkingRepositoryParam, FareServiceFactory fareServiceFactoryParam, StreetLimitationParameters streetLimitationParametersParam, GraphBuilderDataSources dataSourcesParam, ZoneId timeZoneIdParam, EmissionRepository emissionRepositoryParam) {
            this.graph = graphParam;
            this.timetableRepository = timetableRepositoryParam;
            this.worldEnvelopeRepository = worldEnvelopeRepositoryParam;
            this.osmInfoGraphBuildRepository = osmInfoGraphBuildRepositoryParam;
            this.fareServiceFactory = fareServiceFactoryParam;
            this.initialize(configParam, graphParam, timetableRepositoryParam, osmInfoGraphBuildRepositoryParam, worldEnvelopeRepositoryParam, stopConsolidationRepositoryParam, vehicleParkingRepositoryParam, fareServiceFactoryParam, streetLimitationParametersParam, dataSourcesParam, timeZoneIdParam, emissionRepositoryParam);
            this.initialize2(configParam, graphParam, timetableRepositoryParam, osmInfoGraphBuildRepositoryParam, worldEnvelopeRepositoryParam, stopConsolidationRepositoryParam, vehicleParkingRepositoryParam, fareServiceFactoryParam, streetLimitationParametersParam, dataSourcesParam, timeZoneIdParam, emissionRepositoryParam);
        }

        DefaultOsmInfoGraphBuildService defaultOsmInfoGraphBuildService() {
            return new DefaultOsmInfoGraphBuildService(this.osmInfoGraphBuildRepository);
        }

        private void initialize(BuildConfig configParam, Graph graphParam, TimetableRepository timetableRepositoryParam, OsmInfoGraphBuildRepository osmInfoGraphBuildRepositoryParam, WorldEnvelopeRepository worldEnvelopeRepositoryParam, StopConsolidationRepository stopConsolidationRepositoryParam, VehicleParkingRepository vehicleParkingRepositoryParam, FareServiceFactory fareServiceFactoryParam, StreetLimitationParameters streetLimitationParametersParam, GraphBuilderDataSources dataSourcesParam, ZoneId timeZoneIdParam, EmissionRepository emissionRepositoryParam) {
            this.dataSourcesProvider = InstanceFactory.create((Object)dataSourcesParam);
            this.configProvider = InstanceFactory.create((Object)configParam);
            this.provideDataImportIssuesStoreProvider = DoubleCheck.provider((Provider)GraphBuilderModules_ProvideDataImportIssuesStoreFactory.create());
            this.provideDataImportIssuesToHTMLProvider = DoubleCheck.provider((Provider)GraphBuilderModules_ProvideDataImportIssuesToHTMLFactory.create(this.dataSourcesProvider, this.configProvider, this.provideDataImportIssuesStoreProvider));
            this.graphProvider = InstanceFactory.create((Object)graphParam);
            this.timetableRepositoryProvider = InstanceFactory.create((Object)timetableRepositoryParam);
            this.provideDirectTransferGeneratorProvider = DoubleCheck.provider((Provider)GraphBuilderModules_ProvideDirectTransferGeneratorFactory.create(this.configProvider, this.graphProvider, this.timetableRepositoryProvider, this.provideDataImportIssuesStoreProvider));
            this.linkerProvider = DoubleCheck.provider((Provider)VertexLinkerGraphBuildingModule_LinkerFactory.create(this.graphProvider, this.configProvider));
            this.provideDirectTransferAnalyzerProvider = DoubleCheck.provider((Provider)GraphBuilderModules_ProvideDirectTransferAnalyzerFactory.create(this.configProvider, this.graphProvider, this.linkerProvider, this.timetableRepositoryProvider, this.provideDataImportIssuesStoreProvider));
            this.provideGraphBuilderProvider = DoubleCheck.provider((Provider)GraphBuilderModule_ProvideGraphBuilderFactory.create(this.graphProvider, this.timetableRepositoryProvider, this.provideDataImportIssuesStoreProvider, this.dataSourcesProvider));
            this.fareServiceFactoryProvider = InstanceFactory.create((Object)fareServiceFactoryParam);
            this.provideGtfsModuleProvider = DoubleCheck.provider((Provider)GraphBuilderModules_ProvideGtfsModuleFactory.create(this.dataSourcesProvider, this.configProvider, this.graphProvider, this.timetableRepositoryProvider, this.provideDataImportIssuesStoreProvider, this.fareServiceFactoryProvider));
            this.osmInfoGraphBuildRepositoryProvider = InstanceFactory.create((Object)osmInfoGraphBuildRepositoryParam);
            this.vehicleParkingRepositoryProvider = InstanceFactory.create((Object)vehicleParkingRepositoryParam);
            this.streetLimitationParametersProvider = InstanceFactory.create((Object)streetLimitationParametersParam);
            this.provideOsmModuleProvider = DoubleCheck.provider((Provider)GraphBuilderModules_ProvideOsmModuleFactory.create(this.dataSourcesProvider, this.configProvider, this.graphProvider, this.osmInfoGraphBuildRepositoryProvider, this.vehicleParkingRepositoryProvider, this.provideDataImportIssuesStoreProvider, this.streetLimitationParametersProvider));
            this.provideElevationModulesProvider = DoubleCheck.provider((Provider)GraphBuilderModules_ProvideElevationModulesFactory.create(this.configProvider, this.dataSourcesProvider, this.graphProvider, this.provideOsmModuleProvider, this.provideDataImportIssuesStoreProvider));
            this.provideNetexModuleProvider = DoubleCheck.provider((Provider)GraphBuilderModules_ProvideNetexModuleFactory.create(this.dataSourcesProvider, this.configProvider, this.graphProvider, this.timetableRepositoryProvider, this.vehicleParkingRepositoryProvider, this.provideDataImportIssuesStoreProvider));
            this.providePruneIslandsProvider = DoubleCheck.provider((Provider)GraphBuilderModules_ProvidePruneIslandsFactory.create(this.configProvider, this.graphProvider, this.vehicleParkingRepositoryProvider, this.timetableRepositoryProvider, this.provideDataImportIssuesStoreProvider, this.linkerProvider));
            this.provideStreetLinkerModuleProvider = DoubleCheck.provider((Provider)GraphBuilderModules_ProvideStreetLinkerModuleFactory.create(this.graphProvider, this.vehicleParkingRepositoryProvider, this.timetableRepositoryProvider, this.provideDataImportIssuesStoreProvider, this.linkerProvider));
            this.provideDataOverlayFactoryProvider = DoubleCheck.provider((Provider)GraphBuilderModules_ProvideDataOverlayFactoryFactory.create(this.configProvider, this.graphProvider));
            this.provideTurnRestrictionModuleProvider = DoubleCheck.provider((Provider)GraphBuilderModules_ProvideTurnRestrictionModuleFactory.create(this.graphProvider, this.osmInfoGraphBuildRepositoryProvider));
            this.emissionRepositoryProvider = InstanceFactory.createNullable((Object)emissionRepositoryParam);
            this.provideEmissionModuleProvider = DoubleCheck.provider((Provider)EmissionGraphBuilderModule_ProvideEmissionModuleFactory.create(this.dataSourcesProvider, this.configProvider, this.emissionRepositoryProvider, this.timetableRepositoryProvider, this.provideDataImportIssuesStoreProvider));
            this.routeToCentroidStationIdValidatorProvider = DoubleCheck.provider((Provider)GraphBuilderModules_RouteToCentroidStationIdValidatorFactory.create(this.provideDataImportIssuesStoreProvider, this.configProvider, this.timetableRepositoryProvider));
        }

        private void initialize2(BuildConfig configParam, Graph graphParam, TimetableRepository timetableRepositoryParam, OsmInfoGraphBuildRepository osmInfoGraphBuildRepositoryParam, WorldEnvelopeRepository worldEnvelopeRepositoryParam, StopConsolidationRepository stopConsolidationRepositoryParam, VehicleParkingRepository vehicleParkingRepositoryParam, FareServiceFactory fareServiceFactoryParam, StreetLimitationParameters streetLimitationParametersParam, GraphBuilderDataSources dataSourcesParam, ZoneId timeZoneIdParam, EmissionRepository emissionRepositoryParam) {
            this.stopConsolidationRepositoryProvider = InstanceFactory.createNullable((Object)stopConsolidationRepositoryParam);
            this.providesStopConsolidationModuleProvider = DoubleCheck.provider((Provider)GraphBuilderModules_ProvidesStopConsolidationModuleFactory.create(this.timetableRepositoryProvider, this.stopConsolidationRepositoryProvider, this.dataSourcesProvider));
        }

        @Override
        public AreaStopsToVerticesMapper areaStopsToVerticesMapper() {
            return new AreaStopsToVerticesMapper(this.graph, this.timetableRepository);
        }

        @Override
        public CalculateWorldEnvelopeModule calculateWorldEnvelopeModule() {
            return new CalculateWorldEnvelopeModule(this.graph, this.timetableRepository, this.worldEnvelopeRepository);
        }

        @Override
        public DataImportIssueReporter dataImportIssueReporter() {
            return (DataImportIssueReporter)this.provideDataImportIssuesToHTMLProvider.get();
        }

        @Override
        public DirectTransferGenerator directTransferGenerator() {
            return (DirectTransferGenerator)this.provideDirectTransferGeneratorProvider.get();
        }

        @Override
        public DirectTransferAnalyzer directTransferAnalyzer() {
            return (DirectTransferAnalyzer)this.provideDirectTransferAnalyzerProvider.get();
        }

        @Override
        public GraphCoherencyCheckerModule graphCoherencyCheckerModule() {
            return new GraphCoherencyCheckerModule(this.graph, (DataImportIssueStore)this.provideDataImportIssuesStoreProvider.get());
        }

        @Override
        public GraphBuilder graphBuilder() {
            return (GraphBuilder)this.provideGraphBuilderProvider.get();
        }

        @Override
        public GtfsModule gtfsModule() {
            return (GtfsModule)this.provideGtfsModuleProvider.get();
        }

        @Override
        public List<ElevationModule> elevationModules() {
            return (List)this.provideElevationModulesProvider.get();
        }

        @Override
        public NetexModule netexModule() {
            return (NetexModule)this.provideNetexModuleProvider.get();
        }

        @Override
        public OsmBoardingLocationsModule osmBoardingLocationsModule() {
            return new OsmBoardingLocationsModule(this.graph, (VertexLinker)this.linkerProvider.get(), this.defaultOsmInfoGraphBuildService());
        }

        @Override
        public OsmModule osmModule() {
            return (OsmModule)this.provideOsmModuleProvider.get();
        }

        @Override
        public PruneIslands pruneIslands() {
            return (PruneIslands)this.providePruneIslandsProvider.get();
        }

        @Override
        public StreetLinkerModule streetLinkerModule() {
            return (StreetLinkerModule)this.provideStreetLinkerModuleProvider.get();
        }

        @Override
        public TimeZoneAdjusterModule timeZoneAdjusterModule() {
            return new TimeZoneAdjusterModule(this.timetableRepository);
        }

        @Override
        public TripPatternNamer tripPatternNamer() {
            return new TripPatternNamer(this.timetableRepository);
        }

        @Override
        @Nullable
        public EdgeUpdaterModule dataOverlayFactory() {
            return (EdgeUpdaterModule)this.provideDataOverlayFactoryProvider.get();
        }

        @Override
        public TurnRestrictionModule turnRestrictionModule() {
            return (TurnRestrictionModule)this.provideTurnRestrictionModuleProvider.get();
        }

        @Override
        @Nullable
        public EmissionGraphBuilder emissionGraphBuilder() {
            return (EmissionGraphBuilder)this.provideEmissionModuleProvider.get();
        }

        @Override
        @Nullable
        public RouteToCentroidStationIdsValidator routeToCentroidStationIdValidator() {
            return (RouteToCentroidStationIdsValidator)this.routeToCentroidStationIdValidatorProvider.get();
        }

        @Override
        @Nullable
        public StopConsolidationModule stopConsolidationModule() {
            return (StopConsolidationModule)this.providesStopConsolidationModuleProvider.get();
        }

        @Override
        public FareServiceFactory fareServiceFactory() {
            return this.fareServiceFactory;
        }

        @Override
        public VertexLinker vertexLinker() {
            return (VertexLinker)this.linkerProvider.get();
        }
    }
}

