/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.graph_builder.module;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opentripplanner.graph_builder.model.GraphBuilderModule;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.service.osminfo.OsmInfoGraphBuildRepository;
import org.opentripplanner.street.model.StreetTraversalPermission;
import org.opentripplanner.street.model.TurnRestriction;
import org.opentripplanner.street.model.TurnRestrictionType;
import org.opentripplanner.street.model.edge.Edge;
import org.opentripplanner.street.model.edge.StreetEdge;
import org.opentripplanner.street.model.edge.StreetEdgeBuilder;
import org.opentripplanner.street.model.vertex.IntersectionVertex;
import org.opentripplanner.street.model.vertex.SubsidiaryVertex;
import org.opentripplanner.street.model.vertex.Vertex;
import org.opentripplanner.street.search.TraverseModeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TurnRestrictionModule
implements GraphBuilderModule {
    private static final Logger LOG = LoggerFactory.getLogger(TurnRestrictionModule.class);
    final Graph graph;
    final OsmInfoGraphBuildRepository osmInfoGraphBuildRepository;
    final Map<Vertex, Set<SubsidiaryVertex>> subsidiaryVertices;
    final Map<Vertex, IntersectionVertex> mainVertices;
    int addedVertices;
    int addedEdges;

    public TurnRestrictionModule(Graph graph, OsmInfoGraphBuildRepository osmInfoGraphBuildRepository) {
        this.graph = graph;
        this.osmInfoGraphBuildRepository = osmInfoGraphBuildRepository;
        this.subsidiaryVertices = new HashMap<Vertex, Set<SubsidiaryVertex>>();
        this.mainVertices = new HashMap<Vertex, IntersectionVertex>();
        this.initializeMainAndSubsidiaryVertices();
    }

    void initializeMainAndSubsidiaryVertices() {
        for (SubsidiaryVertex vertex : this.graph.getVerticesOfType(SubsidiaryVertex.class)) {
            Vertex parent = vertex.getParent();
            if (!(parent instanceof IntersectionVertex)) continue;
            IntersectionVertex intersectionVertex = (IntersectionVertex)parent;
            this.mainVertices.put(vertex, intersectionVertex);
            this.subsidiaryVertices.computeIfAbsent(parent, k -> new HashSet()).add(vertex);
        }
    }

    Vertex getMainVertex(Vertex vertex) {
        if (this.mainVertices.containsKey(vertex)) {
            return this.mainVertices.get(vertex);
        }
        return vertex;
    }

    boolean isCorrespondingVertex(Vertex a, Vertex b) {
        if (a == b) {
            return true;
        }
        return this.getMainVertex(a) == this.getMainVertex(b);
    }

    List<StreetEdge> getFromCorrespondingEdges(StreetEdge edge, IntersectionVertex intersectionVertex) {
        ArrayList<StreetEdge> edges = new ArrayList<StreetEdge>();
        for (StreetEdge e : intersectionVertex.getIncomingStreetEdges()) {
            if (!this.isCorrespondingVertex(e.getFromVertex(), edge.getFromVertex())) continue;
            edges.add(e);
        }
        return edges;
    }

    StreetTraversalPermission streetTraversalPermission(TraverseModeSet traverseModeSet) {
        StreetTraversalPermission permission = StreetTraversalPermission.NONE;
        if (traverseModeSet.getBicycle()) {
            permission = permission.add(StreetTraversalPermission.BICYCLE);
        }
        if (traverseModeSet.getWalk()) {
            permission = permission.add(StreetTraversalPermission.PEDESTRIAN);
        }
        if (traverseModeSet.getCar()) {
            permission = permission.add(StreetTraversalPermission.CAR);
        }
        return permission;
    }

    void processVertex(IntersectionVertex vertex, TurnRestriction turnRestriction) {
        List<StreetEdge> fromEdges = this.getFromCorrespondingEdges(turnRestriction.from, vertex);
        if (fromEdges.isEmpty()) {
            return;
        }
        IntersectionVertex mainVertex = (IntersectionVertex)turnRestriction.from.getToVertex();
        SubsidiaryVertex splitVertex = new SubsidiaryVertex(mainVertex);
        this.graph.addVertex(splitVertex);
        this.subsidiaryVertices.get(mainVertex).add(splitVertex);
        this.mainVertices.put(splitVertex, mainVertex);
        ++this.addedVertices;
        boolean hasRemovedInputEdges = false;
        for (StreetEdge fromEdge : fromEdges) {
            StreetTraversalPermission fromPermission = fromEdge.getPermission();
            StreetTraversalPermission restrictionPermission = this.streetTraversalPermission(turnRestriction.modes);
            StreetTraversalPermission oldPermission = fromPermission.remove(restrictionPermission);
            StreetTraversalPermission newPermission = fromPermission.intersection(restrictionPermission);
            if (newPermission.allowsAnything()) {
                ((StreetEdgeBuilder)((StreetEdgeBuilder)fromEdge.toBuilder().withToVertex(splitVertex)).withPermission(newPermission)).buildAndConnect();
                ++this.addedEdges;
            }
            if (oldPermission.allowsNothing()) {
                fromEdge.remove();
                --this.addedEdges;
                hasRemovedInputEdges = true;
            } else {
                fromEdge.setPermission(oldPermission);
            }
            for (StreetEdge toEdge : vertex.getOutgoingStreetEdges()) {
                if (turnRestriction.type == TurnRestrictionType.NO_TURN) {
                    if (this.isCorrespondingVertex(turnRestriction.to.getToVertex(), toEdge.getToVertex())) continue;
                    ((StreetEdgeBuilder)toEdge.toBuilder().withFromVertex(splitVertex)).buildAndConnect();
                    ++this.addedEdges;
                    continue;
                }
                if (!this.isCorrespondingVertex(turnRestriction.to.getToVertex(), toEdge.getToVertex())) continue;
                ((StreetEdgeBuilder)toEdge.toBuilder().withFromVertex(splitVertex)).buildAndConnect();
                ++this.addedEdges;
            }
        }
        if (hasRemovedInputEdges && vertex.getIncoming().isEmpty()) {
            for (Edge toEdge : vertex.getOutgoing()) {
                toEdge.remove();
                --this.addedEdges;
            }
            this.graph.remove(vertex);
            --this.addedVertices;
        }
    }

    void processRestriction(TurnRestriction turnRestriction) {
        IntersectionVertex intersectionVertex;
        Vertex vertex = turnRestriction.from.getToVertex();
        if (vertex instanceof IntersectionVertex) {
            intersectionVertex = (IntersectionVertex)vertex;
            if (this.subsidiaryVertices.containsKey(vertex)) {
                Set<SubsidiaryVertex> vertices = this.subsidiaryVertices.get(vertex);
                for (SubsidiaryVertex subVertex : vertices.toArray(new SubsidiaryVertex[0])) {
                    this.processVertex(subVertex, turnRestriction);
                }
            } else {
                this.subsidiaryVertices.put(vertex, new HashSet());
            }
        } else {
            throw new IllegalStateException(String.format("Vertex %s is not an IntersectionVertex", vertex));
        }
        this.processVertex(intersectionVertex, turnRestriction);
    }

    @Override
    public void buildGraph() {
        LOG.info("Applying turn restrictions to graph");
        int turnRestrictionCount = 0;
        this.addedVertices = 0;
        this.addedEdges = 0;
        for (TurnRestriction turnRestriction : this.osmInfoGraphBuildRepository.listTurnRestrictions()) {
            this.processRestriction(turnRestriction);
            ++turnRestrictionCount;
        }
        LOG.info("Applied {} turn restrictions, added {} vertices and {} edges", new Object[]{turnRestrictionCount, this.addedVertices, this.addedEdges});
    }
}

