/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.graph_builder.module;

import java.time.Duration;
import org.opentripplanner.utils.tostring.ToStringBuilder;

public record TransferParameters(Duration maxTransferDuration, Duration carsAllowedStopMaxTransferDuration, boolean disableDefaultTransfers) {
    public static final Duration DEFAULT_MAX_TRANSFER_DURATION = null;
    public static final Duration DEFAULT_CARS_ALLOWED_STOP_MAX_TRANSFER_DURATION = null;
    public static final boolean DEFAULT_DISABLE_DEFAULT_TRANSFERS = false;

    TransferParameters(Builder builder) {
        this(builder.maxTransferDuration, builder.carsAllowedStopMaxTransferDuration, builder.disableDefaultTransfers);
    }

    @Override
    public String toString() {
        return ToStringBuilder.of(this.getClass()).addDuration("maxTransferDuration", this.maxTransferDuration).addDuration("carsAllowedStopMaxTransferDuration", this.carsAllowedStopMaxTransferDuration).addBool("disableDefaultTransfers", Boolean.valueOf(this.disableDefaultTransfers)).toString();
    }

    public static class Builder {
        private Duration maxTransferDuration = DEFAULT_MAX_TRANSFER_DURATION;
        private Duration carsAllowedStopMaxTransferDuration = DEFAULT_CARS_ALLOWED_STOP_MAX_TRANSFER_DURATION;
        private boolean disableDefaultTransfers = false;

        public Builder withMaxTransferDuration(Duration maxTransferDuration) {
            this.maxTransferDuration = maxTransferDuration;
            return this;
        }

        public Builder withCarsAllowedStopMaxTransferDuration(Duration carsAllowedStopMaxTransferDuration) {
            this.carsAllowedStopMaxTransferDuration = carsAllowedStopMaxTransferDuration;
            return this;
        }

        public Builder withDisableDefaultTransfers(boolean disableDefaultTransfers) {
            this.disableDefaultTransfers = disableDefaultTransfers;
            return this;
        }

        public TransferParameters build() {
            return new TransferParameters(this);
        }
    }
}

