/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.graph_builder.module;

import jakarta.inject.Inject;
import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import org.opentripplanner.graph_builder.model.GraphBuilderModule;
import org.opentripplanner.transit.model.network.TripPattern;
import org.opentripplanner.transit.service.TimetableRepository;

public class TimeZoneAdjusterModule
implements GraphBuilderModule {
    private final TimetableRepository timetableRepository;

    @Inject
    public TimeZoneAdjusterModule(TimetableRepository timetableRepository) {
        this.timetableRepository = timetableRepository;
    }

    @Override
    public void buildGraph() {
        Instant serviceStart = this.timetableRepository.getTransitServiceStarts().toInstant();
        Duration graphOffset = Duration.ofSeconds(this.timetableRepository.getTimeZone().getRules().getOffset(serviceStart).getTotalSeconds());
        HashMap agencyShift = new HashMap();
        this.timetableRepository.getAllTripPatterns().forEach(pattern -> {
            Duration timeShift = agencyShift.computeIfAbsent(pattern.getRoute().getAgency().getTimezone(), zoneId -> graphOffset.minusSeconds(zoneId.getRules().getOffset(serviceStart).getTotalSeconds()));
            if (timeShift.isZero()) {
                return;
            }
            TripPattern updatedPattern = (TripPattern)pattern.copy().withScheduledTimeTableBuilder(builder -> builder.updateAllTripTimes(tt -> tt.adjustTimesToGraphTimeZone(timeShift))).build();
            this.timetableRepository.addTripPattern(updatedPattern.getId(), updatedPattern);
        });
        this.timetableRepository.index();
    }
}

