/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.graph_builder.module;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.opentripplanner.framework.application.OTPFeature;
import org.opentripplanner.graph_builder.issue.api.DataImportIssueStore;
import org.opentripplanner.graph_builder.issues.ParkAndRideEntranceRemoved;
import org.opentripplanner.graph_builder.model.GraphBuilderModule;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.routing.linking.VertexLinker;
import org.opentripplanner.service.vehicleparking.VehicleParkingRepository;
import org.opentripplanner.service.vehicleparking.model.VehicleParking;
import org.opentripplanner.service.vehicleparking.model.VehicleParkingEntrance;
import org.opentripplanner.service.vehicleparking.model.VehicleParkingHelper;
import org.opentripplanner.street.model.edge.Edge;
import org.opentripplanner.street.model.edge.LinkingDirection;
import org.opentripplanner.street.model.edge.StreetStationCentroidLink;
import org.opentripplanner.street.model.edge.StreetTransitEntranceLink;
import org.opentripplanner.street.model.edge.StreetTransitStopLink;
import org.opentripplanner.street.model.edge.StreetVehicleParkingLink;
import org.opentripplanner.street.model.edge.VehicleParkingEdge;
import org.opentripplanner.street.model.vertex.StationCentroidVertex;
import org.opentripplanner.street.model.vertex.StreetVertex;
import org.opentripplanner.street.model.vertex.TransitEntranceVertex;
import org.opentripplanner.street.model.vertex.TransitStopVertex;
import org.opentripplanner.street.model.vertex.VehicleParkingEntranceVertex;
import org.opentripplanner.street.model.vertex.Vertex;
import org.opentripplanner.street.search.TraverseMode;
import org.opentripplanner.street.search.TraverseModeSet;
import org.opentripplanner.transit.model.site.GroupStop;
import org.opentripplanner.transit.model.site.RegularStop;
import org.opentripplanner.transit.model.site.StopLocation;
import org.opentripplanner.transit.service.TimetableRepository;
import org.opentripplanner.utils.logging.ProgressTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreetLinkerModule
implements GraphBuilderModule {
    private static final Logger LOG = LoggerFactory.getLogger(StreetLinkerModule.class);
    private static final TraverseModeSet CAR_ONLY = new TraverseModeSet(TraverseMode.CAR);
    private static final TraverseModeSet WALK_ONLY = new TraverseModeSet(TraverseMode.WALK);
    private final Graph graph;
    private final VehicleParkingRepository parkingRepository;
    private final TimetableRepository timetableRepository;
    private final DataImportIssueStore issueStore;
    private final VertexLinker vertexLinker;

    public StreetLinkerModule(Graph graph, VertexLinker linker, VehicleParkingRepository parkingRepository, TimetableRepository timetableRepository, DataImportIssueStore issueStore) {
        this.graph = graph;
        this.parkingRepository = parkingRepository;
        this.timetableRepository = timetableRepository;
        this.issueStore = issueStore;
        this.vertexLinker = linker;
    }

    @Override
    public void buildGraph() {
        this.timetableRepository.index();
        this.graph.requestIndex();
        if (this.graph.hasStreets) {
            this.linkTransitStops(this.graph, this.timetableRepository);
            this.linkTransitEntrances(this.graph);
            this.linkStationCentroids(this.graph);
            this.linkVehicleParks(this.graph, this.issueStore);
        }
        this.graph.calculateConvexHull();
    }

    public void linkTransitStops(Graph graph, TimetableRepository timetableRepository) {
        List<TransitStopVertex> vertices = graph.getVerticesOfType(TransitStopVertex.class);
        ProgressTracker progress = ProgressTracker.track((String)"Linking transit stops to graph", (int)5000, (long)vertices.size());
        LOG.info(progress.startMessage());
        Set<StopLocation> stopLocationsUsedForFlexTrips = Set.of();
        if (OTPFeature.FlexRouting.isOn()) {
            stopLocationsUsedForFlexTrips = this.getStopLocationsUsedForFlexTrips(timetableRepository);
        }
        Set<StopLocation> stopLocationsUsedForCarsAllowedTrips = timetableRepository.getStopLocationsUsedForCarsAllowedTrips();
        for (TransitStopVertex tStop : vertices) {
            if (tStop.hasPathways() || StreetLinkerModule.isAlreadyLinked(tStop, stopLocationsUsedForFlexTrips)) continue;
            StopLinkType linkType = StopLinkType.WALK_ONLY;
            if (OTPFeature.FlexRouting.isOn() && stopLocationsUsedForFlexTrips.contains(tStop.getStop()) || stopLocationsUsedForCarsAllowedTrips.contains(tStop.getStop())) {
                linkType = StopLinkType.WALK_AND_CAR;
            }
            this.linkStopToStreetNetwork(tStop, linkType);
            progress.step(m -> LOG.info(m));
        }
        LOG.info(progress.completeMessage());
    }

    private static boolean isAlreadyLinked(TransitStopVertex stopVertex, Set<StopLocation> stopLocationsUsedForFlexTrips) {
        if (stopLocationsUsedForFlexTrips.contains(stopVertex.getStop())) {
            return stopVertex.isLinkedToDrivableEdge() && stopVertex.isLinkedToWalkableEdge();
        }
        return stopVertex.isConnectedToGraph();
    }

    private void linkStopToStreetNetwork(TransitStopVertex tStop, StopLinkType linkType) {
        this.vertexLinker.linkVertexPermanently(tStop, WALK_ONLY, LinkingDirection.BIDIRECTIONAL, (transitVertex, streetVertex) -> {
            List<Edge> linkEdges = StreetLinkerModule.createStopLinkEdges((TransitStopVertex)transitVertex, streetVertex);
            if (linkType == StopLinkType.WALK_AND_CAR && !streetVertex.isConnectedToDriveableEdge()) {
                this.linkToDriveableEdge(tStop);
            }
            return linkEdges;
        });
    }

    private void linkToDriveableEdge(TransitStopVertex tStop) {
        this.vertexLinker.linkVertexPermanently(tStop, CAR_ONLY, LinkingDirection.BIDIRECTIONAL, (transitVertex, streetVertex) -> StreetLinkerModule.createStopLinkEdges((TransitStopVertex)transitVertex, streetVertex));
    }

    private static List<Edge> createStopLinkEdges(TransitStopVertex vertex, StreetVertex streetVertex) {
        return List.of(StreetTransitStopLink.createStreetTransitStopLink(vertex, streetVertex), StreetTransitStopLink.createStreetTransitStopLink(streetVertex, vertex));
    }

    private void linkVehicleParkingWithLinker(VehicleParkingEntranceVertex vehicleParkingVertex) {
        if (vehicleParkingVertex.isWalkAccessible()) {
            this.vertexLinker.linkVertexPermanently(vehicleParkingVertex, new TraverseModeSet(TraverseMode.WALK), LinkingDirection.BIDIRECTIONAL, (vertex, streetVertex) -> List.of(StreetVehicleParkingLink.createStreetVehicleParkingLink((VehicleParkingEntranceVertex)vertex, streetVertex), StreetVehicleParkingLink.createStreetVehicleParkingLink(streetVertex, (VehicleParkingEntranceVertex)vertex)));
        }
        if (vehicleParkingVertex.isCarAccessible()) {
            this.vertexLinker.linkVertexPermanently(vehicleParkingVertex, new TraverseModeSet(TraverseMode.CAR), LinkingDirection.BIDIRECTIONAL, (vertex, streetVertex) -> List.of(StreetVehicleParkingLink.createStreetVehicleParkingLink((VehicleParkingEntranceVertex)vertex, streetVertex), StreetVehicleParkingLink.createStreetVehicleParkingLink(streetVertex, (VehicleParkingEntranceVertex)vertex)));
        }
    }

    private void linkTransitEntrances(Graph graph) {
        LOG.info("Linking transit entrances to graph...");
        for (TransitEntranceVertex tEntrance : graph.getVerticesOfType(TransitEntranceVertex.class)) {
            this.vertexLinker.linkVertexPermanently(tEntrance, new TraverseModeSet(TraverseMode.WALK), LinkingDirection.BIDIRECTIONAL, (vertex, streetVertex) -> List.of(StreetTransitEntranceLink.createStreetTransitEntranceLink((TransitEntranceVertex)vertex, streetVertex), StreetTransitEntranceLink.createStreetTransitEntranceLink(streetVertex, (TransitEntranceVertex)vertex)));
        }
    }

    private void linkStationCentroids(Graph graph) {
        BiFunction<Vertex, StreetVertex, List<Edge>> stationAndStreetVertexLinker = (theStation, streetVertex) -> List.of(StreetStationCentroidLink.createStreetStationLink((StationCentroidVertex)theStation, streetVertex), StreetStationCentroidLink.createStreetStationLink(streetVertex, (StationCentroidVertex)theStation));
        for (StationCentroidVertex station : graph.getVerticesOfType(StationCentroidVertex.class)) {
            this.vertexLinker.linkVertexPermanently(station, new TraverseModeSet(TraverseMode.WALK), LinkingDirection.BIDIRECTIONAL, stationAndStreetVertexLinker);
        }
    }

    private void linkVehicleParks(Graph graph, DataImportIssueStore issueStore) {
        LOG.info("Linking vehicle parks to graph...");
        ArrayList<VehicleParking> vehicleParkingToRemove = new ArrayList<VehicleParking>();
        for (VehicleParkingEntranceVertex vehicleParkingEntranceVertex : graph.getVerticesOfType(VehicleParkingEntranceVertex.class)) {
            if (vehicleParkingEntranceVertex.isLinkedToGraph()) continue;
            if (vehicleParkingEntranceVertex.getParkingEntrance().getVertex() == null) {
                this.linkVehicleParkingWithLinker(vehicleParkingEntranceVertex);
                continue;
            }
            if (graph.containsVertex(vehicleParkingEntranceVertex.getParkingEntrance().getVertex())) {
                VehicleParkingHelper.linkToGraph(vehicleParkingEntranceVertex);
                continue;
            }
            issueStore.add(new ParkAndRideEntranceRemoved(vehicleParkingEntranceVertex.getParkingEntrance()));
            VehicleParking vehicleParking = this.removeVehicleParkingEntranceVertexFromGraph(vehicleParkingEntranceVertex, graph);
            if (vehicleParking == null) continue;
            vehicleParkingToRemove.add(vehicleParking);
        }
        if (!vehicleParkingToRemove.isEmpty()) {
            this.parkingRepository.updateVehicleParking(List.of(), vehicleParkingToRemove);
        }
    }

    private VehicleParking removeVehicleParkingEntranceVertexFromGraph(VehicleParkingEntranceVertex vehicleParkingEntranceVertex, Graph graph) {
        VehicleParkingEdge vehicleParkingEdge = vehicleParkingEntranceVertex.getOutgoing().stream().filter(VehicleParkingEdge.class::isInstance).map(VehicleParkingEdge.class::cast).findFirst().orElseThrow(() -> new IllegalStateException("VehicleParkingEdge missing from vertex: " + String.valueOf(vehicleParkingEntranceVertex)));
        VehicleParkingEntrance entrance = vehicleParkingEntranceVertex.getParkingEntrance();
        VehicleParking vehicleParking = vehicleParkingEdge.getVehicleParking();
        boolean removeVehicleParking = vehicleParking.getEntrances().size() == 1 && vehicleParking.getEntrances().get(0).equals(entrance);
        vehicleParkingEntranceVertex.getIncoming().forEach(graph::removeEdge);
        vehicleParkingEntranceVertex.getOutgoing().forEach(graph::removeEdge);
        graph.remove(vehicleParkingEntranceVertex);
        if (removeVehicleParking) {
            return vehicleParking;
        }
        vehicleParking.getEntrances().remove(entrance);
        return null;
    }

    private Set<StopLocation> getStopLocationsUsedForFlexTrips(TimetableRepository timetableRepository) {
        Set<StopLocation> stopLocations = timetableRepository.getAllFlexTrips().stream().flatMap(t -> t.getStops().stream()).collect(Collectors.toSet());
        stopLocations.addAll(stopLocations.stream().filter(GroupStop.class::isInstance).map(GroupStop.class::cast).flatMap(g -> g.getChildLocations().stream().filter(RegularStop.class::isInstance)).toList());
        return stopLocations;
    }

    private static enum StopLinkType {
        WALK_ONLY,
        WALK_AND_CAR;

    }
}

