/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.graph_builder.module;

import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.opentripplanner.framework.geometry.GeometryUtils;
import org.opentripplanner.framework.geometry.SphericalDistanceLibrary;
import org.opentripplanner.framework.i18n.I18NString;
import org.opentripplanner.framework.i18n.LocalizedString;
import org.opentripplanner.graph_builder.model.GraphBuilderModule;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.routing.linking.VertexLinker;
import org.opentripplanner.service.osminfo.OsmInfoGraphBuildService;
import org.opentripplanner.service.osminfo.model.Platform;
import org.opentripplanner.street.model.StreetTraversalPermission;
import org.opentripplanner.street.model.edge.Area;
import org.opentripplanner.street.model.edge.AreaEdge;
import org.opentripplanner.street.model.edge.AreaGroup;
import org.opentripplanner.street.model.edge.BoardingLocationToStopLink;
import org.opentripplanner.street.model.edge.Edge;
import org.opentripplanner.street.model.edge.LinkingDirection;
import org.opentripplanner.street.model.edge.StreetEdge;
import org.opentripplanner.street.model.edge.StreetEdgeBuilder;
import org.opentripplanner.street.model.edge.StreetTransitStopLink;
import org.opentripplanner.street.model.vertex.OsmBoardingLocationVertex;
import org.opentripplanner.street.model.vertex.StreetVertex;
import org.opentripplanner.street.model.vertex.TransitStopVertex;
import org.opentripplanner.street.model.vertex.Vertex;
import org.opentripplanner.street.model.vertex.VertexFactory;
import org.opentripplanner.street.search.TraverseMode;
import org.opentripplanner.street.search.TraverseModeSet;
import org.opentripplanner.transit.model.site.RegularStop;
import org.opentripplanner.transit.model.site.StationElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OsmBoardingLocationsModule
implements GraphBuilderModule {
    private static final Logger LOG = LoggerFactory.getLogger(OsmBoardingLocationsModule.class);
    private static final LocalizedString LOCALIZED_PLATFORM_NAME = new LocalizedString("name.platform");
    private final double searchRadiusDegrees = SphericalDistanceLibrary.metersToDegrees(250.0);
    private final Graph graph;
    private final OsmInfoGraphBuildService osmInfoGraphBuildService;
    private final VertexFactory vertexFactory;
    private VertexLinker linker;

    @Inject
    public OsmBoardingLocationsModule(Graph graph, VertexLinker linker, OsmInfoGraphBuildService osmInfoGraphBuildService) {
        this.graph = graph;
        this.osmInfoGraphBuildService = osmInfoGraphBuildService;
        this.vertexFactory = new VertexFactory(graph);
        this.linker = linker;
    }

    @Override
    public void buildGraph() {
        LOG.info("Improving boarding locations by checking OSM entities...");
        this.graph.index();
        int successes = 0;
        for (TransitStopVertex ts : this.graph.getVerticesOfType(TransitStopVertex.class)) {
            boolean alreadyLinked = false;
            for (Edge e : ts.getOutgoing()) {
                if (!(e instanceof StreetTransitStopLink)) continue;
                alreadyLinked = true;
                break;
            }
            if (alreadyLinked || ts.hasPathways()) continue;
            if (!this.connectVertexToStop(ts, this.graph)) {
                LOG.debug("Could not connect {} at {}", (Object)ts.getStop().getCode(), (Object)ts.getCoordinate());
                continue;
            }
            ++successes;
        }
        LOG.info("Found {} OSM references which match a stop's id or code", (Object)successes);
    }

    private boolean connectVertexToStop(TransitStopVertex ts, Graph index) {
        if (this.connectVertexToNode(ts, index)) {
            return true;
        }
        if (this.connectVertexToWay(ts, index)) {
            return true;
        }
        return this.connectVertexToArea(ts, index);
    }

    private Envelope getEnvelope(TransitStopVertex ts) {
        Envelope envelope = new Envelope(ts.getCoordinate());
        double xscale = Math.cos(ts.getCoordinate().y * Math.PI / 180.0);
        envelope.expandBy(this.searchRadiusDegrees / xscale, this.searchRadiusDegrees);
        return envelope;
    }

    private boolean connectVertexToArea(TransitStopVertex ts, Graph graph) {
        RegularStop stop = ts.getStop();
        Set nearbyAreaGroups = graph.findEdges(this.getEnvelope(ts)).stream().filter(AreaEdge.class::isInstance).map(AreaEdge.class::cast).map(AreaEdge::getArea).collect(Collectors.toSet());
        for (AreaGroup areaGroup : nearbyAreaGroups) {
            for (Area area : areaGroup.getAreas()) {
                Platform platform;
                Optional<Platform> platOpt = this.osmInfoGraphBuildService.findPlatform(area);
                if (!platOpt.isPresent() || !this.matchesReference(stop, (platform = platOpt.get()).references())) continue;
                OsmBoardingLocationVertex boardingLocation = this.makeBoardingLocation(stop, platform.geometry().getCentroid(), platform.references(), area.getName());
                this.linker.addPermanentAreaVertex(boardingLocation, areaGroup);
                this.linkBoardingLocationToStop(ts, stop.getCode(), boardingLocation);
                return true;
            }
        }
        return false;
    }

    private boolean connectVertexToWay(TransitStopVertex ts, Graph graph) {
        RegularStop stop = ts.getStop();
        HashMap nearbyEdges = new HashMap();
        for (Edge edge : graph.findEdges(this.getEnvelope(ts))) {
            this.osmInfoGraphBuildService.findPlatform(edge).ifPresent(platform -> {
                if (this.matchesReference(stop, platform.references())) {
                    if (!nearbyEdges.containsKey(platform)) {
                        ArrayList<Edge> list = new ArrayList<Edge>();
                        list.add(edge);
                        nearbyEdges.put(platform, list);
                    } else {
                        ((List)nearbyEdges.get(platform)).add(edge);
                    }
                }
            });
        }
        Iterator<Object> iterator = nearbyEdges.entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry platformEdgeList = (Map.Entry)iterator.next();
            Platform platform2 = (Platform)platformEdgeList.getKey();
            I18NString name = platform2.name();
            OsmBoardingLocationVertex boardingLocation = this.makeBoardingLocation(stop, platform2.geometry().getCentroid(), platform2.references(), name);
            for (StreetVertex vertex : this.linker.linkToSpecificStreetEdgesPermanently(boardingLocation, new TraverseModeSet(TraverseMode.WALK), LinkingDirection.BIDIRECTIONAL, ((List)platformEdgeList.getValue()).stream().map(StreetEdge.class::cast).collect(Collectors.toSet()))) {
                this.linkBoardingLocationToStop(ts, stop.getCode(), vertex);
            }
            return true;
        }
        return false;
    }

    private boolean connectVertexToNode(TransitStopVertex ts, Graph graph) {
        Set nearbyBoardingLocations = graph.findVertices(this.getEnvelope(ts)).stream().filter(OsmBoardingLocationVertex.class::isInstance).map(OsmBoardingLocationVertex.class::cast).collect(Collectors.toSet());
        for (OsmBoardingLocationVertex boardingLocation : nearbyBoardingLocations) {
            if (!this.matchesReference(ts.getStop(), boardingLocation.references)) continue;
            if (!boardingLocation.isConnectedToStreetNetwork()) {
                this.linker.linkVertexPermanently(boardingLocation, new TraverseModeSet(TraverseMode.WALK), LinkingDirection.BIDIRECTIONAL, (osmBoardingLocationVertex, splitVertex) -> this.getConnectingEdges(boardingLocation, (Vertex)osmBoardingLocationVertex, (StreetVertex)splitVertex));
            }
            this.linkBoardingLocationToStop(ts, ts.getStop().getCode(), boardingLocation);
            return true;
        }
        return false;
    }

    private OsmBoardingLocationVertex makeBoardingLocation(RegularStop stop, Point centroid, Set<String> refs, I18NString name) {
        String label = "platform-centroid/%s".formatted(stop.getId().toString());
        return this.vertexFactory.osmBoardingLocation(new Coordinate(centroid.getX(), centroid.getY()), label, refs, name);
    }

    private List<Edge> getConnectingEdges(OsmBoardingLocationVertex boardingLocation, Vertex osmBoardingLocationVertex, StreetVertex splitVertex) {
        if (osmBoardingLocationVertex == splitVertex) {
            return List.of();
        }
        return List.of(this.linkBoardingLocationToStreetNetwork(boardingLocation, splitVertex), this.linkBoardingLocationToStreetNetwork(splitVertex, boardingLocation));
    }

    private StreetEdge linkBoardingLocationToStreetNetwork(StreetVertex from, StreetVertex to) {
        LineString line = GeometryUtils.makeLineString(List.of(from.getCoordinate(), to.getCoordinate()));
        return ((StreetEdgeBuilder)((StreetEdgeBuilder)((StreetEdgeBuilder)((StreetEdgeBuilder)((StreetEdgeBuilder)((StreetEdgeBuilder)((StreetEdgeBuilder)new StreetEdgeBuilder().withFromVertex(from)).withToVertex(to)).withGeometry(line)).withName(LOCALIZED_PLATFORM_NAME)).withMeterLength(SphericalDistanceLibrary.length(line))).withPermission(StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE)).withBack(false)).buildAndConnect();
    }

    private void linkBoardingLocationToStop(TransitStopVertex ts, @Nullable String stopCode, StreetVertex boardingLocation) {
        BoardingLocationToStopLink.createBoardingLocationToStopLink(ts, boardingLocation);
        BoardingLocationToStopLink.createBoardingLocationToStopLink(boardingLocation, ts);
        LOG.debug("Connected {} ({}) to {} at {}", new Object[]{ts, stopCode, boardingLocation.getLabel(), boardingLocation.getCoordinate()});
    }

    private boolean matchesReference(StationElement<?, ?> stop, Collection<String> references) {
        String stopCode = stop.getCode();
        String stopId = stop.getId().getId();
        return stopCode != null && references.contains(stopCode) || references.contains(stopId);
    }
}

