/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.graph_builder.module;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import org.opentripplanner.framework.application.OTPFeature;
import org.opentripplanner.graph_builder.issue.api.DataImportIssueStore;
import org.opentripplanner.graph_builder.issues.StopNotLinkedForTransfers;
import org.opentripplanner.graph_builder.model.GraphBuilderModule;
import org.opentripplanner.graph_builder.module.TransferParameters;
import org.opentripplanner.graph_builder.module.nearbystops.NearbyStopFinder;
import org.opentripplanner.graph_builder.module.nearbystops.PatternConsideringNearbyStopFinder;
import org.opentripplanner.graph_builder.module.nearbystops.StraightLineNearbyStopFinder;
import org.opentripplanner.graph_builder.module.nearbystops.StreetNearbyStopFinder;
import org.opentripplanner.model.PathTransfer;
import org.opentripplanner.routing.api.request.RouteRequest;
import org.opentripplanner.routing.api.request.StreetMode;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.routing.graphfinder.NearbyStop;
import org.opentripplanner.street.model.edge.Edge;
import org.opentripplanner.street.model.vertex.TransitStopVertex;
import org.opentripplanner.transit.model.site.RegularStop;
import org.opentripplanner.transit.model.site.StopLocation;
import org.opentripplanner.transit.service.DefaultTransitService;
import org.opentripplanner.transit.service.TimetableRepository;
import org.opentripplanner.utils.logging.ProgressTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectTransferGenerator
implements GraphBuilderModule {
    private static final Logger LOG = LoggerFactory.getLogger(DirectTransferGenerator.class);
    private final Duration defaultMaxTransferDuration;
    private final List<RouteRequest> transferRequests;
    private final Map<StreetMode, TransferParameters> transferParametersForMode;
    private final Graph graph;
    private final TimetableRepository timetableRepository;
    private final DataImportIssueStore issueStore;

    public DirectTransferGenerator(Graph graph, TimetableRepository timetableRepository, DataImportIssueStore issueStore, Duration defaultMaxTransferDuration, List<RouteRequest> transferRequests) {
        this.graph = graph;
        this.timetableRepository = timetableRepository;
        this.issueStore = issueStore;
        this.defaultMaxTransferDuration = defaultMaxTransferDuration;
        this.transferRequests = transferRequests;
        this.transferParametersForMode = Map.of();
    }

    public DirectTransferGenerator(Graph graph, TimetableRepository timetableRepository, DataImportIssueStore issueStore, Duration defaultMaxTransferDuration, List<RouteRequest> transferRequests, Map<StreetMode, TransferParameters> transferParametersForMode) {
        this.graph = graph;
        this.timetableRepository = timetableRepository;
        this.issueStore = issueStore;
        this.defaultMaxTransferDuration = defaultMaxTransferDuration;
        this.transferRequests = transferRequests;
        this.transferParametersForMode = transferParametersForMode;
    }

    @Override
    public void buildGraph() {
        this.timetableRepository.index();
        NearbyStopFinder nearbyStopFinder = this.createNearbyStopFinder(this.defaultMaxTransferDuration);
        List<TransitStopVertex> stops = this.graph.getVerticesOfType(TransitStopVertex.class);
        Set<StopLocation> carsAllowedStops = this.timetableRepository.getStopLocationsUsedForCarsAllowedTrips();
        LOG.info("Creating transfers based on requests:");
        this.transferRequests.forEach(transferProfile -> LOG.info(transferProfile.toString()));
        if (this.transferParametersForMode.isEmpty()) {
            LOG.info("No mode-specific transfer configurations provided.");
        } else {
            LOG.info("Using transfer configurations for modes:");
            this.transferParametersForMode.forEach((mode, transferParameters) -> LOG.info(String.valueOf(mode) + ": " + String.valueOf(transferParameters)));
        }
        ProgressTracker progress = ProgressTracker.track((String)"Create transfer edges for stops", (int)1000, (long)stops.size());
        AtomicInteger nTransfersTotal = new AtomicInteger();
        AtomicInteger nLinkedStops = new AtomicInteger();
        Multimap transfersByStop = Multimaps.synchronizedMultimap((Multimap)HashMultimap.create());
        TransferConfiguration transferConfiguration = this.parseTransferParameters(nearbyStopFinder);
        ((Stream)stops.stream().parallel()).forEach(ts0 -> {
            HashMap<TransferKey, PathTransfer> distinctTransfers = new HashMap<TransferKey, PathTransfer>();
            RegularStop stop = ts0.getStop();
            if (stop.transfersNotAllowed()) {
                return;
            }
            LOG.debug("Linking stop '{}' {}", (Object)stop, ts0);
            this.calculateDefaultTransfers(transferConfiguration, (TransitStopVertex)ts0, stop, (Map<TransferKey, PathTransfer>)distinctTransfers);
            this.calculateFlexTransfers(transferConfiguration, (TransitStopVertex)ts0, stop, (Map<TransferKey, PathTransfer>)distinctTransfers);
            this.calculateCarsAllowedTransfers(transferConfiguration, (TransitStopVertex)ts0, stop, (Map<TransferKey, PathTransfer>)distinctTransfers, carsAllowedStops);
            LOG.debug("Linked stop {} with {} transfers to stops with different patterns.", (Object)stop, (Object)distinctTransfers.size());
            if (distinctTransfers.isEmpty()) {
                this.issueStore.add(new StopNotLinkedForTransfers((TransitStopVertex)ts0));
            } else {
                distinctTransfers.values().forEach(transfer -> transfersByStop.put((Object)transfer.from, transfer));
                nLinkedStops.incrementAndGet();
                nTransfersTotal.addAndGet(distinctTransfers.size());
            }
            progress.step(m -> LOG.info(m));
        });
        this.timetableRepository.addAllTransfersByStops((Multimap<StopLocation, PathTransfer>)transfersByStop);
        LOG.info(progress.completeMessage());
        LOG.info("Done connecting stops to one another. Created a total of {} transfers from {} stops.", (Object)nTransfersTotal, (Object)nLinkedStops);
        this.transferRequests.stream().map(transferProfile -> transferProfile.journey().transfer().mode()).distinct().forEach(mode -> LOG.info("Created {} transfers for mode {}.", (Object)this.timetableRepository.findTransfers((StreetMode)mode).size(), mode));
    }

    private NearbyStopFinder createNearbyStopFinder(Duration radiusAsDuration) {
        NearbyStopFinder finder;
        DefaultTransitService transitService = new DefaultTransitService(this.timetableRepository);
        if (!this.graph.hasStreets) {
            LOG.info("Creating direct transfer edges between stops using straight line distance (not streets)...");
            finder = new StraightLineNearbyStopFinder(transitService, radiusAsDuration);
        } else {
            LOG.info("Creating direct transfer edges between stops using the street network from OSM...");
            finder = new StreetNearbyStopFinder(radiusAsDuration, 0, null);
        }
        if (OTPFeature.ConsiderPatternsForDirectTransfers.isOn()) {
            return new PatternConsideringNearbyStopFinder(transitService, finder);
        }
        return finder;
    }

    private void createPathTransfer(StopLocation from, StopLocation to, NearbyStop sd, Map<TransferKey, PathTransfer> distinctTransfers, StreetMode mode) {
        TransferKey transferKey = new TransferKey(from, to, sd.edges);
        PathTransfer pathTransfer = distinctTransfers.get(transferKey);
        if (pathTransfer == null) {
            distinctTransfers.put(transferKey, new PathTransfer(from, to, sd.distance, sd.edges, EnumSet.of(mode)));
        } else {
            distinctTransfers.put(transferKey, pathTransfer.withAddedMode(mode));
        }
    }

    private TransferConfiguration parseTransferParameters(NearbyStopFinder nearbyStopFinder) {
        ArrayList<RouteRequest> defaultTransferRequests = new ArrayList<RouteRequest>();
        ArrayList<RouteRequest> carsAllowedStopTransferRequests = new ArrayList<RouteRequest>();
        ArrayList<RouteRequest> flexTransferRequests = new ArrayList<RouteRequest>();
        HashMap<StreetMode, NearbyStopFinder> defaultNearbyStopFinderForMode = new HashMap<StreetMode, NearbyStopFinder>();
        HashMap<StreetMode, NearbyStopFinder> carsAllowedStopNearbyStopFinderForMode = new HashMap<StreetMode, NearbyStopFinder>();
        for (StreetMode mode : this.transferParametersForMode.keySet()) {
            if (this.transferRequests.stream().anyMatch(transferProfile -> transferProfile.journey().transfer().mode() == mode)) continue;
            throw new IllegalArgumentException(String.format("Mode %s is used in transferParametersForMode but not in transferRequests", mode));
        }
        for (RouteRequest transferProfile2 : this.transferRequests) {
            StreetMode mode = transferProfile2.journey().transfer().mode();
            TransferParameters transferParameters = this.transferParametersForMode.get(mode);
            if (transferParameters != null) {
                Duration carsAllowedStopMaxTransferDuration;
                if (transferParameters.disableDefaultTransfers() && mode == StreetMode.WALK) {
                    throw new IllegalArgumentException("WALK mode transfers can not be disabled");
                }
                if (!transferParameters.disableDefaultTransfers()) {
                    defaultTransferRequests.add(transferProfile2);
                    Duration maxTransferDuration = transferParameters.maxTransferDuration();
                    if (maxTransferDuration != null) {
                        defaultNearbyStopFinderForMode.put(mode, this.createNearbyStopFinder(maxTransferDuration));
                    } else {
                        defaultNearbyStopFinderForMode.put(mode, nearbyStopFinder);
                    }
                }
                if ((carsAllowedStopMaxTransferDuration = transferParameters.carsAllowedStopMaxTransferDuration()) == null) continue;
                carsAllowedStopTransferRequests.add(transferProfile2);
                carsAllowedStopNearbyStopFinderForMode.put(mode, this.createNearbyStopFinder(carsAllowedStopMaxTransferDuration));
                continue;
            }
            defaultTransferRequests.add(transferProfile2);
            defaultNearbyStopFinderForMode.put(mode, nearbyStopFinder);
        }
        if (OTPFeature.FlexRouting.isOn()) {
            flexTransferRequests.addAll(this.transferRequests.stream().filter(transferProfile -> transferProfile.journey().transfer().mode() == StreetMode.WALK).toList());
        }
        return new TransferConfiguration(defaultTransferRequests, carsAllowedStopTransferRequests, flexTransferRequests, defaultNearbyStopFinderForMode, carsAllowedStopNearbyStopFinderForMode);
    }

    private void calculateDefaultTransfers(TransferConfiguration transferConfiguration, TransitStopVertex ts0, RegularStop stop, Map<TransferKey, PathTransfer> distinctTransfers) {
        for (RouteRequest transferProfile : transferConfiguration.defaultTransferRequests()) {
            StreetMode mode = transferProfile.journey().transfer().mode();
            Collection<NearbyStop> nearbyStops = transferConfiguration.defaultNearbyStopFinderForMode().get(mode).findNearbyStops(ts0, transferProfile, transferProfile.journey().transfer(), false);
            for (NearbyStop sd : nearbyStops) {
                if (sd.stop == stop || sd.stop.transfersNotAllowed()) continue;
                this.createPathTransfer(stop, sd.stop, sd, distinctTransfers, mode);
            }
        }
    }

    private void calculateFlexTransfers(TransferConfiguration transferConfiguration, TransitStopVertex ts0, RegularStop stop, Map<TransferKey, PathTransfer> distinctTransfers) {
        for (RouteRequest transferProfile : transferConfiguration.flexTransferRequests()) {
            StreetMode mode = StreetMode.WALK;
            Collection<NearbyStop> nearbyStops = transferConfiguration.defaultNearbyStopFinderForMode().get(mode).findNearbyStops(ts0, transferProfile, transferProfile.journey().transfer(), true);
            for (NearbyStop sd : nearbyStops) {
                if (sd.stop == stop || sd.stop instanceof RegularStop) continue;
                this.createPathTransfer(sd.stop, stop, sd, distinctTransfers, mode);
            }
        }
    }

    private void calculateCarsAllowedTransfers(TransferConfiguration transferConfiguration, TransitStopVertex ts0, RegularStop stop, Map<TransferKey, PathTransfer> distinctTransfers, Set<StopLocation> carsAllowedStops) {
        if (carsAllowedStops.contains(stop)) {
            for (RouteRequest transferProfile : transferConfiguration.carsAllowedStopTransferRequests()) {
                StreetMode mode = transferProfile.journey().transfer().mode();
                Collection<NearbyStop> nearbyStops = transferConfiguration.carsAllowedStopNearbyStopFinderForMode().get(mode).findNearbyStops(ts0, transferProfile, transferProfile.journey().transfer(), false);
                for (NearbyStop sd : nearbyStops) {
                    if (sd.stop == stop || sd.stop.transfersNotAllowed() || !carsAllowedStops.contains(sd.stop)) continue;
                    this.createPathTransfer(stop, sd.stop, sd, distinctTransfers, mode);
                }
            }
        }
    }

    private record TransferConfiguration(List<RouteRequest> defaultTransferRequests, List<RouteRequest> carsAllowedStopTransferRequests, List<RouteRequest> flexTransferRequests, HashMap<StreetMode, NearbyStopFinder> defaultNearbyStopFinderForMode, HashMap<StreetMode, NearbyStopFinder> carsAllowedStopNearbyStopFinderForMode) {
    }

    private record TransferKey(StopLocation source, StopLocation target, List<Edge> edges) {
    }
}

