/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.graph_builder.module;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.opentripplanner.ext.flex.trip.FlexTrip;
import org.opentripplanner.framework.application.OTPFeature;
import org.opentripplanner.framework.geometry.SphericalDistanceLibrary;
import org.opentripplanner.framework.i18n.I18NString;
import org.opentripplanner.framework.i18n.NonLocalizedString;
import org.opentripplanner.model.FeedInfo;
import org.opentripplanner.model.OtpTransitService;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.street.model.StreetTraversalPermission;
import org.opentripplanner.street.model.edge.ElevatorAlightEdge;
import org.opentripplanner.street.model.edge.ElevatorBoardEdge;
import org.opentripplanner.street.model.edge.ElevatorHopEdge;
import org.opentripplanner.street.model.edge.PathwayEdge;
import org.opentripplanner.street.model.vertex.ElevatorVertex;
import org.opentripplanner.street.model.vertex.StationElementVertex;
import org.opentripplanner.street.model.vertex.TransitBoardingAreaVertex;
import org.opentripplanner.street.model.vertex.TransitEntranceVertex;
import org.opentripplanner.street.model.vertex.TransitPathwayNodeVertex;
import org.opentripplanner.street.model.vertex.TransitStopVertex;
import org.opentripplanner.street.model.vertex.VertexFactory;
import org.opentripplanner.transit.model.basic.Accessibility;
import org.opentripplanner.transit.model.basic.TransitMode;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.network.TripPattern;
import org.opentripplanner.transit.model.organization.Agency;
import org.opentripplanner.transit.model.site.BoardingArea;
import org.opentripplanner.transit.model.site.Entrance;
import org.opentripplanner.transit.model.site.Pathway;
import org.opentripplanner.transit.model.site.PathwayMode;
import org.opentripplanner.transit.model.site.PathwayNode;
import org.opentripplanner.transit.model.site.RegularStop;
import org.opentripplanner.transit.model.site.Station;
import org.opentripplanner.transit.model.site.StationElement;
import org.opentripplanner.transit.model.site.StopLocation;
import org.opentripplanner.transit.service.TimetableRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddTransitEntitiesToGraph {
    private static final Logger LOG = LoggerFactory.getLogger(AddTransitEntitiesToGraph.class);
    private final OtpTransitService otpTransitService;
    private final Map<StationElement<?, ?>, StationElementVertex> stationElementNodes = new HashMap();
    private final int subwayAccessTime;
    private final VertexFactory vertexFactory;

    private AddTransitEntitiesToGraph(OtpTransitService otpTransitService, int subwayAccessTime, Graph graph) {
        this.otpTransitService = otpTransitService;
        this.subwayAccessTime = Math.max(subwayAccessTime, 0);
        this.vertexFactory = new VertexFactory(graph);
    }

    public static void addToGraph(OtpTransitService otpTransitService, int subwayAccessTime, Graph graph, TimetableRepository timetableRepository) {
        new AddTransitEntitiesToGraph(otpTransitService, subwayAccessTime, graph).applyToGraph(timetableRepository);
    }

    private void applyToGraph(TimetableRepository timetableRepository) {
        timetableRepository.mergeSiteRepositories(this.otpTransitService.siteRepository());
        this.addStopsToGraphAndGenerateStopVertexes(timetableRepository);
        this.addEntrancesToGraph();
        this.addStationCentroidsToGraph();
        this.addPathwayNodesToGraph();
        this.addBoardingAreasToGraph();
        this.createPathwayEdgesAndAddThemToGraph();
        this.addFeedInfoToGraph(timetableRepository);
        this.addAgenciesToGraph(timetableRepository);
        this.addServicesToTimetableRepository(timetableRepository);
        this.addTripPatternsToTimetableRepository(timetableRepository);
        this.addTransfersToGraph(timetableRepository);
        if (OTPFeature.FlexRouting.isOn()) {
            this.addFlexTripsToGraph(timetableRepository);
        }
    }

    private void addStopsToGraphAndGenerateStopVertexes(TimetableRepository timetableRepository) {
        HashMap<StopLocation, Set> stopModeMap = new HashMap<StopLocation, Set>();
        for (TripPattern pattern : this.otpTransitService.getTripPatterns()) {
            TransitMode mode = pattern.getMode();
            for (StopLocation stop : pattern.getStops()) {
                Set set = stopModeMap.computeIfAbsent(stop, s -> new HashSet());
                set.add(mode);
            }
        }
        for (RegularStop stop : this.otpTransitService.siteRepository().listRegularStops()) {
            Set modes = (Set)stopModeMap.get(stop);
            TransitStopVertex stopVertex = this.vertexFactory.transitStop(TransitStopVertex.of().withStop(stop).withModes(modes));
            if (modes != null && modes.contains(TransitMode.SUBWAY)) {
                stopVertex.setStreetToStopTime(this.subwayAccessTime);
            }
            this.stationElementNodes.put(stop, stopVertex);
        }
    }

    private void addEntrancesToGraph() {
        for (Entrance entrance : this.otpTransitService.getAllEntrances()) {
            TransitEntranceVertex entranceVertex = this.vertexFactory.transitEntrance(entrance);
            this.stationElementNodes.put(entrance, entranceVertex);
        }
    }

    private void addStationCentroidsToGraph() {
        for (Station station : this.otpTransitService.siteRepository().listStations()) {
            if (!station.shouldRouteToCentroid()) continue;
            this.vertexFactory.stationCentroid(station);
        }
    }

    private void addPathwayNodesToGraph() {
        for (PathwayNode node : this.otpTransitService.getAllPathwayNodes()) {
            TransitPathwayNodeVertex nodeVertex = this.vertexFactory.transitPathwayNode(node);
            this.stationElementNodes.put(node, nodeVertex);
        }
    }

    private void addBoardingAreasToGraph() {
        for (BoardingArea boardingArea : this.otpTransitService.getAllBoardingAreas()) {
            TransitBoardingAreaVertex boardingAreaVertex = this.vertexFactory.transitBoardingArea(boardingArea);
            this.stationElementNodes.put(boardingArea, boardingAreaVertex);
            if (boardingArea.getParentStop() == null) continue;
            StationElementVertex platformVertex = this.stationElementNodes.get(boardingArea.getParentStop());
            boolean wheelchair = boardingArea.getWheelchairAccessibility() == Accessibility.POSSIBLE;
            PathwayEdge.createLowCostPathwayEdge(boardingAreaVertex, platformVertex, wheelchair, PathwayMode.WALKWAY);
            PathwayEdge.createLowCostPathwayEdge(platformVertex, boardingAreaVertex, wheelchair, PathwayMode.WALKWAY);
        }
    }

    private void createPathwayEdgesAndAddThemToGraph() {
        for (Pathway pathway : this.otpTransitService.getAllPathways()) {
            StationElementVertex fromVertex = this.stationElementNodes.get(pathway.getFromStop());
            StationElementVertex toVertex = this.stationElementNodes.get(pathway.getToStop());
            if (fromVertex != null && toVertex != null) {
                if (pathway.getPathwayMode() == PathwayMode.ELEVATOR) {
                    this.createElevatorEdgesAndAddThemToGraph(pathway, fromVertex, toVertex);
                    continue;
                }
                double distance = Optional.of(pathway.getLength()).filter(l -> l > 0.0).orElseGet(() -> SphericalDistanceLibrary.distance(fromVertex.getCoordinate(), toVertex.getCoordinate()));
                PathwayEdge.createPathwayEdge(fromVertex, toVertex, NonLocalizedString.ofNullable(pathway.getSignpostedAs()), pathway.getTraversalTime(), distance, pathway.getStairCount(), pathway.getSlope(), pathway.isPathwayModeWheelchairAccessible(), pathway.getPathwayMode());
                if (!pathway.isBidirectional()) continue;
                PathwayEdge.createPathwayEdge(toVertex, fromVertex, NonLocalizedString.ofNullable(pathway.getReverseSignpostedAs()), pathway.getTraversalTime(), distance, -1 * pathway.getStairCount(), -1.0 * pathway.getSlope(), pathway.isPathwayModeWheelchairAccessible(), pathway.getPathwayMode());
                continue;
            }
            if (fromVertex == null) {
                LOG.warn("The 'fromVertex' is missing for pathway from stop {}", pathway.getFromStop());
            }
            if (toVertex != null) continue;
            LOG.warn("The 'toVertex' is missing for pathway to stop {}", pathway.getToStop());
        }
    }

    private void createElevatorEdgesAndAddThemToGraph(Pathway pathway, StationElementVertex fromVertex, StationElementVertex toVertex) {
        StopLevel fromLevel = this.getStopLevel(fromVertex);
        StopLevel toLevel = this.getStopLevel(toVertex);
        double levels = 1.0;
        if (fromLevel.index() != null && toLevel.index() != null && !fromLevel.index().equals(toLevel.index())) {
            levels = Math.abs(fromLevel.index() - toLevel.index());
        }
        ElevatorVertex fromOnboardVertex = this.vertexFactory.elevator(fromVertex, AddTransitEntitiesToGraph.elevatorLabel(fromVertex, pathway), fromLevel.name().toString());
        ElevatorVertex toOnboardVertex = this.vertexFactory.elevator(toVertex, AddTransitEntitiesToGraph.elevatorLabel(toVertex, pathway), toLevel.name().toString());
        ElevatorBoardEdge.createElevatorBoardEdge(fromVertex, fromOnboardVertex);
        ElevatorAlightEdge.createElevatorAlightEdge(toOnboardVertex, toVertex, toLevel.name());
        StreetTraversalPermission permission = StreetTraversalPermission.PEDESTRIAN_AND_BICYCLE;
        ElevatorHopEdge.createElevatorHopEdge(fromOnboardVertex, toOnboardVertex, permission, Accessibility.POSSIBLE, levels, pathway.getTraversalTime());
        if (pathway.isBidirectional()) {
            ElevatorBoardEdge.createElevatorBoardEdge(toVertex, toOnboardVertex);
            ElevatorAlightEdge.createElevatorAlightEdge(fromOnboardVertex, fromVertex, fromLevel.name());
            ElevatorHopEdge.createElevatorHopEdge(toOnboardVertex, fromOnboardVertex, permission, Accessibility.POSSIBLE, levels, pathway.getTraversalTime());
        }
    }

    private static String elevatorLabel(StationElementVertex fromVertex, Pathway pathway) {
        return "%s_%s".formatted(fromVertex.getLabel(), pathway.getId());
    }

    private StopLevel getStopLevel(StationElementVertex vertex) {
        StationElement fromStation = vertex.getStationElement();
        org.opentripplanner.transit.model.site.StopLevel level = fromStation.level();
        return level != null ? new StopLevel(NonLocalizedString.ofNullableOrElse(level.name(), fromStation.getName()), level.index()) : new StopLevel(fromStation.getName(), null);
    }

    private void addFeedInfoToGraph(TimetableRepository timetableRepository) {
        for (FeedInfo info : this.otpTransitService.getAllFeedInfos()) {
            timetableRepository.addFeedInfo(info);
        }
    }

    private void addAgenciesToGraph(TimetableRepository timetableRepository) {
        for (Agency agency : this.otpTransitService.getAllAgencies()) {
            timetableRepository.addAgency(agency);
        }
    }

    private void addTransfersToGraph(TimetableRepository timetableRepository) {
        timetableRepository.getTransferService().addAll(this.otpTransitService.getAllTransfers());
    }

    private void addServicesToTimetableRepository(TimetableRepository timetableRepository) {
        for (FeedScopedId serviceId : this.otpTransitService.getAllServiceIds()) {
            timetableRepository.getServiceCodes().put(serviceId, timetableRepository.getServiceCodes().size());
        }
    }

    private void addTripPatternsToTimetableRepository(TimetableRepository timetableRepository) {
        Collection<TripPattern> tripPatterns = this.otpTransitService.getTripPatterns();
        for (TripPattern tripPattern : tripPatterns) {
            tripPattern.getScheduledTimetable().setServiceCodes(timetableRepository.getServiceCodes());
            timetableRepository.addTripPattern(tripPattern.getId(), tripPattern);
        }
    }

    private void addFlexTripsToGraph(TimetableRepository timetableRepository) {
        for (FlexTrip<?, ?> flexTrip : this.otpTransitService.getAllFlexTrips()) {
            timetableRepository.addFlexTrip(flexTrip.getId(), flexTrip);
        }
    }

    private record StopLevel(I18NString name, Double index) {
    }
}

