/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.graph_builder.issue.service;

import jakarta.inject.Singleton;
import java.util.ArrayList;
import java.util.List;
import org.opentripplanner.framework.error.OtpError;
import org.opentripplanner.graph_builder.issue.api.DataImportIssue;
import org.opentripplanner.graph_builder.issue.api.DataImportIssueStore;
import org.opentripplanner.graph_builder.issue.api.Issue;
import org.opentripplanner.graph_builder.issue.api.IssueWithSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class DefaultDataImportIssueStore
implements DataImportIssueStore {
    private static final Logger ISSUE_LOG = LoggerFactory.getLogger((String)"DATA_IMPORT_ISSUES");
    private final List<DataImportIssue> issues = new ArrayList<DataImportIssue>();
    private String currentSource = null;

    @Override
    public void add(DataImportIssue issue) {
        ISSUE_LOG.debug("{} - {}", (Object)issue.getType(), (Object)issue.getMessage());
        if (this.currentSource != null) {
            this.issues.add(new IssueWithSource(issue, this.currentSource));
        } else {
            this.issues.add(issue);
        }
    }

    @Override
    public void add(OtpError issue) {
        this.add(issue.errorCode(), issue.messageTemplate(), issue.messageArguments());
    }

    @Override
    public void add(String type, String message) {
        this.add(Issue.issue(type, message));
    }

    @Override
    public void add(String type, String message, Object ... arguments) {
        this.add(Issue.issue(type, message, arguments));
    }

    @Override
    public void startProcessingSource(String source) {
        this.currentSource = source;
    }

    @Override
    public void stopProcessingSource() {
        this.currentSource = null;
    }

    @Override
    public List<DataImportIssue> listIssues() {
        return this.issues;
    }

    public String toString() {
        throw new UnsupportedOperationException("Printing the DefaultDataImportIssueStore is not a good idea!");
    }
}

