/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.graph_builder.issue.report;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.opentripplanner.datastore.api.CompositeDataSource;
import org.opentripplanner.graph_builder.issue.api.DataImportIssue;
import org.opentripplanner.graph_builder.issue.api.DataImportIssueStore;
import org.opentripplanner.graph_builder.issue.report.Bucket;
import org.opentripplanner.graph_builder.issue.report.BucketKey;
import org.opentripplanner.graph_builder.issue.report.GeoJsonWriter;
import org.opentripplanner.graph_builder.issue.report.HTMLWriter;
import org.opentripplanner.graph_builder.model.GraphBuilderModule;
import org.opentripplanner.utils.logging.ProgressTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataImportIssueReporter
implements GraphBuilderModule {
    private static final Logger LOG = LoggerFactory.getLogger(DataImportIssueReporter.class);
    private final CompositeDataSource reportDirectory;
    private final int maxNumberOfIssuesPerFile;
    private final DataImportIssueStore issueStore;

    public DataImportIssueReporter(DataImportIssueStore issueStore, CompositeDataSource reportDirectory, int maxNumberOfIssuesPerFile) {
        this.issueStore = issueStore;
        this.reportDirectory = reportDirectory;
        this.maxNumberOfIssuesPerFile = maxNumberOfIssuesPerFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void buildGraph() {
        try {
            if (!this.deleteReportDirectoryAndContent()) {
                return;
            }
            List<Bucket> buckets = DataImportIssueReporter.partitionIssues(this.issueStore.listIssues(), this.maxNumberOfIssuesPerFile);
            List<BucketKey> keys = buckets.stream().map(Bucket::key).sorted().toList();
            ProgressTracker progress = ProgressTracker.track((String)"Creating data import issue report", (int)50, (long)buckets.size());
            LOG.info(progress.startMessage());
            for (Bucket bucket : buckets) {
                boolean addGeoJSONLink = new GeoJsonWriter(this.reportDirectory, bucket).writeFile();
                new HTMLWriter(this.reportDirectory, bucket, keys, addGeoJSONLink).writeFile();
                progress.step(m -> LOG.info(m));
            }
            try {
                HTMLWriter indexFileWriter = new HTMLWriter(this.reportDirectory, "index", keys);
                indexFileWriter.writeFile();
            }
            catch (Exception e) {
                LOG.error("Index file couldn't be created:{}", (Object)e.getMessage());
            }
            LOG.info(progress.completeMessage());
            LOG.info("Data import issue report is in {}", (Object)this.reportDirectory.path());
        }
        catch (Exception e) {
            LOG.error("OTP failed to save issue report!", (Throwable)e);
        }
        finally {
            this.closeReportDirectory();
        }
    }

    private boolean deleteReportDirectoryAndContent() {
        if (this.reportDirectory == null) {
            LOG.error("Saving folder is empty!");
            return false;
        }
        if (this.reportDirectory.exists()) {
            try {
                this.reportDirectory.delete();
            }
            catch (Exception e) {
                LOG.error("Failed to clean HTML report directory: " + this.reportDirectory.path() + ". HTML report won't be generated!", (Throwable)e);
                return false;
            }
        }
        return true;
    }

    static List<Bucket> partitionIssues(List<DataImportIssue> issues, int maxNumberOfIssuesPerFile) {
        Map<String, List<DataImportIssue>> issuesByType = issues.stream().collect(Collectors.groupingBy(DataImportIssue::getType));
        ArrayList<Bucket> buckets = new ArrayList<Bucket>();
        for (Map.Entry<String, List<DataImportIssue>> entry : issuesByType.entrySet()) {
            String key = entry.getKey();
            List<DataImportIssue> sortedIssues = entry.getValue().stream().sorted(Comparator.comparing(DataImportIssue::getPriority, Comparator.reverseOrder())).toList();
            if ((double)sortedIssues.size() > 1.2 * (double)maxNumberOfIssuesPerFile) {
                List partitions = Lists.partition(sortedIssues, (int)maxNumberOfIssuesPerFile);
                for (int i = 0; i < partitions.size(); ++i) {
                    buckets.add(new Bucket(new BucketKey(key, i + 1), (Collection)partitions.get(i)));
                }
                continue;
            }
            buckets.add(new Bucket(new BucketKey(key, null), sortedIssues));
        }
        return buckets;
    }

    private void closeReportDirectory() {
        try {
            this.reportDirectory.close();
        }
        catch (IOException e) {
            LOG.warn("Failed to close report directory: {}, details: {}. ", new Object[]{this.reportDirectory.path(), e.getLocalizedMessage(), e});
        }
    }
}

