/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.graph_builder.issue.api;

import org.opentripplanner.graph_builder.issue.api.DataImportIssue;
import org.opentripplanner.utils.tostring.ToStringBuilder;

public class Issue
implements DataImportIssue {
    private final String type;
    private final String message;
    private final Object[] arguments;

    private Issue(String type, String message, Object ... arguments) {
        this.type = type;
        this.message = message;
        this.arguments = arguments;
    }

    public static Issue issue(String type, String message) {
        return new Issue(type, message, new Object[0]);
    }

    public static Issue issue(String type, String message, Object ... arguments) {
        return new Issue(type, message, arguments);
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getMessage() {
        return String.format(this.message, this.arguments);
    }

    public String toString() {
        return ToStringBuilder.of(this.getClass()).addStr("type", this.type).addStr("message", this.getMessage()).toString();
    }
}

