/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.graph_builder;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.EnumSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.opentripplanner.datastore.OtpDataStore;
import org.opentripplanner.datastore.api.CompositeDataSource;
import org.opentripplanner.datastore.api.DataSource;
import org.opentripplanner.datastore.api.FileType;
import org.opentripplanner.datastore.api.OtpBaseDirectory;
import org.opentripplanner.ext.emission.parameters.EmissionFeedParameters;
import org.opentripplanner.framework.application.OtpAppException;
import org.opentripplanner.graph_builder.model.ConfiguredCompositeDataSource;
import org.opentripplanner.graph_builder.model.ConfiguredDataSource;
import org.opentripplanner.graph_builder.module.ned.parameter.DemExtractParameters;
import org.opentripplanner.graph_builder.module.ned.parameter.DemExtractParametersBuilder;
import org.opentripplanner.graph_builder.module.osm.parameters.OsmExtractParameters;
import org.opentripplanner.graph_builder.module.osm.parameters.OsmExtractParametersBuilder;
import org.opentripplanner.gtfs.config.GtfsFeedParameters;
import org.opentripplanner.netex.config.NetexFeedParameters;
import org.opentripplanner.standalone.config.BuildConfig;
import org.opentripplanner.standalone.config.CommandLineParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class GraphBuilderDataSources
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(GraphBuilderDataSources.class);
    private static final String BULLET_POINT = "- ";
    private final OtpDataStore store;
    private final Multimap<FileType, DataSource> inputData = ArrayListMultimap.create();
    private final Multimap<FileType, DataSource> skipData = ArrayListMultimap.create();
    private final Set<FileType> includeTypes = EnumSet.complementOf(EnumSet.of(FileType.UNKNOWN));
    private final File cacheDirectory;
    private final DataSource outputGraph;
    private final BuildConfig buildConfig;
    private final File baseDirectory;

    @Inject
    public GraphBuilderDataSources(CommandLineParameters cli, BuildConfig bc, OtpDataStore store, @OtpBaseDirectory File baseDirectory) {
        this.store = store;
        this.buildConfig = bc;
        this.cacheDirectory = cli.cacheDirectory;
        this.outputGraph = this.getOutputGraph(cli);
        this.baseDirectory = baseDirectory;
        this.include(cli.doBuildStreet(), FileType.OSM);
        this.include(cli.doBuildStreet(), FileType.DEM);
        this.include(cli.doBuildTransit(), FileType.GTFS);
        this.include(cli.doBuildTransit(), FileType.NETEX);
        this.selectFilesToImport();
        this.logSkippedAndSelectedFiles();
        this.validateCliMatchesInputData(cli);
    }

    public DataSource getOutputGraph() {
        return this.outputGraph;
    }

    public boolean has(FileType type) {
        return this.inputData.containsKey((Object)type);
    }

    public Iterable<ConfiguredDataSource<OsmExtractParameters>> getOsmConfiguredDataSource() {
        return this.ofStream(FileType.OSM).map(this::mapOsmData).toList();
    }

    public Iterable<ConfiguredDataSource<DemExtractParameters>> getDemConfiguredDataSource() {
        return this.ofStream(FileType.DEM).map(this::mapDemData).toList();
    }

    public Iterable<ConfiguredCompositeDataSource<GtfsFeedParameters>> getGtfsConfiguredDataSource() {
        return this.ofStream(FileType.GTFS).map(this::mapGtfsFeed).toList();
    }

    public Iterable<ConfiguredCompositeDataSource<NetexFeedParameters>> getNetexConfiguredDataSource() {
        return this.ofStream(FileType.NETEX).map(this::mapNetexFeed).toList();
    }

    public Iterable<ConfiguredDataSource<EmissionFeedParameters>> getEmissionConfiguredDataSource() {
        return this.ofStream(FileType.EMISSION).map(this::mapEmissionFeed).toList();
    }

    public Optional<DataSource> stopConsolidation() {
        return this.store.stopConsolidation();
    }

    public CompositeDataSource getBuildReportDir() {
        return this.store.getBuildReportDir();
    }

    public File getCacheDirectory() {
        return this.cacheDirectory;
    }

    @Override
    public void close() {
        for (DataSource dataSource : this.inputData.values()) {
            try {
                if (!(dataSource instanceof Closeable)) continue;
                Closeable closeable = (Closeable)((Object)dataSource);
                closeable.close();
            }
            catch (IOException e) {
                LOG.error("Failed to close datasource {}, details: {}", new Object[]{dataSource.path(), e.getLocalizedMessage(), e});
            }
        }
    }

    private ConfiguredDataSource<OsmExtractParameters> mapOsmData(DataSource dataSource) {
        OsmExtractParameters p = this.buildConfig.osm.parameters.stream().filter(osmExtractConfig -> this.uriMatch(osmExtractConfig.source(), dataSource.uri())).findFirst().orElse(new OsmExtractParametersBuilder(this.buildConfig.osmDefaults).withSource(dataSource.uri()).build());
        return new ConfiguredDataSource<OsmExtractParameters>(dataSource, p);
    }

    private ConfiguredDataSource<DemExtractParameters> mapDemData(DataSource dataSource) {
        DemExtractParameters p = this.buildConfig.dem.demExtracts().stream().filter(demExtractConfig -> this.uriMatch(demExtractConfig.source(), dataSource.uri())).findFirst().orElse(new DemExtractParametersBuilder(this.buildConfig.demDefaults).withSource(dataSource.uri()).build());
        return new ConfiguredDataSource<DemExtractParameters>(dataSource, p);
    }

    private ConfiguredCompositeDataSource<GtfsFeedParameters> mapGtfsFeed(DataSource dataSource) {
        GtfsFeedParameters p = this.buildConfig.transitFeeds.gtfsFeeds().stream().filter(gtfsFeedConfig -> this.uriMatch(gtfsFeedConfig.source(), dataSource.uri())).findFirst().orElse(this.buildConfig.gtfsDefaults.withFeedInfo().withSource(dataSource.uri()).build());
        return new ConfiguredCompositeDataSource<GtfsFeedParameters>((CompositeDataSource)dataSource, p);
    }

    private ConfiguredCompositeDataSource<NetexFeedParameters> mapNetexFeed(DataSource dataSource) {
        NetexFeedParameters p = this.buildConfig.transitFeeds.netexFeeds().stream().filter(netexFeedConfig -> this.uriMatch(netexFeedConfig.source(), dataSource.uri())).findFirst().orElse(this.buildConfig.netexDefaults.copyOf().withSource(dataSource.uri()).build());
        return new ConfiguredCompositeDataSource<NetexFeedParameters>((CompositeDataSource)dataSource, p);
    }

    private ConfiguredDataSource<EmissionFeedParameters> mapEmissionFeed(DataSource dataSource) {
        EmissionFeedParameters p = this.buildConfig.emission.feeds().stream().filter(c -> this.uriMatch(c.source(), dataSource.uri())).findFirst().orElseThrow();
        return new ConfiguredDataSource<EmissionFeedParameters>(dataSource, p);
    }

    private boolean uriMatch(URI configURI, URI datasourceURI) {
        return configURI.equals(datasourceURI) || !configURI.isAbsolute() && this.baseDirectory.toPath().resolve(configURI.toString()).toUri().equals(datasourceURI);
    }

    private boolean hasOneOf(FileType ... types) {
        for (FileType type : types) {
            if (!this.has(type)) continue;
            return true;
        }
        return false;
    }

    private void logSkippedAndSelectedFiles() {
        LOG.info("Data source location(s): {}", (Object)String.join((CharSequence)", ", this.store.getRepositoryDescriptions()));
        LOG.info("Existing files expected to be read or written:");
        for (FileType type : FileType.values()) {
            for (DataSource source : this.inputData.get((Object)type)) {
                LOG.info("- {}", (Object)source.detailedInfo());
            }
        }
        if (!this.skipData.values().isEmpty()) {
            LOG.info("Files excluded due to command line switches or unknown type:");
            for (FileType type : FileType.values()) {
                for (DataSource source : this.skipData.get((Object)type)) {
                    LOG.info("- {}", (Object)source.detailedInfo());
                }
            }
        }
    }

    private void validateCliMatchesInputData(CommandLineParameters cli) {
        if (cli.build) {
            if (!this.hasOneOf(FileType.OSM, FileType.GTFS, FileType.NETEX)) {
                throw new OtpAppException("Unable to build graph, no transit nor OSM data available.");
            }
        } else if (cli.buildStreet) {
            if (!this.has(FileType.OSM)) {
                throw new OtpAppException("Unable to build street graph, no OSM data available.");
            }
        } else if (cli.load) {
            if (!this.store.getGraph().exists()) {
                throw new OtpAppException("Unable to load graph, no graph file found: %s", this.store.getGraph().path());
            }
        } else if (cli.loadStreet) {
            if (!this.store.getStreetGraph().exists()) {
                throw new OtpAppException("Unable to load street graph, no street graph file found: %s", this.store.getStreetGraph().path());
            }
            if (!this.hasOneOf(FileType.GTFS, FileType.NETEX)) {
                throw new OtpAppException("Unable to build transit graph, no transit data available.");
            }
        }
    }

    private DataSource getOutputGraph(CommandLineParameters cli) {
        if (cli.doSaveGraph()) {
            return this.store.getGraph();
        }
        if (cli.doSaveStreetGraph()) {
            return this.store.getStreetGraph();
        }
        return null;
    }

    private void include(boolean include, FileType type) {
        if (include) {
            this.includeTypes.add(type);
        } else {
            this.includeTypes.remove((Object)type);
        }
    }

    private void selectFilesToImport() {
        for (FileType type : FileType.values()) {
            if (this.includeTypes.contains((Object)type)) {
                this.inputData.putAll((Object)type, this.store.listExistingSourcesFor(type));
                continue;
            }
            this.skipData.putAll((Object)type, this.store.listExistingSourcesFor(type));
        }
    }

    private Stream<DataSource> ofStream(FileType type) {
        return this.inputData.get((Object)type).stream();
    }
}

