/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.graph_builder;

import java.io.Closeable;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.opentripplanner.datastore.api.FileType;
import org.opentripplanner.ext.emission.EmissionRepository;
import org.opentripplanner.ext.stopconsolidation.StopConsolidationRepository;
import org.opentripplanner.framework.application.OTPFeature;
import org.opentripplanner.framework.application.OtpAppException;
import org.opentripplanner.graph_builder.GraphBuilderDataSources;
import org.opentripplanner.graph_builder.issue.api.DataImportIssueStore;
import org.opentripplanner.graph_builder.issue.api.DataImportIssueSummary;
import org.opentripplanner.graph_builder.model.GraphBuilderModule;
import org.opentripplanner.graph_builder.module.configure.DaggerGraphBuilderFactory;
import org.opentripplanner.graph_builder.module.configure.GraphBuilderFactory;
import org.opentripplanner.routing.fares.FareServiceFactory;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.service.osminfo.OsmInfoGraphBuildRepository;
import org.opentripplanner.service.vehicleparking.VehicleParkingRepository;
import org.opentripplanner.service.worldenvelope.WorldEnvelopeRepository;
import org.opentripplanner.standalone.config.BuildConfig;
import org.opentripplanner.street.model.StreetLimitationParameters;
import org.opentripplanner.transit.service.TimetableRepository;
import org.opentripplanner.utils.lang.OtpNumberFormat;
import org.opentripplanner.utils.time.DurationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphBuilder
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(GraphBuilder.class);
    private final List<GraphBuilderModule> graphBuilderModules = new ArrayList<GraphBuilderModule>();
    private final Graph graph;
    private final TimetableRepository timetableRepository;
    private final DataImportIssueStore issueStore;
    private final Closeable closeDataSourcesHandle;
    private boolean hasTransitData = false;

    public GraphBuilder(Graph baseGraph, TimetableRepository timetableRepository, DataImportIssueStore issueStore, Closeable closeDataSourcesHandle) {
        this.graph = baseGraph;
        this.timetableRepository = timetableRepository;
        this.issueStore = issueStore;
        this.closeDataSourcesHandle = closeDataSourcesHandle;
    }

    public static GraphBuilder create(BuildConfig config, GraphBuilderDataSources dataSources, Graph graph, OsmInfoGraphBuildRepository osmInfoGraphBuildRepository, FareServiceFactory fareServiceFactory, TimetableRepository timetableRepository, WorldEnvelopeRepository worldEnvelopeRepository, VehicleParkingRepository vehicleParkingService, @Nullable EmissionRepository emissionRepository, @Nullable StopConsolidationRepository stopConsolidationRepository, StreetLimitationParameters streetLimitationParameters, boolean loadStreetGraph, boolean saveStreetGraph) {
        boolean hasOsm = dataSources.has(FileType.OSM);
        boolean hasGtfs = dataSources.has(FileType.GTFS);
        boolean hasNetex = dataSources.has(FileType.NETEX);
        boolean hasTransitData = hasGtfs || hasNetex;
        timetableRepository.initTimeZone(config.transitModelTimeZone);
        GraphBuilderFactory.Builder builder = DaggerGraphBuilderFactory.builder();
        builder.config(config).graph(graph).osmInfoGraphBuildRepository(osmInfoGraphBuildRepository).timetableRepository(timetableRepository).worldEnvelopeRepository(worldEnvelopeRepository).vehicleParkingRepository(vehicleParkingService).stopConsolidationRepository(stopConsolidationRepository).emissionRepository(emissionRepository).streetLimitationParameters(streetLimitationParameters).fareServiceFactory(fareServiceFactory).dataSources(dataSources).timeZoneId(timetableRepository.getTimeZone());
        GraphBuilderFactory factory = builder.build();
        GraphBuilder graphBuilder = factory.graphBuilder();
        graphBuilder.hasTransitData = hasTransitData;
        if (hasOsm) {
            graphBuilder.addModule(factory.osmModule());
        }
        if (hasGtfs) {
            graphBuilder.addModule(factory.gtfsModule());
        }
        if (hasNetex) {
            graphBuilder.addModule(factory.netexModule());
        }
        if (hasTransitData) {
            graphBuilder.addModuleOptional(factory.stopConsolidationModule());
            graphBuilder.addModule(factory.tripPatternNamer());
            graphBuilder.addModuleOptional((GraphBuilderModule)factory.timeZoneAdjusterModule(), timetableRepository.getAgencyTimeZones().size() > 1);
            if (hasOsm || graphBuilder.graph.hasStreets) {
                graphBuilder.addModule(factory.osmBoardingLocationsModule());
            }
        }
        graphBuilder.addModule(factory.streetLinkerModule());
        if (hasOsm) {
            graphBuilder.addModule(factory.turnRestrictionModule());
        }
        if (hasOsm && !saveStreetGraph || loadStreetGraph) {
            graphBuilder.addModule(factory.pruneIslands());
        }
        for (GraphBuilderModule graphBuilderModule : factory.elevationModules()) {
            graphBuilder.addModule(graphBuilderModule);
        }
        if (hasTransitData) {
            graphBuilder.addModuleOptional((GraphBuilderModule)factory.areaStopsToVerticesMapper(), OTPFeature.FlexRouting);
            graphBuilder.addModule(factory.directTransferGenerator());
            graphBuilder.addModuleOptional((GraphBuilderModule)factory.directTransferAnalyzer(), OTPFeature.TransferAnalyzer);
            graphBuilder.addModuleOptional((GraphBuilderModule)factory.emissionGraphBuilder(), OTPFeature.Emission);
        }
        if (loadStreetGraph || hasOsm) {
            graphBuilder.addModule(factory.graphCoherencyCheckerModule());
        }
        graphBuilder.addModuleOptional(factory.routeToCentroidStationIdValidator());
        graphBuilder.addModuleOptional((GraphBuilderModule)factory.dataImportIssueReporter(), config.dataImportReport);
        graphBuilder.addModuleOptional((GraphBuilderModule)factory.dataOverlayFactory(), OTPFeature.DataOverlay);
        graphBuilder.addModule(factory.calculateWorldEnvelopeModule());
        return graphBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            long startTime = System.currentTimeMillis();
            for (GraphBuilderModule builder : this.graphBuilderModules) {
                builder.checkInputs();
            }
            for (GraphBuilderModule load : this.graphBuilderModules) {
                load.buildGraph();
            }
            new DataImportIssueSummary(this.issueStore.listIssues()).logSummary();
            GraphBuilder.logGraphBuilderCompleteStatus(startTime, this.graph, this.timetableRepository);
            this.validate();
        }
        finally {
            this.closeDataSources();
        }
    }

    private void addModuleOptional(@Nullable GraphBuilderModule module, OTPFeature feature) {
        this.addModuleOptional(module, feature.isOn());
    }

    private void addModuleOptional(@Nullable GraphBuilderModule module, boolean enabled) {
        if (enabled) {
            this.addModuleOptional(module);
        }
    }

    private void addModuleOptional(@Nullable GraphBuilderModule module) {
        if (module != null) {
            this.addModule(module);
        }
    }

    private void addModule(GraphBuilderModule module) {
        this.graphBuilderModules.add(Objects.requireNonNull(module));
    }

    private boolean hasTransitData() {
        return this.hasTransitData;
    }

    public DataImportIssueSummary issueSummary() {
        return new DataImportIssueSummary(this.issueStore.listIssues());
    }

    private void validate() {
        if (this.hasTransitData() && !this.timetableRepository.hasTransit()) {
            throw new OtpAppException("The provided transit data have no trips within the configured transit service period. There is something wrong with your data - see the log above. Another possibility is that the 'transitServiceStart' and 'transitServiceEnd' are not correctly configured.");
        }
    }

    private void closeDataSources() {
        try {
            this.closeDataSourcesHandle.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void logGraphBuilderCompleteStatus(long startTime, Graph graph, TimetableRepository timetableRepository) {
        long endTime = System.currentTimeMillis();
        String time = DurationUtils.durationToStr((Duration)Duration.ofMillis(endTime - startTime));
        OtpNumberFormat f = new OtpNumberFormat();
        String nStops = f.formatNumber((Number)timetableRepository.getSiteRepository().stopIndexSize());
        String nPatterns = f.formatNumber((Number)timetableRepository.getAllTripPatterns().size());
        String nTransfers = f.formatNumber((Number)timetableRepository.getTransferService().listAll().size());
        String nVertices = f.formatNumber((Number)graph.countVertices());
        String nEdges = f.formatNumber((Number)graph.countEdges());
        LOG.info("Graph building took {}.", (Object)time);
        LOG.info("Graph built.   |V|={} |E|={}", (Object)nVertices, (Object)nEdges);
        LOG.info("Transit built. |Stops|={} |Patterns|={} |ConstrainedTransfers|={}", new Object[]{nStops, nPatterns, nTransfers});
    }
}

