/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.framework.token;

import java.time.Duration;
import java.time.Instant;
import javax.annotation.Nullable;
import org.opentripplanner.utils.time.DurationUtils;

public enum TokenType {
    BOOLEAN,
    BYTE,
    DURATION,
    ENUM,
    INT,
    STRING,
    TIME_INSTANT;

    private static final String EMPTY = "";

    boolean isNot(TokenType other) {
        return this != other;
    }

    public String valueToString(@Nullable Object value) {
        if (value == null) {
            return EMPTY;
        }
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> Boolean.toString((Boolean)value);
            case 1 -> Byte.toString((Byte)value);
            case 2 -> DurationUtils.durationToStr((Duration)((Duration)value));
            case 3 -> ((Enum)value).name();
            case 4 -> Integer.toString((Integer)value);
            case 5 -> (String)value;
            case 6 -> value.toString();
        };
    }

    public Object stringToValue(String value) {
        if (EMPTY.equals(value)) {
            return null;
        }
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> Boolean.valueOf(value);
            case 1 -> Byte.valueOf(value);
            case 2 -> DurationUtils.duration((String)value);
            case 3 -> value;
            case 4 -> Integer.valueOf(value);
            case 5 -> value;
            case 6 -> Instant.parse(value);
        };
    }
}

